<?php
namespace App\Console\Commands;

use Carbon\Carbon;
use App\Models\Admin;
use Illuminate\Console\Command;
use App\Http\Services\PaymentServices;

class Account extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'user:balance';

    /**
     * The console commands description.
     *
     * @var string
     */
    protected $description = 'Check central account balance';


    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }


    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle(PaymentServices $payment)
    {
		$payName = [101 => 'shpay', 102 => 'gtr'];
		$now                = Carbon::now();
		
        try{

			$checkPayment = $payment->balance('gtr');

			dd($checkPayment);
			
			if( $checkPayment ){
				if( $checkPayment['msg'] == 'success'){
					$record = $checkPayment['data'];
					dd($record);
					
				}else{

					dd($checkPayment);
				}
			}
			
			$this->info('Payments updated');

		}catch(\Exception $ex){
			$this->info($ex->getMessage());
			//$admin = Admin::first();
            //sendGeneralEmail($admin->email, $ex->getMessage(), $ex->getMessage(), '');
        }
		
    }
	
}