<?php
namespace App\Console\Commands;

use Carbon\Carbon;
use App\Models\Admin;
use App\Models\Coupon;
use Illuminate\Console\Command;

class CExpire extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'coupon:expire';

    /**
     * The console commands description.
     *
     * @var string
     */
    protected $description = 'Works on system coupon for expired ones';


    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }


    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        try{

            $coupons = Coupon::where('expired_date', '<=', Carbon::now())
                ->get();


            //return $coupon;
            foreach($coupons as $index => $data){

                // Make expired coupon
                $data->expired = 1;
                $data->save();

            }

        }catch(\Exception $ex){
            $admin = Admin::first();
            sendGeneralEmail($admin->email, $ex->getMessage(), $ex->getMessage(), '');
            \Log::error('CronController -> couponExpired() line '. __LINE__ .': '.$ex->getMessage() ."\n");
        }
		
    }
}
