<?php
namespace App\Console\Commands;

use Carbon\Carbon;
use App\Models\Admin;
use App\Models\Coupon;
use Illuminate\Console\Command;

class Couponcode extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'system:coupon';

    /**
     * The console commands description.
     *
     * @var string
     */
    protected $description = 'Works on system coupon';


    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }


    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        try{

            $coupons = Coupon::where('started', 0)
                ->where('start_date', '<=', Carbon::now())
                ->get();


            //return $coupon;
            foreach($coupons as $index => $data){

                // Make available coupon
                $data->started = 1;
                $data->start_date = null;

                $data->save();

            }

			$this->info('Updated coupon codes');
        }catch(\Exception $ex){
			$this->info($ex->getMessage());
            $admin = Admin::first();
            sendGeneralEmail($admin->email, $ex->getMessage(), $ex->getMessage(), '');
            \Log::error('CronController -> couponStart() line '. __LINE__ .': '.$ex->getMessage() ."\n");
        }

		
    }
}
