<?php
namespace App\Console\Commands;

use Carbon\Carbon;
use App\Models\Deposit;
use App\Lib\CurlRequest;
use Illuminate\Console\Command;
use App\Http\Controllers\Gateway\PaymentController;


class Flutterpay extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'pay:flutter';

    /**
     * The console commands description.
     *
     * @var string
     */
    protected $description = 'Checks users payment for crediting';


    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }


    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $deposit = Deposit::where('status', '0')->where('method_code', 109)->with('gateway')->get();
		
		foreach( $deposit as $inc ){
			
			$flutterAcc = json_decode($inc->gatewayCurrency()->gateway_parameter);

			if( $flutterAcc ){
				$secret_key = $flutterAcc->secret_key;
				
				$response       = CurlRequest::curlContent('https://api.flutterwave.com/v3/transactions/verify_by_reference?tx_ref='.$inc->trx, 
				[
					"Authorization: Bearer $secret_key",
					'Content-Type: application/json',
				]);
				$result = json_decode($response);
				
				if ($result && isset($result->data)) {

                    if ($result->data->status=='successful' ) {
						$inc->initiate = null;
						$inc->try = 2;
						$inc->detail = $result->data;
						$inc->update();
						PaymentController::userDataUpdate($inc);
					}
				}
			}
			
		}
	
		$this->info('All deposited fund credited');
    }
}
