<?php
namespace App\Console\Commands;

use App\Models\Admin;
use App\Models\Investment;
use App\Models\Plan;
use App\Models\User;
use App\Models\Transaction;
use App\Models\Coupon;
use Carbon\Carbon;
use App\Models\GeneralSetting;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Config;


class Miners extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'mine:interest';

    /**
     * The console commands description.
     *
     * @var string
     */
    protected $description = 'Runs users investment interest';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {

        try{

            ini_set("memory_limit",-1);
            ini_set('max_execution_time', 0);

			$now                = Carbon::now();
			$general            = GeneralSetting::first();
			$general->last_cron = $now;
			$general->save();
			
            $investments = Investment::where('status', 0)  // Status: 0=>Running, 1=>Completed
                ->where('next_return_date', '<=', $now)
                ->get();
			$nextRun = $now->addMinutes(1435);
				

            //return $investments;
			foreach($investments as $index => $data){

				$data->next_return_date = $nextRun;
				$data->total_paid += 1;
				$data->is_started = 1;

				$endTime = Carbon::parse($data->created_at)->addDays($data->total_return)->timestamp;
				if( $endTime < now()->timestamp ){
					$data->status = 1;
				}

				$data->save();
			}
			
			if ( !$investments->isEmpty()) {
				$this->info('Investors investment updated');
				\Log::info('Investors investment updated');
			}else{
				\Log::info('List of investors is empty. so check back');
			}

        }catch(\Exception $ex){
			$this->info($ex->getMessage());
            \Log::error('CronController -> investment() line '. __LINE__ .': '.$ex->getMessage() ."\n");
        }

    }
}
