<?php
namespace App\Console\Commands;

use Carbon\Carbon;
use App\Models\Deposit;
use Illuminate\Console\Command;
use App\Http\Controllers\Gateway\PaymentController;

class Nowpay extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'pay:nowpay';

    /**
     * The console commands description.
     *
     * @var string
     */
    protected $description = 'Checks users payment for crediting';


    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }


    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
		$_3HoursBack = Carbon::now()->subHours(3);
        $deposit = Deposit::where('status', '0')->where('method_code', '123')->where('initiate', '>', $_3HoursBack)->with('gateway')->get();
		
		foreach( $deposit as $inc ){
			
			$coinPayAcc = json_decode($inc->gateway->parameters);

			if( $coinPayAcc ){
				$cps = new PaymentsAPI($coinPayAcc->api_key->value);
				
				$data = $cps->getPaymentStatus($inc->txn_id);
				$result = json_decode($data, true);
				
				if ($result && isset($result['payment_id'])) {
                    if ($result['payment_status'] == 'confirmed' || $result['payment_status'] == 'finished') {
						PaymentController::userDataUpdate($inc);
					}elseif( $result['payment_status'] == 'patial_sent' ){
						$inc->amount = $result['actually_paid'];
						$inc->save();
						PaymentController::userDataUpdate($inc);
					}
				}
			}
		}
		
		$this->info('All deposited fund credited/Canceled');
    }
}
