<?php
namespace App\Console\Commands;

use Carbon\Carbon;
use App\Models\Deposit;
use App\Lib\CurlRequest;
use Illuminate\Console\Command;
use App\Http\Controllers\Gateway\PaymentController;


class Oxapay extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'oxa:pay';

    /**
     * The console commands description.
     *
     * @var string
     */
    protected $description = 'Checks users payment for crediting';


    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }


    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
		$_3HoursBack = Carbon::now()->addHours(16);
		$deposit = Deposit::where('status', '0')->where('try', 1)->where('method_code', '205')->with('gateway')->get();
		
		foreach( $deposit as $inc ){

			$config = json_decode($inc->gatewayCurrency()->gateway_parameter);

			$response       = CurlRequest::curlStream('https://api.oxapay.com/merchants/inquiry', [
				'merchant' 			=> $config->merchant_key,
				'trackId' 			=> $inc->trx_source,
			]);

			if( $response->result && isset($response->trackId) ){
				
				if( $response->status == 'Paid'){
					PaymentController::userDataUpdate($inc);
				}elseif($response->status == 'Expired'){
					$inc->admin_feedback = 'payment time expired';
					$inc->status = 3;
					$inc->save();
				}
			}else{
				$this->info($response->message);
			}
		}
		
		$this->info('All deposited fund credited/Canceled');
    }
}
