<?php
namespace App\Console\Commands;

use Carbon\Carbon;
use App\Models\Plan;
use App\Models\Admin;
use Illuminate\Console\Command;

class Package extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'plan:unlock';

    /**
     * The console commands description.
     *
     * @var string
     */
    protected $description = 'Update package lock and unlock them';


    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }


    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        try{

            $plan = Plan::where('p_status', 'coming')
                ->where('lock_endat', '<=', Carbon::now())
                ->get();

            //return $plan;
            foreach($plan as $index => $data){

                // Make available plan
                $data->p_status = 'to_buy';
                $data->lock_limit = 0;

                $data->save();
            }
			
			$this->info('Updated packages');

        }catch(\Exception $ex){
			$this->info($ex->getMessage());
            $admin = Admin::first();
            sendGeneralEmail($admin->email, $ex->getMessage(), $ex->getMessage(), '');
            \Log::error('CronController -> lockedPlan() line '. __LINE__ .': '.$ex->getMessage() ."\n");
        }

		
    }
}
