<?php
namespace App\Console\Commands;

use App\Models\Admin;
use App\Models\Investment;
use App\Models\Plan;
use App\Models\User;
use App\Models\Transaction;
use App\Models\RewardPlan;
use App\Models\Coupon;
use Carbon\Carbon;
use App\Models\GeneralSetting;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Config;

class Salary extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'app:salary';

    /**
     * The console commands description.
     *
     * @var string
     */
    protected $description = 'Checks users payment for crediting';


    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }


    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {

        try{

            ini_set("memory_limit",-1);
            ini_set('max_execution_time', 0);

            Config::set('app.timezone', 'Africa/Lagos');
            $now = Carbon::now();

            $isSundayAtTen = ($now->dayOfWeek == Carbon::SUNDAY);
            
            if(!$isSundayAtTen) throw new \Exception("Sorry not ready");
            

            $users = User::where('status', 1)->get();


            foreach($users as $index => $user){

                $user_id = $user->id;

                // Referrals
                $referrals = Investment::with('user')->with('plan')->where(['currency' => session()->get('currency')])->whereHas('user', function ($query) use ($user_id) {
                    $query->where('ref_by', $user_id);
                })->distinct('user_id')->count();

                $paidLevel = Transaction::where(['user_id' => $user_id, 'type' => 'salary'])->sum('number');
                $referrals = max(0, $referrals - $paidLevel);

                // Skip
                if(!$referrals) continue;

                $rewards = RewardPlan::where(['type' => 2, 'status' => 1])->orderBy('id')->get();

                $levelNumber = 0;
                $currentLevel = 0;

                foreach ($rewards as $key => $reward) {
                
                    $activeNumber = 0;
                    $previousIndex = ($key > 0) ? $key - 1 : 0;
                    $previousItem = ($previousIndex !== null) ? $rewards[$previousIndex] : null;

                    if ($referrals >= $reward->number) {
                        $activeNumber = $reward->number;
                        $levelNumber = $reward->number;
                        $currentLevel = $reward->id;
                    }

                    // Last loop
                    if(!$previousIndex) {
                        /*$status = $rewards[$key - 1];*/
                        $levelNumber = $referrals - $previousItem->number;
                        $activeNumber = max(0, $levelNumber);
                        $levelNumber = $activeNumber;
                        $referrals = $levelNumber;
                        $activeNumber = ($activeNumber >= $reward->number) ? $reward->number : $activeNumber - $reward->number;
                        $activeNumber = max(0, $activeNumber);
                    }
                }

                // Skip
                if(!$currentLevel) continue;

                // Find reward
                $reward = RewardPlan::where(['type' => 2, 'status' => 1, 'id' => $currentLevel])->first();
                
                $today = Carbon::now()->toDateString();

                // Check if already action
                $todayRecords = Transaction::where(['user_id' => $user_id, 'type' => 'salary'])->whereDate('created_at', $today)->get();

                if(!empty($todayRecords->count())) continue;

                // NGN Currency
                if($reward->currency == 'NGN') {
                    $user->pending_income += $reward->amount;
                    $user->save();
                    $post_balance = $user->pending_income;
                }

                // USDT Currency
                if($reward->currency == 'USDT') {
                    $user->usdt_pending_income += $reward->amount;
                    $user->save();
                    $post_balance = $user->usdt_pending_income;
                }

                // Add Transaction records
                $transaction = new Transaction();
                $transaction->user_id = $user_id;
                $transaction->type =  'salary';
                $transaction->amount = $reward->amount;
                $transaction->post_balance = $post_balance;
                $transaction->charge = '0';
                $transaction->currency = $reward->currency;
                $transaction->trx_type = '+';
                $transaction->details = $reward->summary;
                $transaction->number = $reward->number;
                $transaction->trx =  getTrx();
                $transaction->status =  1;
                $transaction->save();

            }

			$this->info('All salary paid');

        }catch(\Exception $ex){
			$this->info($ex->getMessage());
            $admin = Admin::first();
            sendGeneralEmail($admin->email, $ex->getMessage(), $ex->getMessage(), '');
            \Log::error('CronController -> salary() line '. __LINE__ .': '.$ex->getMessage() ."\n");
        }

    }
}
