<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;

class Kernel extends ConsoleKernel
{
    /**
     * The php artisan vest:interest commands provided by your application.
     *
     * @var array
     */
    protected $commands = [
      Commands\Payin::class,
      Commands\Payout::class,
      Commands\Package::class,
      //Commands\Profits::class,
      //Commands\Interest::class,
      Commands\Miners::class,
      Commands\Salary::class,
      Commands\Couponcode::class,
      Commands\CExpire::class,
      Commands\Nowpay::class,
      Commands\Flutterpay::class,
    ];

    /**
     * Define the application's command schedule.
     *
     * @param  \Illuminate\Console\Scheduling\Schedule  $schedule
     * @return void
     */
    protected function schedule(Schedule $schedule)
    {
        //$schedule->command('mine:interest')->dailyAt('23:59');
        $schedule->command('mine:interest')->everyFiveMinutes();
        $schedule->command('app:payout')->everyFiveMinutes();
        $schedule->command('app:payin')->everyFiveMinutes();
        //$schedule->command('app:interest')->everyTenMinutes();
		//$schedule->command('vest:interest')->everyTenMinutes();
        //$schedule->command('plan:unlock')->dailyAt('23:59');
        //$schedule->command('app:salary')->dailyAt('11:59');
        //$schedule->command('system:coupon')->hourly();
		//$schedule->command('coupon:expire')->dailyAt('23:59');

        //$schedule->command('oxa:pay')->everyFiveMinutes();
        //$schedule->command('pay:nowpay')->everyFiveMinutes();
        //$schedule->command('pay:flutter')->everyFiveMinutes();
		
    }

    /**
     * Register the commands for the application.
     *
     * @return void
     */
    protected function commands()
    {
        $this->load(__DIR__.'/Commands');

        require base_path('routes/console.php');
    }
}