<?php

namespace App\Http\Component;

use App\Http\Controllers\Controller;

/**
 * Laravel/Symfony Developer
 * Name: Muongozo
 * Telegram: @muongozotrader
 * Hire me via Telegram: muongozotrader
 */
class AppController extends Controller
{
    
    protected function handleResponse($request, $message, $status, $notify = [])
    {
        if ($request->ajax()) {
            return response()->json(['status' => $status, 'data' => $notify, 'message' => $message], $status);
        } else {
            return back()->withNotify($notify);
        }
    }

    protected function handleResponseRedirect($request, $message, $status, $link = null, $routername = null, $notify = [], $param = [])
    {
        if ($request->ajax()) {
            return response()->json(['status' => $status, 'link' => $link, 'message' => $message], $status);
        } else {
            // With Router
            if($routername) return redirect()->route($routername, $param)->withNotify($notify);

            // With link
            return redirect($link);
        }
    }
}
