<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Coupon;
use Illuminate\Http\Request;
use App\Models\Plan;
use App\Models\User;
use Carbon\Carbon;

class CouponController extends Controller
{


    public function index(){
        $pageTitle = 'Users Coupons';
        $coupons = Coupon::with('user')->latest()->paginate(getPaginate());
        $emptyMessage = 'Data Not Found';
        return view('admin.coupon.index', compact('pageTitle', 'coupons', 'emptyMessage'));
    }

    public function create(Request $request){

        $request->validate([
            'username'=> 'required|string|max:191',
            'type'=> 'required|string',
            'label'=> 'string',
            'discount'=> 'required|numeric',
            //'started'=> 'required|in:0,1',
            //'start_date'=> 'string',
            'expired_date'=> 'required|string',
            'status'=> 'required|in:0,1',
        ]);

        $user = User::where('username', $request->username)->first();

        if(!$user) {
            $notify[] = ['error', 'Coupon failed created due to invalid username'];
            return redirect()->back()->withNotify($notify);
        }

        //$startDate = ($request->start_date) ? Carbon::createFromFormat('Y-m-d', $request->start_date, 'Africa/Lagos') : null;
        $expiredDate = Carbon::createFromFormat('Y-m-d', $request->expired_date, 'Africa/Lagos');

        $coupon = new Coupon();
        $coupon->user_id = $user->id;
        $coupon->type = $request->type;
        $coupon->label = $request->label;
        $coupon->discount = $request->discount;
        $coupon->started = 1;
        //$coupon->start_date = $startDate;
        $coupon->expired = 0;
        $coupon->expired_date = $expiredDate;
        $coupon->code = verificationCode(8);
        $coupon->status = $request->status;
        $coupon->save();

        $notify[] = ['success', 'Coupon created successfully'];
        return redirect()->back()->withNotify($notify);

    }

    public function edit(Request $request){
        
        $request->validate([
            'id'=> 'required|exists:coupons,id',
            'username'=> 'required|string|max:191',
            'type'=> 'required|string',
            'label'=> 'string',
            'discount'=> 'required|numeric',
            'expired_date'=> 'required|string',
            'status'=> 'required|in:0,1',
        ]);

        $user = User::where('username', $request->username)->first();

        if(!$user) {
            $notify[] = ['error', 'Coupon failed created due to invalid username'];
            return redirect()->back()->withNotify($notify);
        }
        
        $expiredDate = Carbon::createFromFormat('Y-m-d', $request->expired_date, 'Africa/Lagos');

        $findCoupon = Coupon::find($request->id);
        $findCoupon->user_id = $user->id;
        $findCoupon->type = $request->type;
        $findCoupon->label = $request->label;
        $findCoupon->discount = $request->discount;
        $findCoupon->started = 1;
        $findCoupon->expired_date = $expiredDate;
        $findCoupon->status = $request->status;
        $findCoupon->save();

        $notify[] = ['success', 'Coupon updated successfully'];
        return redirect()->back()->withNotify($notify);
    }

}
