<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Frontend;
use App\Models\GeneralSetting;
use App\Rules\FileTypeValidate;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Artisan;
use Image;

class GeneralSettingController extends Controller
{
    public function index()
    {
        $general = config('settings');
        $pageTitle = 'General Setting';
        $timezones = json_decode(file_get_contents(resource_path('views/admin/partials/timezone.json')));
        return view('admin.setting.general_setting', compact('pageTitle', 'general','timezones'));
    }

    public function update(Request $request)
    {
        $request->validate([
            'base_color' => 'nullable', 'regex:/^[a-f0-9]{6}$/i',
            'secondary_color' => 'nullable', 'regex:/^[a-f0-9]{6}$/i',
            'timezone' => 'required',
        ]);

        $general = GeneralSetting::first();

        $general->ev = $request->ev ? 1 : 0;
        $general->en = $request->en ? 1 : 0;
        $general->sv = $request->sv ? 1 : 0;
        $general->sn = $request->sn ? 1 : 0;
        $general->use_link_bonus = $request->use_link_bonus ? 1 : 0;
        $general->use_link_amount = $request->use_link_amount;
        $general->use_link_redeem_percent = $request->use_link_redeem_percent;
        $general->force_ssl = $request->force_ssl ? 1 : 0;
        $general->withdrawal_active = $request->withdrawal_active ? 1 : 0;
        $general->withdraw_time = $request->withdraw_time ? 1 : 0;
        $general->once_withdrawal_aday = $request->once_withdrawal_aday ? 1 : 0;
        $general->registration = $request->registration ? 1 : 0;
        $general->agree = $request->agree ? 1 : 0;
        $general->enable_telegram_share = $request->enable_telegram_share ? 1 : 0;
        $general->enable_whatsapp_share = $request->enable_whatsapp_share ? 1 : 0;
        $general->auto_deposit = $request->auto_deposit ? 1 : 0;
        $general->auto_transfer = $request->auto_transfer ? 1 : 0;
        $general->commission_type = $request->commission_type;
        $general->sitename = $request->sitename;
        $general->cur_text = $request->cur_text;
        $general->whatsapp_number = $request->whatsapp_number;
        $general->telegram_number = $request->telegram_number;
        $general->x_handle = $request->x_handle;
        $general->cur_sym = $request->cur_sym;
        $general->active_template = $request->active_template;
        $general->reward_login = $request->reward_login;
        $general->base_color = $request->base_color;
        $general->secondary_color = $request->secondary_color;
        $general->account_name = $request->account_name;
        $general->account_number = $request->account_number;
        $general->bank_name = $request->bank_name;
        $general->usdt_address = $request->usdt_address;
        $general->usdt_bep20 = $request->usdt_bep20;
        $general->usdt_binance_id = $request->usdt_binance_id;
        $general->home_message = $request->home_message;
        $general->free_package = $request->free_package;

        $general->telegram_chat_id = $request->telegram_chat_id;
        $general->telegram_api_token = $request->telegram_api_token;
        $general->enable_telegram = $request->enable_telegram ? 1 : 0;

        $general->auto_transfer_default = $request->auto_transfer_default;
        $general->welcome_bonus = $request->welcome_bonus;
        $general->app_link = $request->app_link;
        $general->telegram_url = $request->telegram_url;
        $general->whatsapp_url = $request->whatsapp_url;
        $general->debit_with = $request->debit_with;
        $general->reward = $request->reward ? 1 : 0;
        //$general->reward_claim_active = $request->reward_claim_active ? 1 : 0;
        $general->buy_limit = $request->buy_limit ? 1 : 0;
        $general->buy_limit_type = $request->buy_limit_type;
        $general->limit_buy = $request->limit_buy;
        $general->ngn_to_usdt = $request->ngn_to_usdt;
        $general->usdt_to_ngn = $request->usdt_to_ngn;
        $general->ngn_to_usdt_fee = $request->ngn_to_usdt_fee;
        $general->usdt_to_ngn_fee = $request->usdt_to_ngn_fee;

        $general->save();

        $timezoneFile = config_path('timezone.php');
        $content = '<?php $timezone = '.$request->timezone.' ?>';
        file_put_contents($timezoneFile, $content);
        $notify[] = ['success', 'General setting has been updated.'];
        return back()->withNotify($notify);
    }


    public function logoIcon()
    {
        $pageTitle = 'Logo & Favicon';
        return view('admin.setting.logo_icon', compact('pageTitle'));
    }

    public function logoIconUpdate(Request $request)
    {
        $request->validate([
            'logo' => ['image',new FileTypeValidate(['jpg','jpeg','png'])],
            'favicon' => ['image',new FileTypeValidate(['png'])],
        ]);
        if ($request->hasFile('logo')) {
            try {
                $path = imagePath()['logoIcon']['path'];
                if (!file_exists($path)) {
                    mkdir($path, 0755, true);
                }
                Image::make($request->logo)->save($path . '/logo.png');
            } catch (\Exception $exp) {
                $notify[] = ['error', 'Logo could not be uploaded.'];
                return back()->withNotify($notify);
            }
        }

        if ($request->hasFile('favicon')) {
            try {
                $path = imagePath()['logoIcon']['path'];
                if (!file_exists($path)) {
                    mkdir($path, 0755, true);
                }
                $size = explode('x', imagePath()['favicon']['size']);
                Image::make($request->favicon)->resize($size[0], $size[1])->save($path . '/favicon.png');
            } catch (\Exception $exp) {
                $notify[] = ['error', 'Favicon could not be uploaded.'];
                return back()->withNotify($notify);
            }
        }
        $notify[] = ['success', 'Logo & favicon has been updated.'];
        return back()->withNotify($notify);
    }


    public function AutoPaySetting(Request $request)
    {
        $request->validate([
            'auto_pay' => 'required|in:oxapay,flutterwave,paystack,gtrpay,nowpay,0',
            'now_api_key' => 'required_if:auto_pay,nowpay',
            'now_secret_key' => 'required_if:auto_pay,nowpay',
            'now_host' => 'required_if:auto_pay,nowpay',

            'merchant_id' => 'required_if:auto_pay,gtrpay',
            'merchant_key' => 'required_if:auto_pay,gtrpay',
            'app_id' => 'required_if:auto_pay,gtrpay',

            'app_key' => 'required_if:auto_pay,oxapay',

            'py_public_key' => 'required_if:auto_pay,paystack',
            'py_secret_key' => 'required_if:auto_pay,paystack',

            'flu_public_key' => 'required_if:auto_pay,flutterwave',
            'flu_secret_key' => 'required_if:auto_pay,flutterwave',
            'flu_encryption_key' => 'required_if:auto_pay,flutterwave',
        ], [
            'now_api_key.required_if' => ':attribute is required for Now-payment configuration',
            'now_secret_key.required_if' => ':attribute is required for Now-payment configuration',
            'now_host.required_if' => ':attribute is required for Now-payment configuration',

            'merchant_id.required_if' => ':attribute is required for Gtrpay configuration',
            'merchant_key.required_if' => ':attribute is required for Gtrpay configuration',
            'app_id.required_if' => ':attribute is required for Gtrpay configuration',

            'app_key.required_if' => ':attribute is required for oxapay configuration',

            'py_public_key.required_if' => ':attribute is required for Paystack configuration',
            'py_secret_key.required_if' => ':attribute is required for Paystack configuration',

            'flu_public_key.required_if' => ':attribute is required for Flutterwave configuration',
            'flu_secret_key.required_if' => ':attribute is required for Flutterwave configuration',
            'flu_encryption_key.required_if' => ':attribute is required for Flutterwave configuration',
        ]);

        $setting = GeneralSetting::first();
		
		$autoConfig = (array)config('settings')->payout_config;
		$data = $request->only('auto_pay','app_key','flu_public_key','flu_secret_key','flu_encryption_key','py_public_key','py_secret_key','merchant_id','app_id','now_host', 'now_secret_key', 'now_api_key', 'merchant_key');
		$payout_config = array_merge($autoConfig,$data);

        $setting->update(['payout_config' => $payout_config]);
        $notify[] = ['success', 'Auto payout configuration has been updated.'];
        return back()->withNotify($notify);
    }


    public function cookie(){
        $pageTitle = 'GDPR Cookie';
        $cookie = Frontend::where('data_keys','cookie.data')->firstOrFail();
        return view('admin.setting.cookie',compact('pageTitle','cookie'));
    }

    public function cookieSubmit(Request $request){
        $request->validate([
            'link'=>'required',
            'description'=>'required',
        ]);
        $cookie = Frontend::where('data_keys','cookie.data')->firstOrFail();
        $cookie->data_values = [
            'link' => $request->link,
            'description' => $request->description,
            'status' => $request->status ? 1 : 0,
        ];
        $cookie->save();
        $notify[] = ['success','Cookie policy updated successfully'];
        return back()->withNotify($notify);
    }



    public function customCss(){
        $pageTitle = 'Custom CSS';
        $file = activeTemplate(true).'css/custom.css';
        $file_content = @file_get_contents($file);
        return view('admin.setting.custom_css',compact('pageTitle','file_content'));
    }


    public function customCssSubmit(Request $request){
        $file = activeTemplate(true).'css/custom.css';
        if (!file_exists($file)) {
            fopen($file, "w");
        }
        file_put_contents($file,$request->css);
        $notify[] = ['success','CSS updated successfully'];
        return back()->withNotify($notify);
    }

    public function optimize(){
        Artisan::call('optimize:clear');
        $notify[] = ['success','Cache cleared successfully'];
        return back()->withNotify($notify);
    }
}
