<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Task;
use App\Rules\FileTypeValidate;
use Illuminate\Http\Request;
use App\Models\Plan;

class PlanController extends Controller
{


    public function index(){
        $pageTitle = 'Subscription Plans';
        $plan = Plan::where('platform', config('settings')->active_template)->paginate(getPaginate());
        $emptyMessage = 'Data Not Found';
        return view('admin.plan.'.config('settings')->active_template, compact('pageTitle', 'plan', 'emptyMessage'));
    }

    public function create(Request $request)
	{
        $this->validation($request);

        $plan = new Plan();
		$plan->identifier 	= uniqid(strtoupper(substr(config('settings')->active_template, 0, 3)));
        $plan->platform 	= config('settings')->active_template;
        $this->saveData($plan, $request);

        $notify[] = ['success', 'Plan created successfully'];
        return redirect()->back()->withNotify($notify);

    }

    public function edit(Request $request){

        $this->validation($request);
        $plan = Plan::findOrFail($request->id);
        $this->saveData($plan, $request);


        $notify[] = ['success', 'Plan updated successfully'];
        return redirect()->back()->withNotify($notify);
    }

    protected function saveData($plan, $request)
    {
        if ($request->hasFile('image_input')) {
			$pathName = imagePath()['products']['link'];
            try {
				$plan->img = $pathName . uploadImage($request->image_input,imagePath()['products']['path'], imagePath()['products']['size'], $plan->img);
            } catch (\Exception $exp) {
                $notify[] = ['error', 'Could not upload the Image.'];
            }
        }

        $plan->name = $request->name;
        $plan->min_amount = $request->min_amount ?? 0;
        $plan->max_amount = $request->max_amount ?? 0;
        $plan->total_return = $request->total_return ?? 0;
        $plan->interest_type = $request->interest_type;  //	1=>Percent, 0=>Fixed
        $plan->interest_amount = $request->interest;
        $plan->buy_limit = $request->buy_limit ?? 0;
        $plan->capital_back_status = $request->capital_back_status;
        $plan->buy_limit_type = $request->buy_limit_type ?? 0;
        $plan->limit_buy = $request->limit_buy ?? 0;
        $plan->summary = $request->summary;
        $plan->notes = $request->notes;
        $plan->escape_buy_limit = $request->escape_buy_limit ?? 0;
        $plan->featured = $request->featured ?? 0;
        $plan->status = $request->status;
        $plan->capital = $request->capital;

        $plan->p_status        = $request->p_status ?? 'to_buy';
        $plan->purchased        = $request->purchased ?? 0;
        $plan->lock_endat        = $request->lock_endat ?? $plan->lock_endat;
        $plan->all_limit_buy        = $request->all_limit_buy ?? 0;

        $plan->save();
    }

    protected function validation($request)
    {
        $request->validate([
            'name'=> 'required|string|max:191',
            'min_amount'=> 'required|numeric|gt:0',
            'max_amount'=> 'required|numeric',
            'total_return'=> 'required|integer|gt:0',
            'interest_type'=> 'required|in:0,1',
            'interest'=> 'required|numeric|gt:0',
            'status'=> 'required|in:0,1',
        ]);

        if ($request->compound_interest && ((!$request->capital_back && !$request->return_type) || $request->interest_type == 2)) {
            throw ValidationException::withMessages(['error' => 'For compound interest, a lifetime plan or capital return and a percentage-based interest rate are required.']);
        }

        if ($request->hold_capital && !$request->capital_back) {
            throw ValidationException::withMessages(['error' => 'When hold capital is enabled, capital back is required.']);
        }

    }


    function tasks(){
        $pageTitle = 'Subscription Tasks';
        $plan = Task::latest()->paginate(getPaginate());
        $emptyMessage = 'Data Not Found';
        return view('admin.plan.tasks', compact('pageTitle', 'plan', 'emptyMessage'));
    }


    public function createTask(Request $request){

        $request->validate([
            'name'=> 'required|string|max:191',
            'content'=> 'required',
            'url'=> 'required',
            'status'=> 'required|in:0,1',
            'image' => ['image',new FileTypeValidate(['jpg','jpeg','png'])]
        ]);

        $task = new Task();
        $task->name 	= $request->name;
        $task->content 	= $request->content;
        $task->url 		= $request->url;
        $task->amount 	= $request->amount;
        $task->currency = $request->currency;
        $task->status 	= $request->status;
        $task->slug 	= getTrx();
		
        if ($request->hasFile('image')) {
            $location = imagePath()['gateway']['path'];
            $size = imagePath()['gateway']['size'];
            $filename = uploadImage($request->image, $location);

            $task->image = $filename;
            $task->save();

            $notify[] = ['success', 'Task created successfully'];
            return redirect()->back()->withNotify($notify);
        }

        $notify[] = ['error', 'Unable to create task'];
        return redirect()->back()->withNotify($notify);
    }

    public function editTask(Request $request){

        $request->validate([
            'name'=> 'required|string|max:191',
            'content'=> 'required',
            'url'=> 'required',
            'status'=> 'required|in:0,1',
        ]);

        $task = Task::find($request->id);
        $task->name 	= $request->name;
        $task->content 	= $request->content;
        $task->url 		= $request->url;
        $task->amount 	= $request->amount;
        $task->currency = $request->currency;
        $task->status 	= $request->status;

        if ($request->hasFile('image')) {
            $location = imagePath()['gateway']['path'];
            $size = imagePath()['gateway']['size'];
            $filename = uploadImage($request->image, $location);

            $task->image = "$location/$filename";
        }

        $task->save();

        $notify[] = ['success', 'Task updated successfully'];
        return redirect()->back()->withNotify($notify);
    }

}
