<?php

namespace App\Http\Controllers\Admin;

use App\Models\Raffles;
use App\Models\RewardPlan;
use Illuminate\Http\Request;
use App\Rules\FileTypeValidate;
use App\Http\Controllers\Controller;

class RewardController extends Controller
{

    public function index(){
        $pageTitle = 'Subscription Plans';
        $rewards = RewardPlan::paginate(getPaginate());
        $emptyMessage = 'Data Not Found';
        return view('admin.plan.rewards', compact('pageTitle', 'rewards', 'emptyMessage'));
    }


    public function createReward(Request $request)
	{
        $this->validation($request);

        $reward = new RewardPlan();
		$reward->identifier 	= getTrx();
		$this->saveData($reward, $request);

        $notify[] = ['success', 'Reward created successfully'];
        return redirect()->back()->withNotify($notify);

    }

    public function editReward(Request $request){

        $this->validation($request);
		
        $reward = RewardPlan::findOrFail($request->id);
        $this->saveData($reward, $request);


        $notify[] = ['success', 'Reward updated successfully'];
        return redirect()->back()->withNotify($notify);
    }
	
    protected function validation($request)
    {
        $request->validate([
            'name'=> 'required|string|max:191',
            'amount'=> 'required|numeric|gt:0',
            'number'=> 'required|numeric',
            'rate'=> 'required',
            'interval'=> 'required|numeric|gt:0',
            'status'=> 'required|in:0,1',
        ]);

    }

    protected function saveData($reward, $request)
    {
        $reward->name 		= $request->name;
        $reward->status 	= $request->status;
        $reward->amount 	= $request->amount ?? 0;
        $reward->interval 	= $request->interval;
        $reward->type 		= $request->type ?? 1;
        $reward->number 	= $request->number ?? 0;
        $reward->currency 	= $request->currency;
        $reward->rate 		= $request->rate ?? 1;
        $reward->expires    = $request->expires ?? $reward->expires;
        $reward->summary	= $request->summary;

        $reward->save();
    }
  
    public function raffle(){
        $pageTitle = 'Subscription Plans';
        $raffles = Raffles::paginate(getPaginate());
        $emptyMessage = 'Data Not Found';
        return view('admin.plan.raffle', compact('pageTitle', 'raffles', 'emptyMessage'));
    }

    public function createRaffle(Request $request)
	{
        $this->validateMe($request);

        $raffle = new Raffles();
		$this->saveRaffel($raffle, $request);

        $notify[] = ['success', 'Card created successfully'];
        return redirect()->back()->withNotify($notify);

    }

    public function editRaffle(Request $request){

		$this->validateMe($request);
		
        $raffle = Raffles::findOrFail($request->id);
        $this->saveRaffel($raffle, $request);

        $notify[] = ['success', 'Card updated successfully'];
        return redirect()->back()->withNotify($notify);
    }
	
    protected function validateMe($request)
    {
        $request->validate([
            'network'=> 'required|string|max:191',
            'amount'=> 'required|numeric|gt:0',
            'cards'=> 'required|string',
            'status'=> 'required|in:0,1',
        ]);

    }

    protected function saveRaffel($reward, $request)
    {
        $reward->network 	= $request->network;
        $reward->status 	= $request->status;
        $reward->amount 	= $request->amount ?? 0;
        $reward->cards 		= $request->cards;
        $reward->quiz		= $request->quiz;

        $reward->save();
    }
  


}