<?php

namespace App\Http\Controllers\Auth;

use App\Http\Component\AppController;
use App\Http\Services\AuthenticationServices;
use App\Models\PasswordReset;
use App\Models\User;
use Illuminate\Foundation\Auth\SendsPasswordResetEmails;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class ForgotPasswordController extends AppController
{
    /*
    |--------------------------------------------------------------------------
    | Password Reset Controller
    |--------------------------------------------------------------------------
    |
    | This controller is responsible for handling password reset emails and
    | includes a trait which assists in sending these notifications from
    | your application to your users. Feel free to explore this trait.
    |
    */

    use SendsPasswordResetEmails;

    public function __construct()
    {
        $this->middleware('guest');
    }

    function showLinkRequestForm(){
        $pageTitle = "Forgot Password";
        return view(activeTemplate() . 'user.auth.passwords.email', compact('pageTitle'));
    }

    public function sendResetCodeEmail(Request $request, AuthenticationServices $auth)
    {

        \Session::flash('modal', '#resetModal');

        /*if ($request->type == 'email') {
            $validationRule = [
                'value'=>'required|email'
            ];
            $validationMessage = [
                'value.required'=>'Email field is required',
                'value.email'=>'Email must be a valid email'
            ];
        }elseif($request->type == 'username'){
            $validationRule = [
                'value'=>'required'
            ];
            $validationMessage = ['value.required'=>'Username field is required'];
        }else{
            $notify[] = ['error','Invalid selection'];
            return $this->handleResponse($request, 'Invalid selection', 401, $notify);
        }

        $request->validate($validationRule,$validationMessage);*/

        // Validate
        $validator = Validator::make($request->all(),[
            'username' => 'required|numeric'
        ]);

        // Failed to validate
        if ($validator->fails()) {
            $errors = $validator->errors()->all();
            $notify[] = ['error', implode(' ', $errors)];
            return $this->handleResponse($request, implode(' ', $errors), 401, $notify);
        }

        $user = User::where('username', $request->username)->first();

        if (!$user) {
            \Session::flash('modalType', '#resetModal');
            $notify[] = ['error', 'User not found.'];
            return $this->handleResponse($request, 'User not found.', 401, $notify);
        }

        PasswordReset::where('email', $user->username)->delete();
        $code = verificationCode(6);
        $password = new PasswordReset();
        $password->email = $user->username;
        $password->token = $code;
        $password->created_at = \Carbon\Carbon::now();
        $password->save();

        $userIpInfo = getIpInfo();
        $userBrowserInfo = osBrowser();
        /*sendEmail($user, 'PASS_RESET_CODE', [
            'code' => $code,
            'operating_system' => @$userBrowserInfo['os_platform'],
            'browser' => @$userBrowserInfo['browser'],
            'ip' => @$userIpInfo['ip'],
            'time' => @$userIpInfo['time']
        ]);*/
        
        // Authentication
       $auth = $auth->sendWhatsappOtp($user->mobile, $code);
       
       // Exception
       if($auth instanceof \Exception) {
        // Redirect
        $notify[] = ['error', $auth->getMessage()];
        return $this->handleResponse($request, $auth->getMessage(), 401, $notify);
       }
        
        $email = $user->username;
        session()->put('pass_res_username',$email);
        return $this->handleResponseRedirect($request, 'Verification Code sent Successful', 200, url(route('user.password.code.verify')));
    }

    public function codeVerify(){
        $pageTitle = 'Account Recovery';
        $username = session()->get('pass_res_username');
        if (!$username) {
            $notify[] = ['error', 'Invalid Request'];
            \Session::flash('modalType', '#resetModal');
            \Session::flash('modal', '#resetModal');
            return redirect()->route('home')->withNotify($notify);
        }
        return view(activeTemplate().'user.auth.passwords.code_verify',compact('pageTitle','username'));
    }

    public function verifyCode(Request $request)
    {
         $validator = Validator::make($request->all(),[
            'code' => 'required',
            'username' => 'required'
        ]);

        // Failed to validate
        if ($validator->fails()) {
            $errors = $validator->errors()->all();
            $notify[] = ['error', implode(' ', $errors)];
            return $this->handleResponse($request, implode(' ', $errors), 401, $notify);
        }

        $code =  str_replace(' ', '', $request->code);

        if (PasswordReset::where('token', $code)->where('email', $request->username)->count() != 1) {
            return $this->handleResponseRedirect($request, 'Invalid token', 401, url(route('user.password.request')));
        }
        
        session()->flash('username', $request->username);
        return $this->handleResponseRedirect($request, 'You can change your password.', 200, url(route('user.password.reset', ['token' => $code])));
    }

}
