<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Models\Extension;
use App\Models\UserLogin;
use App\Models\Wallet;
use CryptAPI\CryptAPI;
use App\Models\User;
use Illuminate\Support\Facades\Auth;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Http\Request;


class LoginController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Login Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles authenticating users for the application and
    | redirecting them to your home screen. The controller uses a trait
    | to conveniently provide its functionality to your applications.
    |
    */

    use AuthenticatesUsers;

    /**
     * Where to redirect users after login.
     *
     * @var string
     */

    protected $username;

    /**
     * Create a new controller instance.
     *
     * @return void
     */


    public function __construct()
    {
        $this->middleware('guest')->except('logout','userAccountLogin');
        $this->username = $this->findUsername();
    }


    function loginForm(){
        $pageTitle = "Sign In";
        $sub_title = "Welcome Back, You've<br>been missed!";

		return view(activeTemplate().'user.auth.login',compact('pageTitle','sub_title'));
		//return view('auth.login', compact('pageTitle','sub_title'));
    }

    public function login(Request $request)
    {

        \Session::flash('modal', '#loginModal');

        $this->validateLogin($request);
		
        // If the class is using the ThrottlesLogins trait, we can automatically throttle
        // the login attempts for this application. We'll key this by the username and
        // the IP address of the client making these requests into this application.
        if ($this->hasTooManyLoginAttempts($request)) {
            $this->fireLockoutEvent($request);

            return $this->sendLockoutResponse($request);
        }

        if ($this->attemptLogin($request)) {
            return $this->sendLoginResponse($request);
        }

        // If the login attempt was unsuccessful we will increment the number of attempts
        // to login and redirect the user back to the login form. Of course, when this
        // user surpasses their maximum number of attempts they will get locked out.
        $this->incrementLoginAttempts($request);


        return $this->sendFailedLoginResponse($request);
    }

    public function findUsername()
    {
        $login = request()->input('username');
		
        //$fieldType = ctype_digit( $login ) ? 'mobile' : 'username';
        //$fieldType = is_numeric( $login ) ? 'mobile' : 'username';
        $fieldType = preg_match('/^[0-9]+$/', $login) ? 'mobile' : 'username';
		//$fieldType = filter_var($login, FILTER_VALIDATE_EMAIL) ? 'mobile' : 'username';
		//$fieldType = filter_var($login, FILTER_VALIDATE_INT) ? 'mobile' : 'username';
		
        request()->merge([$fieldType => $login]);
        return $fieldType;
    }

    public function userAccountLogin($id)
    {
        $user = User::findOrFail($id);
		
		if( $user != null ){
			
			Auth::login($user);
			session()->put('currency', config('settings')->cur_text);
			session()->put('currency_sym', config('settings')->cur_sym);
			return redirect()->route('user.home')->with('success', 'You are successfully logged in.');
        }
        return redirect()->back()->with('error', 'Login link is not valid.');
    }

    public function username()
    {
        return $this->username;
    }

    protected function validateLogin(Request $request)
    {
        $customRecaptcha = Extension::where('act', 'custom-captcha')->where('status', 1)->first();
        $validation_rule = [
            $this->username() => 'required|string',
            'password' => 'required|string',
        ];

        if ($customRecaptcha) {
            $validation_rule['captcha'] = 'required';
        }

        $request->validate($validation_rule);

    }

    public function logout()
    {
        $this->guard()->logout();

        request()->session()->invalidate();

        $notify[] = ['success', 'You have been logged out.'];
        //return redirect()->route('user.login')->withNotify($notify);
        return redirect()->route('user.login');
    }


    public function authenticated(Request $request, $user)
    {
        if ($user->status == 0) {
            $this->guard()->logout();
            $notify[] = ['error','Your account has been deactivated.'];
            return redirect()->route('user.login')->withNotify($notify);
        }


        $user = auth()->user();
        $user->tv = $user->ts == 1 ? 0 : 1;
        $user->save();
        $ip = $_SERVER["REMOTE_ADDR"];
        $exist = UserLogin::where('user_ip',$ip)->first();
        $userLogin = new UserLogin();
        if ($exist) {
            $userLogin->longitude =  $exist->longitude;
            $userLogin->latitude =  $exist->latitude;
            $userLogin->city =  $exist->city;
            $userLogin->country_code = $exist->country_code;
            $userLogin->country =  $exist->country;
        }else{
            $info = json_decode(json_encode(getIpInfo()), true);
            $userLogin->longitude =  @implode(',',$info['long']);
            $userLogin->latitude =  @implode(',',$info['lat']);
            $userLogin->city =  @implode(',',$info['city']);
            $userLogin->country_code = @implode(',',$info['code']);
            $userLogin->country =  @implode(',', $info['country']);
        }

        $userAgent = osBrowser();
        $userLogin->user_id = $user->id;
        $userLogin->user_ip =  $ip;

        $userLogin->browser = @$userAgent['browser'];
        $userLogin->os = @$userAgent['os_platform'];
        $userLogin->save();

        // Set session
        session()->put('currency', config('settings')->cur_text);
        session()->put('currency_sym', config('settings')->cur_sym);

        if ($request->ajax()) {
            return response()->json([
                'user' => auth()->user()->id,
                'code' => 1,
                'intended' => route('user.home')
            ]);
        } else {
            return redirect()->route('user.home');
            //return redirect()->intended(URL::route('dashboard'));
        }

        //return redirect()->route('user.home');
    }


}
