<?php

namespace App\Http\Controllers\Auth;

use App\Http\Component\AppController;
use App\Models\AdminNotification;
use App\Models\User;
use App\Models\UserLogin;
use Illuminate\Auth\Events\Registered;
use Illuminate\Foundation\Auth\RegistersUsers;
use Illuminate\Http\Request;
use Carbon\Carbon;

use App\Models\Investment;
use App\Models\Plan;
use App\Models\Transaction;

use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rules\Password;
use Illuminate\Support\Facades\Session;

class RegisterController extends AppController
{
    /*
    |--------------------------------------------------------------------------
    | Register Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles the registration of new users as well as their
    | validation and creation. By default this controller uses a trait to
    | provide this functionality without requiring any additional code.
    |
    */

    use RegistersUsers;

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->guard()->logout();
        $this->middleware('guest');
        $this->middleware('regStatus')->except('registrationNotAllowed');

        $this->activeTemplate = activeTemplate();
    }


    function registerForm(){
        $pageTitle = "Sign Up";
        $sub_title = "Create an account <br> to continue";

        $reference = @$_GET['codeNumber'];
        if ($reference) {
            session()->put('reference', $reference);
        }
		
		return view(activeTemplate().'user.auth.register',compact('pageTitle','sub_title'));
        //return view('auth.register', compact('pageTitle','sub_title'));
    }

    /**
     * Get a validator for an incoming registration request.
     *
     * @param  array $data
     * @return \Illuminate\Contracts\Validation\Validator
     */
    protected function validator(array $data)
    {
        $password_validation = Password::min(6);

        $agree = 'nullable';
        if (config('settings')->agree) {
            $agree = 'required';
        }

        \Session::flash('modal', '#registerModal');

        $countryData = (array)json_decode(file_get_contents(resource_path('views/partials/country.json')));
        $countryCodes = implode(',', array_keys($countryData));
        $mobileCodes = implode(',',array_column($countryData, 'dial_code'));
        $countries = implode(',',array_column($countryData, 'country'));
        $validate = Validator::make($data, [
            //'firstname' => 'sometimes|required|string|max:50',
            //'lastname' => 'sometimes|required|string|max:50',
            //'email' => 'required|string|email|max:90|unique:users',
            'mobile' => 'required|string|max:50|unique:users',
            'password' => ['required','confirmed',$password_validation],
            //'withdrawal_password' => ['required', $password_validation],
            'username' => 'sometimes|alpha_num|unique:users|min:1',
            //'captcha' => 'sometimes|numeric|in:' . Session::get('captcha_code'),
            //'mobile_code' => 'required|in:'.$mobileCodes,
            //'country_code' => 'required|in:'.$countryCodes,
            //'country' => 'required|in:'.$countries,
            'agree' => $agree,
            //'otp' => 'required|string'
        ]);
        return $validate;
    }

    public function register(Request $request)
    {
        $this->validator($request->all())->validate();
        $exist = User::where('mobile',$request->mobile_code.$request->mobile)->first();
        if ($exist) {
            $notify[] = ['error', 'The Account ID number already registered'];
            return $this->handleResponse($request, 'The Account ID already registered', 401, $notify);
        }
		
		if(isset($data['username'])){
			$exist1 = User::where('username', $request->username)->first();
			if ($exist1) {
				$notify[] = ['error', 'The Account Username already registered'];
				return $this->handleResponse($request, 'The Account Username already registered', 401, $notify);
			}
		}

        /*$captcha_code = Session::get('captcha_code');
		if(isset($request->captcha)){
			if( !in_array( $request->captcha, $captcha_code)){
				$code = implode(',', $captcha_code);
				$notify[] = ['error', 'Invalid captcha code '.$code];
				return $this->handleResponse($request, 'Invalid captcha code entered '.$code, 401, $notify);
			}
		}*/


        // Verify OTP
        if($request->otp != session('otp')) {
            $notify[] = ['error', 'OTP not valid'];
            return $this->handleResponse($request, 'OTP not valid', 401, $notify);
        }

        event(new Registered($user = $this->create($request->all())));

        $this->guard()->login($user);

        return $this->registered($request, $user)
            ?: redirect($this->redirectPath());
    }


    /**
     * Create a new user instance after a valid registration.
     *
     * @param  array $data
     * @return \App\User
     */
    protected function create(array $data)
    {

        if (isset($data['referBy'])) {
            $referBy = $data['referBy'];//session()->get('reference');
            $referUser = User::where('ref_code', $referBy)->first();
        } else {
            $referUser = null;
        }
        //User Create
        $user = new User();
        $user->firstname = isset($data['username']) ? $data['username'] : getTrx(5, true);
        $user->lastname = isset($data['lastname']) ? $data['lastname'] : getTrx(7, true);
        $user->password = Hash::make($data['password']);
        $user->username = isset($data['username']) ? trim($data['username']) : trim($data['mobile']);
        $user->ref_by = $referUser ? $referUser->id : 0;
        $user->ref_code = getTrx(7);
        $user->country_code = '';//$data['country_code'];
        $user->mobile = $data['mobile'];

        $user->email = strtolower($user->username).'@gmail.com';

		$info = json_decode(json_encode(getIpInfo()), true);
		$longitude =  @implode(',',$info['long']);
		$latitude =  @implode(',',$info['lat']);
		$uCity =  @implode(',',$info['city']);
		$countryCode = @implode(',',$info['code']);
		$uCountry =  @implode(',', $info['country']);

        $user->address = [
            'address' => $uCity .', ' .$countryCode .','.$longitude.' '.$latitude,
            'state' => $uCity,
            'zip' => $countryCode,
            'country' => $uCountry,
            'city' => $uCity
        ];
        $user->status = 1;
        $user->ev = config('settings')->ev ? 0 : 1;
        $user->sv = config('settings')->sv ? 0 : 1;
        $user->ts = 0;
        $user->tv = 1;
        $user->save();


        $adminNotification = new AdminNotification();
        $adminNotification->user_id = $user->id;
        $adminNotification->title = 'New member registered';
        $adminNotification->click_url = urlPath('admin.users.detail',$user->id);
        $adminNotification->save();

        if(config('settings')->use_link_bonus == 1 && !empty($referUser) ){
            $referUser->points += getAmount(config('settings')->use_link_amount);
            $referUser->save();

            $transaction = new Transaction();
            $transaction->user_id = $referUser->id;
            $transaction->amount = getAmount(config('settings')->use_link_amount);
            $transaction->charge = 0;
			$transaction->currency = config('settings')->cur_text;
            $transaction->post_balance = getAmount($user->points);
            $transaction->trx_type = '+';
			$transaction->status = 1;
            $transaction->trx =  getTrx();
            $transaction->type = 'points';
            $transaction->details = 'Pre launch bonus from link';
            $transaction->save();
        }


        //Login Log Create
        $ip = $_SERVER["REMOTE_ADDR"];
        $exist = UserLogin::where('user_ip',$ip)->first();
        $userLogin = new UserLogin();

        //Check exist or not
        if ($exist) {
            $userLogin->longitude =  $exist->longitude;
            $userLogin->latitude =  $exist->latitude;
            $userLogin->city =  $exist->city;
            $userLogin->country_code = $exist->country_code;
            $userLogin->country =  $exist->country;
        }else{
            $userLogin->longitude =  $longitude;
            $userLogin->latitude =  $latitude;
            $userLogin->city =  $uCity;
            $userLogin->country_code = $countryCode;
            $userLogin->country =  $uCountry;
        }

        $userAgent = osBrowser();
        $userLogin->user_id = $user->id;
        $userLogin->user_ip =  $ip;

        $userLogin->browser = @$userAgent['browser'];
        $userLogin->os = @$userAgent['os_platform'];
        $userLogin->save();

        // Set session
        session()->put('currency', config('settings')->cur_text);
        session()->put('currency_sym', config('settings')->cur_sym);

        session()->put('bonus_welcome', config('settings')->welcome_bonus);
        
        return $user;
    }

    public function registered(Request $request)
    {
        $user = auth()->user();

		if( config('settings')->free_package ){

			$findPlan = Plan::where('id', 1)->first();

			if($findPlan){

				$newInvest = new Investment();
				
				$perAnnuityInterest = 0;
				$nextReturn = Carbon::now()->addHours(24);
				if($findPlan->interest_type == 0){
					$perAnnuityInterest = $findPlan->interest_amount;
				}else{
					$perAnnuityInterest = ($amount * $findPlan->interest_amount) / 100;
				}
				
				$newInvest->trx = getTrx();
				$newInvest->plan_id = $findPlan->id;
				$newInvest->user_id = $user->id;
				$newInvest->currency = $findPlan->cur_text;
				$newInvest->amount = $findPlan->min_amount;
				$newInvest->capital_status = $findPlan->capital_back_status;
				$newInvest->interest_type = $findPlan->interest_type;
				$newInvest->interest_amount = $perAnnuityInterest;
				$newInvest->total_return = $findPlan->total_return;
				$newInvest->next_return_date = $nextReturn;
				$newInvest->status = 0;
				$newInvest->save();

				$transaction = new Transaction();
				$transaction->user_id = $user->id;
				$transaction->currency = $newInvest->currency;
				$transaction->amount = $findPlan->min_amount;
				$transaction->post_balance = 0;
				$transaction->charge = 0;
				$transaction->type = 'invest';
				$transaction->trx_type = '-';
				$transaction->details = 'Take part in '.$findPlan->name;
				$transaction->trx =  $newInvest->trx;
				$transaction->pay_with = $findPlan->cur_text;
				$transaction->coupon = null;
				$transaction->coupon_rate = 0;
				$transaction->status = 1;
				$transaction->save();
			}
		}

		if( config('settings')->welcome_bonus > 0 ){
			give_bonus($user->id, 2, config('settings')->cur_text, config('settings')->welcome_bonus, "Welcome bonus", 2);
			//return $this->handleResponseRedirect($request, 'Successful', 401, url(route('user.welcome.bonus')), 'user.welcome.bonus', ['success', 'Successful']);
		}

		return $this->handleResponseRedirect($request, 'Successful', 401, url(route('user.home')), 'user.home', ['success', 'Successful']);
    }

}
