<?php

namespace App\Http\Controllers;

use App\Http\Component\AppController;
use App\Http\Services\AuthenticationServices;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class AuthenticationController extends AppController
{
    private $auth;
    private $activeTemplate;

    public function __construct(
        AuthenticationServices $auth
    )
    {
        $this->auth = $auth;
        $this->activeTemplate = activeTemplate();
    }

    public function sessionOtp(Request $request){

       // Validate
       $validator = Validator::make($request->all(),[
        'number' => 'required|string'
        ]);

        // Failed to validate
        if ($validator->fails()) {
            $errors = $validator->errors()->all();
            $notify[] = ['error', implode(' ', $errors)];
            return $this->handleResponse($request, implode(' ', $errors), 401, $notify);
        }
        
        $otp = verificationCode(6);

        // Authentication
       $auth = $this->auth->sendWhatsappOtp($request->number, $otp);
       
       // Exception
       if($auth instanceof \Exception) {
        // Redirect
        $notify[] = ['error', $auth->getMessage()];
        return $this->handleResponse($request, $auth->getMessage(), 401, $notify);
       }

       session()->put('otp', $otp);

       // Success Response
       return $this->handleResponse($request, 'OTP sent Successful', 200);

    }


}
