<?php

namespace App\Http\Controllers\Gateway;

use App\Http\Controllers\Controller;
use App\Models\Deposit;
use App\Models\Recharge;
use App\Models\Transaction;
use App\Models\User;
use App\Models\Withdrawal;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class IpnController extends Controller
{
    public function ipn(Request $request)
    {

        try {

            // Validate request
            $validator = Validator::make($request->all(), [
                'event' => 'required|in:PAYIN,PAYOUT',
                'outTradeNo' => 'required',
                'transNo' => 'required',
                'transAmt' => 'required',
                'transStatus' => 'required|in:SUCCESS,FAIL'
            ]);
    
            // Validation Failed
            if ($validator->fails()) throw new \Exception(implode('...', $validator->errors()->all()));
            
            // Deposit Handle
            if(in_array($request->event, ['PAYIN']) && $request->transStatus == 'SUCCESS') {
                $updateData = self::updateDeposit($request->outTradeNo, $request->transAmt, $request->all());
            }

            // Payout Handle
            if(in_array($request->event, ['PAYOUT'])) {
                $updateData = self::updatePayout($request->transStatus, $request->outTradeNo, $request->transAmt, $request->all());
            }

            // Exception
            if($updateData instanceof \Exception) throw new \Exception($updateData->getMessage());

            $notify = ['code' => 200, 'msg' => 'success', 'message' => 'Transaction was successful'];
            return response($notify, 200);
        } catch (\Exception $th) {
            //throw $th;
            $notify = ['code' => 200, 'msg' => 'success', 'message' => $th->getMessage()];
            return response($notify, 400);
        }

    }

    /**
     * Deposit update transaction
     */
    public static function updateDeposit(
        string $reference,
        string $amount,
        array $data
    ) {
        try {
            
            // Find Transaction
            $transaction = Deposit::where('trx', $reference)->first();

            // Verify is transaction exisit
            if (!$transaction) throw new \Exception('Transaction not found');

            // Verify if transaction status not complete
            if (in_array($transaction->status, [1, 3])) throw new \Exception('Transaction was already complete');

            // Verify if transaction amount are the same
            //if ($transaction->amount != $amount) throw new \Exception('Transaction not the same as order its');
            
            
            // Update transaction details
            $transaction->detail = $data;
            $transaction->status = 1;
            $transaction->trx_source = $data['transNo'];
            $transaction->save();

			$uBalance = 'balance'; 
			if(config('settings')->cur_text != 'NGN'){
				$uBalance = 'usdt_balance'; 
			}

            $user = User::find($transaction->user_id);
            // Update user balance
            $user->$uBalance = $user->$uBalance + $transaction->amount;
            $user->save();

            $transaction = Transaction::where('trx', $reference)->first();
            $transaction->status = 1;
            $transaction->save();

            return $transaction;
        } catch (\Exception $th) {
            //throw $th;
            return $th;
        }
    }

    /**
     * Payout update transaction
     */
    public static function updatePayout(
        string $status,
        string $reference,
        string $amount,
        array $data
    ) {
        try {
            // Find payout
            $payout = Withdrawal::where('trx', $reference)->first();

            // Verify is payout exisit
            if (!$payout) throw new \Exception('Transaction not found');

            $user = User::find($payout->user_id);

            // Verify if payout status not complete
            if (in_array($payout->status, [3])) throw new \Exception('Transaction was already complete');
            
            // Verify successful status
            if(in_array($status, ['SUCCESS'])) {
                // Update payout
                $payout->status = 1;
                $payout->save();

                $transaction = Transaction::where('trx', $reference)->first();
                $transaction->status = 1;
                $transaction->save();
            }

            // Verify failed status | Refund amount to user
            if(in_array($status, ['FAIL'])) {
                // Update payout
                $payout->status = 3;
                $payout->save();

                // Refund amount to User Wallet
                $user->income = $user->income + $payout->amount;
                $user->save();

                $transaction = Transaction::where('trx', $reference)->first();
                $transaction->status = 3;
                $transaction->save();
            }

            return $payout;
        } catch (\Exception $th) {
            //throw $th;
            return $th;
        }
    }
}
