<?php

namespace App\Http\Controllers\Gateway\oxapay;

use App\Models\Deposit;
use App\Models\Gateway;
use App\Lib\CurlRequest;
use App\Models\Withdrawal;
use App\Http\Controllers\Controller;
use App\Http\Controllers\Gateway\PaymentController;

class ProcessController extends Controller {
	
	private static $base = 'https://api.oxapay.com/merchants/';
	
    public static function coins_pairs() {
        $gateway = Gateway::where(['status' => 1])->where('alias', 'oxapay')->first();
		
		if( $gateway ){
			$config = json_decode($gateway->gateway_parameters);


			$response       = CurlRequest::curlStream(self::$base.'allowedCoins', [
				'merchant'         => $config->merchant_key->value,
			]);
			
			if( $response && $response->result ){
				return $response->allowed;
			}
		}
		
		$send['result']   = false;
		$send['message'] = 'Some problem ocurred with api.';
		return json_encode($send);
    }

    public static function paylink($deposit) {
        $config = json_decode($deposit->gatewayCurrency()->gateway_parameter);

        $response       = CurlRequest::curlStream(self::$base.'request', [
			'merchant' 			=> $config->merchant_key,
            'amount' 			=> $deposit->final_amo,
            'currency' 			=> $deposit->method_currency,
            'callbackUrl' 		=> route('ipn.oxapay'),
            'lifeTime' 			=> 60,
            'orderId' 			=> $deposit->trx,
            'returnUrl' 		=> route('user.home'),
            'description' 		=> $deposit->user_id . ' account recharge for product',
        ]);
		
		if( $response && $response->result ){
			if ($deposit->btc_amo == 0 || $deposit->btc_wallet == "") {

				$deposit->btc_wallet 	= $response->payLink;
				$deposit->btc_amo    	= $deposit->final_amo;
				$deposit->trx_source 	= $response->trackId;
				$deposit->pay_link 		= $response->payLink;
				$deposit->initiate 		= \Carbon\Carbon::now()->addMinutes(1000);
				$deposit->update();
			}

			$send['id']   	  = $deposit->id;
			$send['amount']   = $deposit->btc_amo;
			$send['actual']   = $deposit->amount;
			$send['initiate'] = $deposit->initiate;
			$send['sendto']   = $deposit->btc_wallet;
			$send['img']      = cryptoQR($deposit->btc_wallet);
			$send['currency'] = $deposit->method_currency;
			$send['view']     = 'user.payment.'.$deposit->gateway->alias;
			return json_encode($send);

		}else{
            $send['error']   = true;
            $send['message'] = 'Some problem ocurred with api.';
            $deposit->status    = 3;
            $deposit->update();
            return json_encode($send);
        }
    }

    public static function process($deposit) {
        $config = json_decode($deposit->gatewayCurrency()->gateway_parameter);
		
        $response       = CurlRequest::curlStream(self::$base.'request/whitelabel', [
			'merchant' 			=> $config->merchant_key,
            'amount' 			=> $deposit->final_amo,
            'currency' 			=> 'USD',
			'network' 			=> $config->network,
			'payCurrency' 		=> $deposit->method_currency,
            'callbackUrl' 		=> route('ipn.oxapay'),
            'lifeTime' 			=> 2000,
            'orderId' 			=> $deposit->trx,
            'returnUrl' 		=> route('user.home'),
            'description' 		=> $deposit->user_id . ' account recharge for product',
        ]);
		
		if( $response && $response->result ){
			if ($deposit->btc_amo == 0 || $deposit->btc_wallet == "") {

				$deposit->try 			= 1;
				$deposit->btc_wallet 	= $response->address;
				$deposit->btc_amo    	= $deposit->payAmount;
				$deposit->trx_source 	= $response->trackId;
				$deposit->pay_link 		= $response->QRCode;
				$deposit->initiate 		= \Carbon\Carbon::now()->addMinutes(2000);
				$deposit->update();
			}

			$send['id']   	  = $deposit->id;
			$send['amount']   = $deposit->btc_amo;
			$send['actual']   = $deposit->amount;
			$send['initiate'] = $deposit->initiate;
			$send['sendto']   = $deposit->btc_wallet;
			$send['img']      = $deposit->pay_link;
			$send['currency'] = $deposit->method_currency;
			$send['view']     = 'user.payment.'.$deposit->gateway->alias;
			return json_encode($send);

		}else{
            $send['error']   = true;
            $send['message'] = 'Some problem ocurred with api.';
            $deposit->status    = 3;
            $deposit->update();
            return json_encode($send);
        }
    }

    public static function owner($deposit) {
        $config = json_decode($deposit->gatewayCurrency()->gateway_parameter);

        $response       = CurlRequest::curlStream(self::$base.'request/staticaddress', [
			'merchant' 			=> $config->merchant_key,
            'callbackUrl' 		=> route('ipn.oxapay'),
			'network' 			=> $config->network,
            'currency' 			=> $deposit->method_currency,
        ]);
		
		if( $response && $response->result ){

			$user = auth()->user();
			$user->wallet_address = $response->address;
			$user->save();
			return true;
		}else{
            return false;
        }
    }

    public static function balance() {
        $gateway = Gateway::where(['status' => 1])->where('alias', 'oxapay')->first();
		
		if( $gateway ){
			$config = json_decode($gateway->gateway_parameters);

			$response       = CurlRequest::curlStream('https://api.oxapay.com/api/balance', [
				'merchant'         => $config->api_key->value,
				'currency'         => 'USDT',
			]);
			
			if( $response && $response->result ){
				return $response->data;
			}
		}
		
		$send['result']   = false;
		$send['message'] = 'Some problem ocurred with api.';
		return json_encode($send);
    }

    public static function payuser(Withdrawal $Withdraw) {
        $gateway = Gateway::where(['status' => 1])->where('alias', 'oxapay')->first();
		
		if( $gateway ){
			$config = json_decode($gateway->gateway_parameters);

			$response       = CurlRequest::curlStream('https://api.oxapay.com/api/send', [
				'merchant'         => $config->api_key->value,
				'currency'         => 'USDT',
			]);
			
			if( $response && $response->result ){
				return $response->data;
			}
		}
		
		$send['result']   = false;
		$send['message'] = 'Some problem ocurred with api.';
		return json_encode($send);
    }


    public static function owners($deposit) {
        $config = json_decode($deposit->gatewayCurrency()->gateway_parameter);

        $response       = CurlRequest::curlStream('https://api.oxapay.com/api/balance', [
			'merchant' 			=> $config->merchant_key,
            'currency' 			=> $deposit->method_currency,
        ]);
		
		if( $response && $response->result ){

			$user = auth()->user();
			$user->wallet_address = $response->address;
			$user->save();
			return true;
		}else{
            return false;
        }
    }


	public function ipn() {
        if (isset($_SERVER['HTTP_X_NOWPAYMENTS_SIG']) && !empty($_SERVER['HTTP_X_NOWPAYMENTS_SIG'])) {
            $recived_hmac = $_SERVER['HTTP_X_NOWPAYMENTS_SIG'];
            $request_json = file_get_contents('php://input');
            $request_data = json_decode($request_json, true);
            ksort($request_data);
            $sorted_request_json = json_encode($request_data, JSON_UNESCAPED_SLASHES);
            if ($request_json !== false && !empty($request_json)) {
                $gateway    = Gateway::where('alias', 'NowPaymentsHosted')->first();
                $gatewayAcc = json_decode($gateway->gateway_parameters);
                $hmac       = hash_hmac("sha512", $sorted_request_json, trim($gatewayAcc->secret_key->value));
                if ($hmac == $recived_hmac) {
                    if ($request_data['payment_status']=='confirmed' || $request_data['payment_status']=='finished') {
                        if ($request_data['actually_paid'] == $request_data['pay_amount']) {
                            $deposit = Deposit::where('status', 0)->where('trx', $request_data['order_id'])->first();
                            if ($deposit) {
                                PaymentController::userDataUpdate($deposit);
                            }
                        }
                    }
                }
            }
        }
    }
	
}