<?php

namespace App\Http\Controllers;

use App\Http\Component\AppController;
use App\Models\Investment;
use App\Models\Transaction;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Http\Services\WalletServices;
use Illuminate\Support\Facades\Validator;

/**
 * Laravel/Symfony Developer
 * Name: Muongozo
 * Telegram: @muongozotrader
 * Hire me via Telegram: muongozotrader
 */
class IncomeController extends AppController
{
    private $wallet;
    private $activeTemplate;

    public function __construct(
        WalletServices $wallet
    )
    {
        $this->activeTemplate = activeTemplate();
        $this->wallet = $wallet;
    }

    public function income($status = null ){
        $pageTitle = 'My Income';
        $user = Auth::user();
		$sList = ['active'=>0,'completed'=>1,0=>0,1=>1];
		if( array_key_exists($status, $sList)){
			$status = $sList[$status];
		}
		
        $logs = Investment::where(['user_id' => $user->id, 'currency' => config('settings')->cur_text]);
		if( $status ){
			$logs = $logs->where('status', $status);
		}
		$logs = $logs->with('plan')->latest()->paginate(25);

        // Find All Plan
        $allPlan = Investment::select('amount', \DB::raw('interest_amount*total_paid AS earnings'))
			->where(['user_id' => $user->id, 'currency' => config('settings')->cur_text])->get();


        $userBalance = $this->wallet->getBalanceRaw($user, config('settings')->cur_text);
		
        if($userBalance instanceOf \Exception) {
            $notify[] = ['error', $userBalance->getMessage()];
            return back()->withNotify($notify);
        }

        // Count & Sum Purchase
        $sumDailys = $allPlan->sum('earnings');
        $sumIncome = $allPlan->sum('amount');

        $emptyMessage = 'Data Not Found';
        return view($this->activeTemplate.'user.my_income', compact('pageTitle', 'user', 'logs', 'status', 'sumDailys', 'sumIncome', 'emptyMessage','userBalance'));
    }


    function closeIncomet(){
        $pageTitle = 'Closed Order';
        $user = Auth::user();
        $logs = Investment::where(['user_id' => $user->id, 'status' => 1, 'currency' => config('settings')->cur_text])->with('plan')->latest()->paginate(getPaginate());
        $emptyMessage = 'Data Not Found';
        return view($this->activeTemplate.'user.investment_log', compact('pageTitle', 'user', 'logs', 'emptyMessage'));
    }

    public function incomeReport(){
        $pageTitle = 'Order Details';
        
        $user = User::find(\auth()->user()->id);

        $userBalance = $this->wallet->getBalance($user, config('settings')->cur_text);

        if($userBalance instanceOf \Exception) {
            $notify[] = ['error', $userBalance->getMessage()];
            return back()->withNotify($notify);
        }

        $logs = Investment::where('user_id', $user->id)->where(['status' => 0, 'currency' => config('settings')->cur_text])->with('plan')->latest()->paginate(getPaginate());
        $emptyMessage = 'Data Not Found';
        return view($this->activeTemplate.'user.revenue_report', compact('pageTitle', 'userBalance', 'user', 'logs', 'emptyMessage'));
    }

    public function incomeReceive(Request $request){//
        // Validate
        $validator = Validator::make($request->all(),[
            //'type' => 'required|string|in:receive,credit'
        ]);

        // Failed to validate
        if ($validator->fails()) {
            $errors = $validator->errors()->all();
            $notify[] = ['error', implode(' ', $errors)];
            return $this->handleResponse($request, implode(' ', $errors), 401, $notify);
        }

        $user = User::find(\auth()->user()->id);

        $userBalance = $this->wallet->incomeMoveToWallet($user, config('settings')->cur_text);

        if($userBalance instanceOf \Exception) {
            $notify[] = ['error', $userBalance->getMessage()];
            return $this->handleResponse($request, $userBalance->getMessage(), 401, $notify);
        }

        // Add Transaction
        $transaction = new Transaction();
        $transaction->user_id = $user->id;
        $transaction->type =  'income';
        $transaction->amount = $userBalance;
        $transaction->post_balance = $user->income;
        $transaction->charge = 0;
        $transaction->currency = config('settings')->cur_text;
        $transaction->trx_type = '+';
        $transaction->details = 'Income Received';
        $transaction->trx =  getTrx();
        $transaction->status =  1;
        $transaction->save();

        return $this->handleResponseRedirect($request, 'Successful Received', 200, url(route('user.investment.log')));

    }



}
