<?php

namespace App\Http\Controllers;

use Carbon\Carbon;
use App\Models\Game;
use App\Models\User;
use App\Models\Reward;
use App\Models\GameLog;
use App\Models\Investment;
use App\Models\RewardPlan;
use App\Models\Transaction;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Http\Services\RewardService;
use App\Http\Component\AppController;
use Illuminate\Support\Facades\Validator;



class RewardController extends AppController
{
    private $reward;
    private $activeTemplate;

    public function __construct(
        RewardService $reward
    )
    {
        $this->reward = $reward;
        $this->activeTemplate = activeTemplate();
    }

    public function claimReward($id = null){

       // User
       $user = User::find(\auth()->user()->id);

        // Claim Reward
       $reward = $this->reward->claimReward($user, $id);
       
       // Exception
       if($reward instanceof \Exception) {
        // Redirect
        $notify[] = ['error', $reward->getMessage()];
        return back()->withNotify($notify);
       }

       // Success Response
       $notify[] = ['success', 'Reward claim successful'];
       return back()->withNotify($notify);

    }

    public function reward()
    {
        $pageTitle = 'Rewards';
        $user = Auth::user();
        $rewards = Reward::where(['user_id' => $user->id, 'status' => 1])->orderBy('created_at')->take(20)->get();
        $pending_reward = Reward::where(['user_id' => $user->id, 'status' => 1])->sum('amount');
        
        return view($this->activeTemplate. 'reward.view', compact(
            'pageTitle',
            'user',
            'rewards',
            'pending_reward'
        ));
    }

    public function viewReward()
    {
        $pageTitle = 'Reward lists';
        $user = Auth::user();
        $rewards = RewardPlan::where(['status' => 1])->orderBy('id')->get();
		$pending_reward = Reward::select('plan_id')->where(['user_id' => $user->id, 'status' => 1])->pluck('plan_id')->toArray();

        return view($this->activeTemplate. 'reward.view', compact(
            'pageTitle',
            'user',
            'rewards',
            'pending_reward'
        ));
    }

    public function activateReward(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'id' => 'required|numeric',
        ]);
		
		// Failed to validate
		if ($validator->fails()) {
			$errors = $validator->errors()->all();
			$notify[] = ['error', implode(' ', $errors)];
			return $this->handleResponse($request, implode(' ', $errors), 401, $notify);
		}

        $user = auth()->user();

		$rewards = RewardPlan::where(['id' => $request->id, 'status' => 1])->first();

		if (!$rewards) {
			$notify[] = ['error', 'Selected reward not available'];
			return $this->handleResponse($request, 'Selected reward not available', 401, $notify);
		}
		$user_id = $user->id;
		
		// Type ~ 1 = Investment
		if( $rewards->type == 1 ){
			$requirement = $rewards->number;

			$invested = Investment::where('user_id', $user_id)->sum('amount');

			if( $invested < $requirement ){
				$msg = "Sorry! Your not eligible. You need to invest the sum of $requirement to activate reward.";
				$notify[] = ['error', $msg ];
				return $this->handleResponse($request, $msg, 401, $notify);
			}

			$msg = "Great! You already activated this reward task.";
		}

		// Type ~ 2 = Referral
		if( $rewards->type == 2 ){
			$requirement = $rewards->number;

			$referrals = Investment::with('user')->with('plan')->where(['currency' => config('settings')->cur_text])->whereHas('user', function ($query) use ($user_id) {
				$query->where('ref_by', $user_id);
			})->distinct('user_id')->count();
			
			if( $referrals < $requirement ){
				$msg = "Sorry! Your not eligible. You only have $referrals valid friends";
				$notify[] = ['error', $msg ];
				return $this->handleResponse($request, $msg, 401, $notify);
			}

			$msg = "Ooops! Your are already earning from this reward task. Go for more.";
		}

		// Type ~ 3 = Bonus
		if( $rewards->type == 3 ){
			
		}


		$hasReward = Reward::where(['user_id' => $user->id, 'plan_id' => $request->id])->count();
		if( $hasReward ){
			$notify[] = ['error', $msg ];
			return $this->handleResponse($request, $msg, 401, $notify);
		}

		// Claim Reward
	   $reward = $this->reward->reward($user, $rewards);
	   
	   // Exception
	   if($reward instanceof \Exception) {
			$msg = $reward->getMessage();
			$notify[] = ['error', $msg ];
			return $this->handleResponse($request, $msg, 401, $notify);
	   }
	   
		$msg = 'You have successfully activated this reward';
		$notify[] = ['success', $msg ];
		return $this->handleResponse($request, $msg, 200, $notify);

    }

    public function salary($type = 'all')
    {
        $pageTitle = "Weekly Salary";
        $user_id = auth()->user()->id;

        $rewards = RewardPlan::where(['type' => 2, 'status' => 1])->orderBy('id')->get();

        $referrals = Investment::with('user')->with('plan')->where(['currency' => session()->get('currency')])->whereHas('user', function ($query) use ($user_id) {
            $query->where('ref_by', $user_id);
        })->distinct('user_id')->count();

        $paidLevel = Transaction::where(['user_id' => $user_id, 'type' => 'salary'])->sum('number');

        $referrals = max(0, $referrals - $paidLevel);

        $now = Carbon::now();
        $nextSunday = $now->next(Carbon::SUNDAY)->setTime(10, 0, 0);

        $emptyMessage = "No Data Found!";
        return view($this->activeTemplate.'user.salary.history', compact('pageTitle','rewards', 'referrals', 'emptyMessage', 'nextSunday'));
    }

    public function games(){
        $data['pageTitle'] = 'System games';
        $data['user'] = Auth::user();
        return view($this->activeTemplate . 'user.games.index', $data);
    }

    public function wheelspin()
    {
        $data['user'] = $user = Auth::user();
        $game = Game::find(3);
		$data['games'] = GameLog::where('user_id', $user->id)->where('game_id', 3)->latest()->paginate(getPaginate(12));
        $data['plcost'] = @$game->min_limit;
        $data['pageTitle'] = "User Wheel Spin";
        return view($this->activeTemplate. 'user.games.spin', $data);
    }

    public function playspinWheel(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'number' => 'required|numeric',
        ]);$siRatio = 22.5;
		
        $user = auth()->user();
        if ($validator->fails()) {
            return response()->json(['errors' => $validator->errors()->all()]);
        }

        $game = Game::find(3);

        $running = GameLog::where('status',0)->where('user_id',$user->id)->where('game_id',$game->id)->first();
        if ($running) {
            return response()->json(['error' => '1 game is in-complete. Please wait']);
        }$invest = $game->min_limit;

        if ($invest > $user->balance) {
            return response()->json(['error' => 'Oops! You have no sufficient balance']);
        }
		$uLaDa = config('als'); 

        $bal = ($user->balance - $invest);
		
		$number = rand(1000, 6000) + $request->number;
		$ils = ceil($number/$siRatio);
		$number = $ils*$siRatio;
		$clamped = ($number % 360);
		$index = ceil($clamped / $siRatio);
		
		$reward = $uLaDa[$index][3];
		$coin   = $uLaDa[$index][4];
		$rate   = $uLaDa[$index][1];
		$value = round(( $reward * $rate),5);

		if( $value > $invest){
			$isWin = 1;
			$gainOrLost = round(($value - $invest), 4);
		}elseif( $value == $invest){
			$isWin = 2;
			$gainOrLost = 0;
		}else{
			$isWin = 0;
			$gainOrLost = round(($value - $invest), 4);
		}

        $gmLog = GameLog::create([
            'user_id' => $user->id,
            'game_id' => $game->id,
            'game_name' => 'spin',
            'user_select' => $isWin,
            'win_amo' => $reward,
            'result' => $number,
            'value' => $value,
            'coin' => $coin,
            'rate' => $rate,
            'status' => 1,
            'win_status' => 1,
            'invest' => $invest,
        ]);
		
		$user->balance = ($bal + $value);
		$user->save();

        $res['index'] = $index;
        $res['number'] = $number;
        $res['coin']   = $coin;
        $res['value']   = $value;
        $res['rate']   = $rate;
        $res['isWin']   = $isWin;
        $res['reward'] = $reward;
        $res['gainOrLost']   = $gainOrLost;
        $res['invest'] = $invest;
        $res['game_id'] = $gmLog->id;
        $res['created_at'] = showDatetime($gmLog->created_at,'jS F Y');
        $res['balance'] = $user->balance;
        return response()->json($res);
    }

}
