<?php

namespace App\Http\Controllers;
use App\Models\Frontend;
use App\Models\Language;
use App\Models\Page;
use App\Models\Plan;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Response;


class SiteController extends Controller
{
    public function __construct(){
        $this->activeTemplate = activeTemplate();
    }

    function fetch(){
        $account = get_account_info(request('account'), request('code'));
        return $account;
    }

    public function index(){

        $count = Page::where('tempname',$this->activeTemplate)->where('slug','home')->count();
        if($count == 0){
            $page = new Page();
            $page->tempname = $this->activeTemplate;
            $page->name = 'HOME';
            $page->slug = 'home';
            $page->save();
        }

        $reference = @$_GET['code'];
        if ($reference) {
            session()->put('reference', $reference);
            return redirect(route('user.register-form'));
        }

        return redirect(route('user.login'));

        $pageTitle = 'Home';
        $plans = Plan::where('platform', config('settings')->active_template)->orderBy('min_amount')->get();
        return view('landing',compact('pageTitle','plans'));

        $pageTitle = 'Home';
        $sections = Page::where('tempname',$this->activeTemplate)->where('slug','home')->first();
        $emptyMessage = 'Data Not Found';
        return view($this->activeTemplate . 'home', compact('pageTitle','sections', 'emptyMessage'));
    }

    public function invite($code = null){

       if ($code) {
            session()->put('reference', $code);
            return redirect(route('user.register-form'));
        }

        return redirect(route('user.login'));
    }

    public function pages($slug)
    {
        $page = Page::where('tempname',$this->activeTemplate)->where('slug',$slug)->firstOrFail();
        $pageTitle = $page->name;
        $sections = $page->secs;
        return view($this->activeTemplate . 'pages', compact('pageTitle','sections'));
    }


    public function contact()
    {
        $pageTitle = "Contact Us";
        return view($this->activeTemplate . 'contact',compact('pageTitle'));
    }


    public function contactSubmit(Request $request)
    {

        $this->validate($request, [
            'name' => 'required|max:191',
            'email' => 'required|email|max:191',
            'subject' => 'required|max:100',
            'message' => 'required',
        ]);

        sendContactEmail($request->email, $request->subject, $request->message, $request->name);

        $notify[] = ['success', 'ticket created successfully!'];
        return redirect()->route('home')->withNotify($notify);
    }

    public function changeLanguage($lang = null)
    {
        $language = Language::where('code', $lang)->first();
        if (!$language) $lang = 'en';
        session()->put('lang', $lang);
        return redirect()->back();
    }

    public function cookieAccept(){
        session()->put('cookie_accepted',true);
        $notify[] = ['success','Cookie accepted successfully'];
        return back()->withNotify($notify);
    }

    public function placeholderImage($size = null){
        $imgWidth = explode('x',$size)[0];
        $imgHeight = explode('x',$size)[1];
        $text = $imgWidth . '×' . $imgHeight;
        $fontFile = realpath('assets/font') . DIRECTORY_SEPARATOR . 'RobotoMono-Regular.ttf';
        $fontSize = round(($imgWidth - 50) / 8);
        if ($fontSize <= 9) {
            $fontSize = 9;
        }
        if($imgHeight < 100 && $fontSize > 30){
            $fontSize = 30;
        }

        $image     = imagecreatetruecolor($imgWidth, $imgHeight);
        $colorFill = imagecolorallocate($image, 100, 100, 100);
        $bgFill    = imagecolorallocate($image, 175, 175, 175);
        imagefill($image, 0, 0, $bgFill);
        $textBox = imagettfbbox($fontSize, 0, $fontFile, $text);
        $textWidth  = abs($textBox[4] - $textBox[0]);
        $textHeight = abs($textBox[5] - $textBox[1]);
        $textX      = ($imgWidth - $textWidth) / 2;
        $textY      = ($imgHeight + $textHeight) / 2;
        header('Content-Type: image/jpeg');
        imagettftext($image, $fontSize, 0, $textX, $textY, $colorFill, $fontFile, $text);
        imagejpeg($image);
        imagedestroy($image);
    }

    public function privacyPage($slug, $id){
        $content = Frontend::where('id', $id)->where('data_keys', 'policy_pages.element')->firstOrFail();
        $pageTitle = $content->data_values->title;
        return view($this->activeTemplate.'privacy_pages',compact('content','pageTitle'));
    }


    public function showCaptchaImage()
    {
		$textcolor = '#FFFFFF';
		
		$width				= '60'; 
		$height				= '30';
		$textall = array_merge_recursive(range('0', '9'));
		$code = '';
		for ($i = 0; $i < 4; $i++) {
			$tmptext  = mt_rand(0, 9);
			$randtext = $textall[$tmptext];
			$code .= $randtext;
		}
		$captchaSecret = rand(1000, 9999);

		Session::put('captcha_code', [$captchaSecret]);
		session()->put('captcha_code', [$captchaSecret]);
		
		header("Expires: -1");
		header("Cache-Control: no-store, private, post-check=0, pre-check=0, max-age=0", FALSE);
		header("Pragma: no-cache");

		if (function_exists('imagecreate') && function_exists('imagecolorset') && function_exists('imagecopyresized') && function_exists('imagecolorallocate') && function_exists('imagesetpixel') && function_exists('imagechar') && function_exists('imagecreatefromgif') && function_exists('imagepng')) {
			
			$im              = imagecreate($width, $height);
			$backgroundcolor = imagecolorallocate($im, 255, 255, 255);
			
			$numorder = array(1,2,3,4);
			shuffle($numorder);
			$numorder = array_flip($numorder);
			
			for ($i = 1; $i <= 4; $i++) {
				$x          = $numorder[$i] * 13 + mt_rand(0, 4) - 2;
				$y          = mt_rand(0, 3);
				$text_color = imagecolorallocate($im, mt_rand(50, 255), mt_rand(50, 128), mt_rand(50, 255));
				imagechar($im, 5, $x + 5, $y + 3, $code[$numorder[$i]], $text_color);
			}
			$linenums = mt_rand(10, 32);
			for ($i = 0; $i <= $linenums; $i++) {
				$linecolor = imagecolorallocate($im, mt_rand(0, 255), mt_rand(0, 255), mt_rand(0, 255));
				$linex     = mt_rand(0, $width);
				$liney     = mt_rand(0, $height);
				imageline($im, $linex, $liney, $linex + mt_rand(0, 4) - 2, $liney + mt_rand(0, 4) - 2, $linecolor);
			}
			
			for ($i = 0; $i <= 40; $i++) {
				$pointcolor = imagecolorallocate($im, mt_rand(50, 255), mt_rand(50, 255), mt_rand(50, 255));
				imagesetpixel($im, mt_rand(0, $width), mt_rand(0, $height), $pointcolor);
			}
			
			$bordercolor = imagecolorallocate($im, 150, 150, 150);
			imagerectangle($im, 0, 0, $width - 1, $height - 1, $bordercolor);
			
			header('Content-type: image/png');
			imagepng($im);
			imagedestroy($im);
			
		} else {
			
			$numbers = array(
				0 => array('3c','66','66','66','66','66','66','66','66','3c'),
				1 => array('1c','0c','0c','0c','0c','0c','0c','0c','1c','0c'),
				2 => array('7e','60','60','30','18','0c','06','06','66','3c'),
				3 => array('3c','66','06','06','06','1c','06','06','66','3c'),
				4 => array('1e','0c','7e','4c','2c','2c','1c','1c','0c','0c'),
				5 => array('3c','66','06','06','06','7c','60','60','60','7e'),
				6 => array('3c','66','66','66','66','7c','60','60','30','1c'),
				7 => array('30','30','18','18','0c','0c','06','06','66','7e'),
				8 => array('3c','66','66','66','66','3c','66','66','66','3c'),
				9 => array('38','0c','06','06','3e','66','66','66','66','3c')
			);
			
			for ($i = 0; $i < 10; $i++) {
				for ($j = 0; $j < 6; $j++) {
					$a1 = substr('012', mt_rand(0, 2), 1) . substr('012345', mt_rand(0, 5), 1);
					$a2 = substr('012345', mt_rand(0, 5), 1) . substr('0123', mt_rand(0, 3), 1);
					mt_rand(0, 1) == 1 ? array_push($numbers[$i], $a1) : array_unshift($numbers[$i], $a1);
					mt_rand(0, 1) == 0 ? array_push($numbers[$i], $a1) : array_unshift($numbers[$i], $a2);
				}
			}
			
			$bitmap = array();
			for ($i = 0; $i < 20; $i++) {
				for ($j = 0; $j < 4; $j++) {
					$n     = substr($code, $j, 1);
					$bytes = $numbers[$n][$i];
					$a     = mt_rand(0, 14);
					switch ($a) {
						case 1:
							str_replace('9', '8', $bytes);
							break;
						case 3:
							str_replace('c', 'e', $bytes);
							break;
						case 6:
							str_replace('3', 'b', $bytes);
							break;
						case 8:
							str_replace('8', '9', $bytes);
							break;
						case 0:
							str_replace('e', 'f', $bytes);
							break;
					}
					array_push($bitmap, $bytes);
				}
			}
			
			for ($i = 0; $i < 8; $i++) {
				$a = substr('012', mt_rand(0, 2), 1) . substr('012345', mt_rand(0, 5), 1);
				array_unshift($bitmap, $a);
				array_push($bitmap, $a);
			}
			
			$image = pack('H*', '424d9e000000000000003e000000280000002000000018000000010001000000' . '0000600000000000000000000000000000000000000000000000FFFFFF00' . implode('', $bitmap));
			
			header('Content-Type: image/bmp');
			echo $image;
		}
	}

    public function showCaptchaImages()
    {
		$captchaCode = rand(1000, 9999);
		
		$image = generateBase64Image($captchaCode);

		Session::put('captcha_code', $captchaCode);

        $image = generateCaptchaImage();

        // Set the response type
        $response = Response::make($image->encode('png'));

        // Set content type to PNG image
        $response->header('Content-Type', 'image/png');

        return $response;
    }

}
