<?php

namespace App\Http\Controllers;

use App\Http\Component\AppController;
use App\Models\Investment;
use App\Models\Transaction;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Http\Request;
use App\Http\Services\WalletServices;
use App\Models\Team;
use Illuminate\Support\Facades\Validator;

class TeamController extends AppController
{
    private $wallet;
    private $activeTemplate;

    public function __construct(
        WalletServices $wallet
    )
    {
        $this->activeTemplate = activeTemplate();
        $this->wallet = $wallet;
    }
	
	public function index(){
		
        $data['levels'] = Team::where(['commission_type' => 'interest'])->get();
        $data['user'] = auth()->user();
        $data['pageTitle'] = 'My Team';
		$data['code'] = $data['user']->ref_code;
        $data['totalReferral'] = User::where("ref_by", $data['user']->id)->count();
		$data['link'] = route('invite', ['code' => $data['code']]);

        return view($this->activeTemplate.'user.team.index', $data);
	}

	public function invitation(){
		
        $data['levels'] = Team::where(['commission_type' => 'interest'])->get();
        $data['user'] = auth()->user();
        $data['pageTitle'] = 'Users invitation';
		$data['code'] = $data['user']->ref_code;
        $data['totalReferral'] = User::where("ref_by", $data['user']->id)->count();
		$data['link'] = route('invite', ['code' => $data['code']]);
		$data['color'] = getTextColor($data['code']);

        $data['QRCode'] = cryptoQR($data['link'], $data['color']);

        return view($this->activeTemplate.'user.team.invite', $data);
	}

    public function teamView($lev_id = 1){

        $user = auth()->user();
		$usr[1] = User::select('id')->where('ref_by', $user->id)->pluck('id')->toArray(); 
		$lGot[1] = Transaction::where('type', 'commission')->where('user_id', $user->id)->where('ref_level', 1)->sum('amount');
		$ids[1] = [$user->id];

        $levels = Team::where(['commission_type' => 'interest'])->get();

		if( isset($levels[1]) ){
			$usr[2] = User::select('id')->whereIn('ref_by', $usr[1])->pluck('id')->toArray(); 
			$lGot[2] = Transaction::where('type', 'commission')->where('user_id', $user->id)->where('ref_level', 2)->sum('amount');
			$ids[2] = $usr[2];
		}

		if( isset($levels[2]) ){
			$usr[3] = User::select('id')->whereIn('ref_by', $usr[2])->pluck('id')->toArray(); 
			$lGot[3] = Transaction::where('type', 'commission')->where('user_id', $user->id)->where('ref_level', 3)->sum('amount');
			$ids[3] = $usr[3];
		}

		$userList = User::select('id','mobile','username','invested','ref_code','created_at')->whereIn('ref_by', $ids[$lev_id])->paginate(20); 

        $pageTitle = 'My Team';
        return view($this->activeTemplate.'user.team.lists',compact('pageTitle', 'usr','lev_id','lGot','levels','userList','user'));
	}

    public function teamLevel($lev_id = 1){

        $user = auth()->user();
		$usr = User::select('id')->where('ref_by', $user->id)->pluck('id')->toArray(); 
		$lGot = Transaction::where('type', 'commission')->where('user_id', $user->id)->where('ref_level', 1);
		$ids = [$user->id];

        $levels = Team::where(['commission_type' => 'interest'])->get();

		foreach($levels as $key => $level){
			if( $key == 0 || $lev_id != $level->level ) continue;
			
			$usr = User::select('id')->whereIn('ref_by', $usr)->pluck('id')->toArray(); 
			$lGot = Transaction::where('type', 'commission')->where('user_id', $user->id)->where('ref_level', $level->level);
			$ids = $usr;
		}

		$userList = User::select('id','mobile','username','invested','ref_code','created_at')->whereIn('ref_by', $ids)->paginate(20); 

        $pageTitle = 'My Team';
        return view($this->activeTemplate.'user.team.lists',compact('pageTitle', 'usr','lev_id','lGot','levels','userList','user'));
	}

    public function team($lev_id = 1){

        $code = auth()->user()->id;
        $date = date("Y-m-d");

        // FIRST LEVEL
        $firstLevel = User::where("ref_by", $code)->get();

        // Second LEVEL
        $totalTeamMember = 0;
        $todaytotalRecharge = 0;
        $ActiveMemberstotal = 0;
        $todayInvest = 0;
        $totalInvest = 0;
        $todayCommission = 0;
        $totalCommission = 0;
        $levelUsers = array();
        $commission_rate = 0;

        $rebate = Team::where(['level' => $lev_id, 'commission_type' => 'interest'])->first();
		
        if($firstLevel){

            // GET all users
            if($lev_id == 1) {
                $levelUsers = $firstLevel;
                $commission_rate = $rebate->percent;
            }

            foreach($firstLevel as $user2){

                // Selected level
                if($lev_id == 1) {

                    $totalTeamMember++;
                    $todayInvestsum = Investment::where("user_id", $user2->id)->whereDate("created_at", "=", $date)->sum('amount');
                    $todayInvest += $todayInvestsum;

                    $totalInvestsum = Investment::where("user_id", $user2->id)->sum('amount');
                    $totalInvest += $totalInvestsum;

                    $todaCommissionsum = Transaction::where("user_id", $user2->id)->whereIn('type', ['commission'])->whereDate("created_at", "=", $date)->sum('amount');
                    $todayCommission += $todaCommissionsum;

                    $totalCommissionsum = Transaction::where("user_id", $user2->id)->whereIn('type', ['commission'])->sum('amount');
                    $totalCommission += $totalCommissionsum;

                    // Subquery to get the latest purchase ID for each user_id
                    $subQuery = Investment::select('user_id',\DB::raw('MAX(id) as max_id'))
                    ->where('user_id', $user2->id)->where('plan_id', '!=', 1)
                    ->groupBy('user_id');

                    // Main query to join with the subquery and get the full purchase records
                    $ActiveMembers = Investment::joinSub($subQuery, 'latest', function ($join) {
                    $join->on('investments.id', '=', 'latest.max_id');
                    })->get();

                    if($ActiveMembers){
                        foreach ($ActiveMembers as $key => $ActiveMembersvalue) {

                            $ActiveMemberstotal++;
                        }
                    }
                }


                $user2 = User::where("ref_by", $user2->id)->get();
                //
                if($user2){
                    foreach($user2 as $user){
                        $secondLevel[] = $user;
                    }
                }
            }
        }

        // SECOND LEVEL
        $thirdLevel = array();
        if(isset($secondLevel) && count($secondLevel) > 0){

            // GET all users
            if($lev_id == 2) {
                $levelUsers = $secondLevel;
                $commission_rate = $rebate->percent;
            }

            foreach($secondLevel as $user3){
                
                // Selected level
                if($lev_id == 2) {
                    $totalTeamMember++;

                    $todayInvestsum = Investment::where("user_id", $user3->id)->whereDate("created_at", "=", $date)->sum('amount');
                    $todayInvest += $todayInvestsum;

                    $totalInvestsum = Investment::where("user_id", $user3->id)->sum('amount');
                    $totalInvest += $totalInvestsum;

                    $todaCommissionsum = Transaction::where("user_id", $user3->id)->whereIn('type', ['commission'])->whereDate("created_at", "=", $date)->sum('amount');
                    $todayCommission += $todaCommissionsum;

                    $totalCommissionsum = Transaction::where("user_id", $user3->id)->whereIn('type', ['commission'])->sum('amount');
                    $totalCommission += $totalCommissionsum;

                    // Subquery to get the latest purchase ID for each user_id
                    $subQuery = Investment::select('user_id', \DB::raw('MAX(id) as max_id'))
                    ->where('user_id', $user3->id)->where('plan_id', '!=', 1)
                    ->groupBy('user_id');

                    // Main query to join with the subquery and get the full purchase records
                    $ActiveMembers = Investment::joinSub($subQuery, 'latest', function ($join) {
                    $join->on('investments.id', '=', 'latest.max_id');
                    })->get();

                    if($ActiveMembers){
                        foreach ($ActiveMembers as $key => $ActiveMembersvalue) {

                            $ActiveMemberstotal++;
                        }
                    }
                }


                $user4 = User::where("ref_by", $user3->id)->get();
                if($user4){
                    foreach($user4 as $user){
                        $thirdLevel[] = $user;
                        //$totalTeamMember++;
                    }
                }
            }
        }

        // THIRD LEVEL
        $fourthLevel = array();
        if(isset($thirdLevel) && count($thirdLevel) > 0){

            // GET all users
            if($lev_id == 3) {
                $levelUsers = $thirdLevel;
                $commission_rate = $rebate->percent;
            }

            foreach($thirdLevel as $user5){
                
                // Selected level
                if($lev_id == 3) {
                    $totalTeamMember++;
                    
                    $todayInvestsum = Investment::where("user_id", $user5->id)->whereDate("created_at", "=", $date)->sum('amount');
                    $todayInvest += $todayInvestsum;

                    $totalInvestsum = Investment::where("user_id", $user5->id)->sum('amount');
                    $totalInvest += $totalInvestsum;

                    $todaCommissionsum = Transaction::where("user_id", $user5->id)->whereIn('type', ['commission'])->whereDate("created_at", "=", $date)->sum('amount');
                    $todayCommission += $todaCommissionsum;

                    $totalCommissionsum = Transaction::where("user_id", $user5->id)->whereIn('type', ['commission'])->sum('amount');
                    $totalCommission += $totalCommissionsum;


                    // Subquery to get the latest purchase ID for each user_id
                    $subQuery = Investment::select('user_id', \DB::raw('MAX(id) as max_id'))
                    ->where('user_id', $user5->id)->where('plan_id', '!=', 1)
                    ->groupBy('user_id');

                    // Main query to join with the subquery and get the full purchase records
                    $ActiveMembers = Investment::joinSub($subQuery, 'latest', function ($join) {
                    $join->on('investments.id', '=', 'latest.max_id');
                    })->get();

                    if($ActiveMembers){
                        foreach ($ActiveMembers as $key => $ActiveMembersvalue) {

                            $ActiveMemberstotal++;
                        }
                    }
                }


                $user6 = User::where("ref_by", $user5->id)->get();
                
                if($user6){
                    foreach($user6 as $user){
                        $fourthLevel[] = $user;
                    }
                }
            }
        }
		
        $levels = Team::where(['commission_type' => 'interest'])->get();

        $pageTitle = 'My Team';
        return view($this->activeTemplate.'user.team.lists',compact('pageTitle', 'lev_id','todayInvest','totalInvest','todayCommission','totalCommission', 'totalTeamMember', 'levelUsers', 'ActiveMemberstotal', 'commission_rate', 'levels'));
    }
    
    public function invite($lev_id = null){

        $invites = User::where('ref_by',auth()->user()->id)->get();

        $referrals = count($invites);
        $lv_no = 1;
        $user_id = auth()->user()->id;

        // Find Income
        $findIncome = Investment::with('user')->with('plan')->where(['currency' => session()->get('currency')])->whereHas('user', function ($query) use ($user_id) {
            $query->where('ref_by', $user_id);
        });

        // Count & Sum
        $plan_amount = $findIncome->sum('amount');
        $number_people_invest = $findIncome->distinct('user_id')->count();

        // Find Income
        $findTimeIncome = Investment::with('user')->with('plan')->where(['currency' => session()->get('currency')])->whereHas('user', function ($query) use ($user_id) {
            $query->where('ref_by', $user_id);
        });
        
        // Get the current date and time
        $currentDate = Carbon::now()->startOfDay();
        $todayQuery = $findTimeIncome->where('created_at', '>=', $currentDate);

        $today_invest_amount = $todayQuery->sum('amount');
        $today_invest_number = $todayQuery->count();
        $today_invest_people_number = $todayQuery->distinct('user_id')->count();

        // Find Team package
        $teams = Team::where('commission_type', 'interest')->get();
        
        // Calculate level
        if(count($teams) < 1) {
            $lv_no = 1;
        } elseif (count($teams) < 2) {
            $lv_no = 2;
        } elseif (count($teams) < 3) {
            $lv_no = 3;
        }

        $lv_no = ($lev_id) ? $lev_id : $lv_no;

        $team = Team::where(['level' => $lv_no, 'commission_type' => 'interest'])->first();

        $plan_amount = ($team) ? $plan_amount * $team->percent / 100 : 0.00;

        $pageTitle = 'Invite Friends';
        return view($this->activeTemplate.'user.team.invite',compact('pageTitle', 'invites', 'referrals', 'lv_no', 'user_id', 'teams', 'team', 'plan_amount', 'number_people_invest', 'today_invest_amount', 'today_invest_number', 'today_invest_people_number'));
    }

    public function commissionReceive(Request $request){
        // Validate
        $validator = Validator::make($request->all(),[
            'type' => 'required|string|in:receive,credit'
        ]);

        // Failed to validate
        if ($validator->fails()) {
            $errors = $validator->errors()->all();
            $notify[] = ['error', implode(' ', $errors)];
            return $this->handleResponse($request, implode(' ', $errors), 401, $notify);
        }

        $user = User::find(\auth()->user()->id);

        $userBalance = $this->wallet->incomeMoveToWallet($user, session()->get('currency'));

        if($userBalance instanceOf \Exception) {
            $notify[] = ['error', $userBalance->getMessage()];
            return $this->handleResponse($request, $userBalance->getMessage(), 401, $notify);
        }

        // Add Transaction
        $transaction = new Transaction();
        $transaction->user_id = $user->id;
        $transaction->type =  'income';
        $transaction->amount = $userBalance;
        $transaction->post_balance = $user->balance;
        $transaction->charge = $userBalance;
        $transaction->currency = session()->get('currency');
        $transaction->trx_type = '-';
        $transaction->details = 'Income Received';
        $transaction->trx =  getTrx();
        $transaction->status =  1;
        $transaction->save();

        return $this->handleResponseRedirect($request, 'Successful Received', 200, url(route('user.investment.log')));

    }



}
