<?php

use App\Lib\GoogleAuthenticator;
use App\Lib\SendSms;
use App\Models\EmailTemplate;
use App\Models\Extension;
use App\Models\Frontend;
use App\Models\GeneralSetting;
use App\Models\SmsTemplate;
use App\Models\EmailLog;
use App\Models\Team;
use App\Models\Transaction;
use App\Models\Notification;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Support\Facades\Mail;
use PHPMailer\PHPMailer\Exception;
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\SMTP;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Response;
use Intervention\Image\Facades\Image;
use Intervention\Image\ImageManager;
use Illuminate\Support\Facades\Cache;


function sidebarVariation(){

    /// for sidebar
    $variation['sidebar'] = 'bg_img';

    //for selector
    $variation['selector'] = 'capsule--rounded';

    //for overlay
    $variation['overlay'] = 'overlay--indigo';

    //Opacity
    $variation['opacity'] = 'overlay--opacity-8'; // 1-10

    return $variation;

}

function systemDetails()
{
    $system['name'] = 'Fine-Gold';
    $system['version'] = '1.2';
    return $system;
}

function getLatestVersion()
{
    return '';
    $param['purchasecode'] = env("PURCHASECODE");
    $param['website'] = @$_SERVER['HTTP_HOST'] . @$_SERVER['REQUEST_URI'] . ' - ' . env("APP_URL");
    $url = 'https://license.viserlab.com/updates/version/' . systemDetails()['name'];
    $result = curlPostContent($url, $param);
    if ($result) {
        return $result;
    } else {
        return null;
    }
}


function slug($string)
{
    return Illuminate\Support\Str::slug($string);
}


function shortDescription($string, $length = 120)
{
    return Illuminate\Support\Str::limit($string, $length);
}


function shortCodeReplacer($shortCode, $replace_with, $template_string)
{
    return str_replace($shortCode, $replace_with, $template_string);
}


function verificationCode($length)
{
    if ($length == 0) return 0;
    $min = pow(10, $length - 1);
    $max = 0;
    while ($length > 0 && $length--) {
        $max = ($max * 10) + 9;
    }
    return random_int($min, $max);
}

function getNumber($length = 8)
{
    $characters = '1234567890';
    $charactersLength = strlen($characters);
    $randomString = '';
    for ($i = 0; $i < $length; $i++) {
        $randomString .= $characters[rand(0, $charactersLength - 1)];
    }
    return $randomString;
}



//moveable
function uploadImage($file, $location, $size = null, $old = null, $thumb = null)
{
    $path = makeDirectory($location);
    if (!$path) throw new Exception('File could not been created.');

    if ($old) {
        removeFile($location . '/' . $old);
        removeFile($location . '/thumb_' . $old);
    }
	$extension = $file->getClientOriginalExtension();
    $filename = uniqid() . time() . '.' . $extension;

	if( in_array($extension, ['svg','avif'])){
		$file->move($location, $filename);
	}else{
		$image = Image::make($file);
		if ($size) {
			$size = explode('x', strtolower($size));
			$image->resize($size[0], $size[1]);
		}
		$image->save($location . '/' . $filename);

		if ($thumb) {
			$thumb = explode('x', $thumb);
			Image::make($file)->resize($thumb[0], $thumb[1])->save($location . '/thumb_' . $filename);
		}
	}

    return $filename;
}

function uploadFile($file, $location, $size = null, $old = null){
    $path = makeDirectory($location);
    if (!$path) throw new Exception('File could not been created.');

    if ($old) {
        removeFile($location . '/' . $old);
    }

    $filename = uniqid() . time() . '.' . $file->getClientOriginalExtension();
    $file->move($location,$filename);
    return $filename;
}

function makeDirectory($path)
{
    if (file_exists($path)) return true;
    return mkdir($path, 0755, true);
}


function removeFile($path)
{
    return file_exists($path) && is_file($path) ? @unlink($path) : false;
}

function gs()
{
    $general = Cache::get('GeneralSetting');
	if (!$general) {
        $general = GeneralSetting::first();
        Cache::put('GeneralSetting', $general);
    }
    return $general;
}


function activeTemplate($asset = false)
{
	$template = config('settings')->active_template;
    $sess = session()->get('template');
    if (trim($sess)) {
        $template = $sess;
    }
    if ($asset) return 'assets/templates/' . $template . '/';
    return 'templates.' . $template . '.';
}

function activeTemplateName()
{
	$template = config('settings')->active_template;
    $sess = session()->get('template');
    if (trim($sess)) {
        $template = $sess;
    }
    return $template;
}


function loadReCaptcha()
{
    $reCaptcha = Extension::where('act', 'google-recaptcha2')->where('status', 1)->first();
    return $reCaptcha ? $reCaptcha->generateScript() : '';
}


function loadAnalytics()
{
    $analytics = Extension::where('act', 'google-analytics')->where('status', 1)->first();
    return $analytics ? $analytics->generateScript() : '';
}

function loadTawkto()
{
    $tawkto = Extension::where('act', 'tawk-chat')->where('status', 1)->first();
    return $tawkto ? $tawkto->generateScript() : '';
}


function loadFbComment()
{
    $comment = Extension::where('act', 'fb-comment')->where('status',1)->first();
    return  $comment ? $comment->generateScript() : '';
}

function loadCustomCaptcha($height = 46, $width = '300px', $bgcolor = '#003', $textcolor = '#abc')
{
    $textcolor = '#'.config('settings')->base_color;
    $captcha = Extension::where('act', 'custom-captcha')->where('status', 1)->first();
    if (!$captcha) {
        return 0;
    }
    $code = rand(100000, 999999);
    $char = str_split($code);
    $ret = '<link href="https://fonts.googleapis.com/css?family=Henny+Penny&display=swap" rel="stylesheet">';
    $ret .= '<div style="height: ' . $height . 'px; line-height: ' . $height . 'px; width:' . $width . '; text-align: center; background-color: ' . $bgcolor . '; color: ' . $textcolor . '; font-size: ' . ($height - 20) . 'px; font-weight: bold; letter-spacing: 20px; font-family: \'Henny Penny\', cursive;  -webkit-user-select: none; -moz-user-select: none;-ms-user-select: none;user-select: none;  display: flex; justify-content: center;">';
    foreach ($char as $value) {
        $ret .= '<span style="    float:left;     -webkit-transform: rotate(' . rand(-60, 60) . 'deg);">' . $value . '</span>';
    }
    $ret .= '</div>';
    $captchaSecret = hash_hmac('sha256', $code, $captcha->shortcode->random_key->value);
    $ret .= '<input type="hidden" name="captcha_secret" value="' . $captchaSecret . '">';
    return $ret;
}


function captchaVerify($code, $secret)
{
    $captcha = Extension::where('act', 'custom-captcha')->where('status', 1)->first();
    $captchaSecret = hash_hmac('sha256', $code, $captcha->shortcode->random_key->value);
    if ($captchaSecret == $secret) {
        return true;
    }
    return false;
}

function generateCaptchaImage()
{
    $captchaCode = rand(1000, 9999);

    // Use Intervention\Image\ImageManager to create an image instance
    $manager = new ImageManager(['driver' => 'gd']);

    // Create an image from a base64-encoded string
    //$image = $manager->make(generateBase64Image($captchaCode));
    $image = generateBase64Image($captchaCode);

    Session::put('captcha_code', $captchaCode);

    return $image;
}

function generateBase64Image($captchaCode)
{
    // Adjust this as needed based on your font and image preferences
    $imagePath = 'assets/images/capture.png';
    $fontPath = 'assets/font/RobotoMono-Regular.ttf';

    $image = imagecreatefrompng($imagePath);
    $textColor = imagecolorallocate($image, 255, 255, 255);

    // Calculate text size and position
    $fontSize = 34; // Adjust as needed
    $textBox = imagettfbbox($fontSize, 0, $fontPath, $captchaCode);
    $textWidth = $textBox[2] - $textBox[0];
    $textHeight = $textBox[1] - $textBox[7];
    $x = (imagesx($image) - $textWidth) / 2;
    $y = (imagesy($image) + $textHeight) / 2;

    // Set text color (adjust as needed)
    $textColor = imagecolorallocate($image, 255, 255, 255);

    // Add text to the image
    imagettftext($image, $fontSize, 0, $x, $y, $textColor, $fontPath, $captchaCode);

    ob_start();
    imagepng($image);
    $imageData = ob_get_clean();
    imagedestroy($image);

    return 'data:image/png;base64,' . base64_encode($imageData);
}

function getTrx($length = 12, $text = false )
{
    $characters = 'ABCDEFGHJKMNOPQRSTUVWXYZ';
    $number = '123456789';
	if( !$text ){
		$characters .= $number;
	}
    $charactersLength = strlen($characters);
    $randomString = '';
    for ($i = 0; $i < $length; $i++) {
        $randomString .= $characters[rand(0, $charactersLength - 1)];
    }
    return $randomString;
}


function getAmount($amount, $length = 2)
{
    $amount = round($amount, $length);
    return $amount + 0;
}

function showAmount($amount, $decimal = 2, $separate = true, $exceptZeros = false){
    $separator = '';
    if($separate){
        $separator = ',';
    }
    $printAmount = number_format($amount, $decimal, '.', $separator);
    if($exceptZeros){
    $exp = explode('.', $printAmount);
        if($exp[1]*1 == 0){
            $printAmount = $exp[0];
        }
    }
    return $printAmount;
}

function amount_format($amount){
    return number_format($amount);
}


function removeElement($array, $value)
{
    return array_diff($array, (is_array($value) ? $value : array($value)));
}

function cryptoQR($wallet, $backcolor ='#ffffff', $size = 'small')
{
    return "https://qrcode.tec-it.com/API/QRCode?data=$wallet&backcolor=$backcolor&size=$size&quietzone=1&errorcorrection=H";
	//$urlencoded = urlencode('?secret='.$secret.'&issuer='.$user->username . '@' . config('settings')->sitename);
	//$qrCodeUrl = "https://api.qrserver.com/v1/create-qr-code/?data=$urlencoded&size=300x300&ecc=M";
}

//moveable
function curlContent($url)
{
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $result = curl_exec($ch);
    curl_close($ch);
    return $result;
}

//moveable
function curlPostContent($url, $arr = null)
{
    if ($arr) {
        $params = http_build_query($arr);
    } else {
        $params = '';
    }
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $params);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $result = curl_exec($ch);
    curl_close($ch);
    return $result;
}


function inputTitle($text)
{
    return ucfirst(preg_replace("/[^A-Za-z0-9 ]/", ' ', $text));
}


function titleToKey($text)
{
    return strtolower(str_replace(' ', '_', $text));
}


function str_limit($title = null, $length = 10)
{
    return \Illuminate\Support\Str::limit($title, $length);
}

//moveable
function getIpInfo()
{
    $ip = $_SERVER["REMOTE_ADDR"];

    //Deep detect ip
    if (filter_var(@$_SERVER['HTTP_X_FORWARDED_FOR'], FILTER_VALIDATE_IP)){
        $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
    }
    if (filter_var(@$_SERVER['HTTP_CLIENT_IP'], FILTER_VALIDATE_IP)){
        $ip = $_SERVER['HTTP_CLIENT_IP'];
    }


    $xml = @simplexml_load_file("http://www.geoplugin.net/xml.gp?ip=" . $ip);


    $country = @$xml->geoplugin_countryName;
    $city = @$xml->geoplugin_city;
    $area = @$xml->geoplugin_areaCode;
    $code = @$xml->geoplugin_countryCode;
    $long = @$xml->geoplugin_longitude;
    $lat = @$xml->geoplugin_latitude;

    $data['country'] = $country;
    $data['city'] = $city;
    $data['area'] = $area;
    $data['code'] = $code;
    $data['long'] = $long;
    $data['lat'] = $lat;
    $data['ip'] = request()->ip();
    $data['time'] = date('d-m-Y h:i:s A');


    return $data;
}

//moveable
function osBrowser(){
    $userAgent = $_SERVER['HTTP_USER_AGENT'];
    $osPlatform = "Unknown OS Platform";
    $osArray = array(
        '/windows nt 10/i' => 'Windows 10',
        '/windows nt 6.3/i' => 'Windows 8.1',
        '/windows nt 6.2/i' => 'Windows 8',
        '/windows nt 6.1/i' => 'Windows 7',
        '/windows nt 6.0/i' => 'Windows Vista',
        '/windows nt 5.2/i' => 'Windows Server 2003/XP x64',
        '/windows nt 5.1/i' => 'Windows XP',
        '/windows xp/i' => 'Windows XP',
        '/windows nt 5.0/i' => 'Windows 2000',
        '/windows me/i' => 'Windows ME',
        '/win98/i' => 'Windows 98',
        '/win95/i' => 'Windows 95',
        '/win16/i' => 'Windows 3.11',
        '/macintosh|mac os x/i' => 'Mac OS X',
        '/mac_powerpc/i' => 'Mac OS 9',
        '/linux/i' => 'Linux',
        '/ubuntu/i' => 'Ubuntu',
        '/iphone/i' => 'iPhone',
        '/ipod/i' => 'iPod',
        '/ipad/i' => 'iPad',
        '/android/i' => 'Android',
        '/blackberry/i' => 'BlackBerry',
        '/webos/i' => 'Mobile'
    );
    foreach ($osArray as $regex => $value) {
        if (preg_match($regex, $userAgent)) {
            $osPlatform = $value;
        }
    }
    $browser = "Unknown Browser";
    $browserArray = array(
        '/msie/i' => 'Internet Explorer',
        '/firefox/i' => 'Firefox',
        '/safari/i' => 'Safari',
        '/chrome/i' => 'Chrome',
        '/edge/i' => 'Edge',
        '/opera/i' => 'Opera',
        '/netscape/i' => 'Netscape',
        '/maxthon/i' => 'Maxthon',
        '/konqueror/i' => 'Konqueror',
        '/mobile/i' => 'Handheld Browser'
    );
    foreach ($browserArray as $regex => $value) {
        if (preg_match($regex, $userAgent)) {
            $browser = $value;
        }
    }

    $data['os_platform'] = $osPlatform;
    $data['browser'] = $browser;

    return $data;
}

function siteName()
{
    $sitname = str_word_count(config('settings')->sitename);
    $sitnameArr = explode(' ', config('settings')->sitename);
    if ($sitname > 1) {
        $title = "<span>$sitnameArr[0] </span> " . str_replace($sitnameArr[0], '', config('settings')->sitename);
    } else {
        $title = "<span>".config('settings')->sitename."</span>";
    }

    return $title;
}


//moveable
function getTemplates()
{
	return config('settings')->active_template;

    $param['purchasecode'] = env("PURCHASECODE");
    $param['website'] = @$_SERVER['HTTP_HOST'] . @$_SERVER['REQUEST_URI'] . ' - ' . env("APP_URL");
    $url = 'https://license.viserlab.com/updates/templates/' . systemDetails()['name'];
    $result = curlPostContent($url, $param);
    if ($result) {
        return $result;
    } else {
        return null;
    }
}


function getPageSections($arr = false)
{

    $jsonUrl = resource_path('views/') . str_replace('.', '/', activeTemplate()) . 'sections.json';
    $sections = json_decode(file_get_contents($jsonUrl));
    if ($arr) {
        $sections = json_decode(file_get_contents($jsonUrl), true);
        ksort($sections);
    }
    return $sections;
}


function getImage($image,$size = null)
{
    $clean = '';
    if (file_exists($image) && is_file($image)) {
        return asset($image) . $clean;
    }
    if ($size) {
        return route('placeholder.image',$size);
    }
    return asset('assets/images/default.png');
}

function notify($user, $type, $shortCodes = null)
{

    sendEmail($user, $type, $shortCodes);
    sendSms($user, $type, $shortCodes);
}



function sendSms($user, $type, $shortCodes = [])
{
    $smsTemplate = SmsTemplate::where('act', $type)->where('sms_status', 1)->first();
    $gateway = config('settings')->sms_config->name;
    $sendSms = new SendSms;
    if (config('settings')->sn == 1 && $smsTemplate) {
        $template = $smsTemplate->sms_body;
        foreach ($shortCodes as $code => $value) {
            $template = shortCodeReplacer('{{' . $code . '}}', $value, $template);
        }
        $message = shortCodeReplacer("{{message}}", $template, config('settings')->sms_api);
        $message = shortCodeReplacer("{{name}}", $user->username, $message);
        $sendSms->$gateway($user->mobile, config('settings')->sitename,$message, config('settings')->sms_config);
    }
}

function sendEmail($user, $type = null, $shortCodes = [])
{

    $emailTemplate = EmailTemplate::where('act', $type)->where('email_status', 1)->first();
    if (config('settings')->en != 1 || !$emailTemplate) {
        return;
    }


    $message = shortCodeReplacer("{{fullname}}", $user->fullname, config('settings')->email_template);
    $message = shortCodeReplacer("{{username}}", $user->username, $message);
    $message = shortCodeReplacer("{{message}}", $emailTemplate->email_body, $message);

    if (empty($message)) {
        $message = $emailTemplate->email_body;
    }

    foreach ($shortCodes as $code => $value) {
        $message = shortCodeReplacer('{{' . $code . '}}', $value, $message);
    }

    $config = config('settings')->mail_config;

    $emailLog = new EmailLog();
    $emailLog->user_id = $user->id;
    $emailLog->mail_sender = config('settings')->name;
    $emailLog->email_from = config('settings')->sitename.' '.config('settings')->email_from;
    $emailLog->email_to = $user->email;
    $emailLog->subject = $emailTemplate->subj;
    $emailLog->message = $message;
    $emailLog->save();


    if ($config->name == 'php') {
        sendPhpMail($user->email, $user->username,$emailTemplate->subj, $message, config('settings'));
    } else if ($config->name == 'smtp') {
        sendSmtpMail($config, $user->email, $user->username, $emailTemplate->subj, $message, config('settings'));
    } else if ($config->name == 'sendgrid') {
        sendSendGridMail($config, $user->email, $user->username, $emailTemplate->subj, $message, config('settings'));
    } else if ($config->name == 'mailjet') {
        sendMailjetMail($config, $user->email, $user->username, $emailTemplate->subj, $message, config('settings'));
    }
}


function sendPhpMail($email, $name, $subject, $message,$general,$contact = false)
{
    if ($contact) {
        $headers = "From: $name <$email> \r\n";
        $headers .= "Reply-To: $name <$email> \r\n";
        $email = $general->email_from;
    }else{
        $headers = "From: $general->sitename <$general->email_from> \r\n";
        $headers .= "Reply-To: $general->sitename <$general->email_from> \r\n";
    }
    $headers .= "MIME-Version: 1.0\r\n";
    $headers .= "Content-Type: text/html; charset=utf-8\r\n";
    @mail($email, $subject, $message, $headers);
}


function sendSmtpMail($config, $receiver_email, $receiver_name, $subject, $message,$general,$contact = false)
{
    $mail = new PHPMailer(true);

    try {
        //Server settings
        $mail->isSMTP();
        $mail->Host       = $config->host;
        $mail->SMTPAuth   = true;
        $mail->Username   = $config->username;
        $mail->Password   = $config->password;
        if ($config->enc == 'ssl') {
            $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS;
        }else{
            $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
        }
        $mail->Port       = $config->port;
        $mail->CharSet = 'UTF-8';
        //Recipients
        if ($contact) {
            $mail->setFrom($receiver_email, $receiver_name);
            $mail->addAddress($general->email_from, $general->sitename);
            $mail->addReplyTo($receiver_email, $receiver_name);
        }else{
            $mail->setFrom($general->email_from, $general->sitename);
            $mail->addAddress($receiver_email, $receiver_name);
            $mail->addReplyTo($general->email_from, $general->sitename);
        }
        // Content
        $mail->isHTML(true);
        $mail->Subject = $subject;
        $mail->Body    = $message;
        $mail->send();
    } catch (Exception $e) {
        throw new Exception($e);
    }
}


function sendSendGridMail($config, $receiver_email, $receiver_name, $subject, $message,$general,$contact = false)
{
    $sendgridMail = new \SendGrid\Mail\Mail();
    if ($contact) {
        $sendgridMail->setFrom($receiver_email, $receiver_name);
        $sendgridMail->setSubject($subject);
        $sendgridMail->addTo($general->email_from, $general->sitename);
    }else{
        $sendgridMail->setFrom($general->email_from, $general->sitename);
        $sendgridMail->setSubject($subject);
        $sendgridMail->addTo($receiver_email, $receiver_name);
    }

    $sendgridMail->addContent("text/html", $message);
    $sendgrid = new \SendGrid($config->appkey);
    try {
        $response = $sendgrid->send($sendgridMail);
    } catch (Exception $e) {
        throw new Exception($e);
    }
}


function sendMailjetMail($config, $receiver_email, $receiver_name, $subject, $message,$general,$contact = false)
{
    $mj = new \Mailjet\Client($config->public_key, $config->secret_key, true, ['version' => 'v3.1']);
    if ($contact) {
        $fromMail = $receiver_email;
        $fromName = $receiver_name;
        $toMail = $general->email_from;
        $toName = $general->sitename;
    }else{
        $toMail = $receiver_email;
        $toName = $receiver_name;
        $fromMail = $general->email_from;
        $fromName = $general->sitename;
    }
    $body = [
        'Messages' => [
            [
                'From' => [
                    'Email' => $fromMail,
                    'Name' => $fromName,
                ],
                'To' => [
                    [
                        'Email' => $toMail,
                        'Name' => $toName,
                    ]
                ],
                'Subject' => $subject,
                'TextPart' => "",
                'HTMLPart' => $message,
            ]
        ]
    ];
    $response = $mj->post(\Mailjet\Resources::$Email, ['body' => $body]);
}


function getPaginate($paginate = 100)
{
    return $paginate;
}

function paginateLinks($data, $design = 'admin.partials.paginate'){
    return $data->appends(request()->all())->links($design);
}


function menuActive($routeName, $type = null)
{
    if ($type == 3) {
        $class = '';
    } elseif ($type == 2) {
        $class = '';
    } else {
        $class = 'active';
    }
    if (is_array($routeName)) {
        foreach ($routeName as $key => $value) {
            if (request()->routeIs($value)) {
                return $class;
            }
        }
    } elseif (request()->routeIs($routeName)) {
        return $class;
    }
}


function imagePath()
{
    $data['gateway'] = [
        'path' => 'assets/images/gateway',
        'size' => '800x800',
    ];
    $data['verify'] = [
        'withdraw'=>[
            'path'=>'assets/images/verify/withdraw'
        ],
        'deposit'=>[
            'path'=>'assets/images/verify/deposit'
        ]
    ];
    $data['image'] = [
        'default' => 'assets/images/default.png',
    ];
    $data['withdraw'] = [
        'method' => [
            'path' => 'assets/images/withdraw/method',
            'size' => '800x800',
        ]
    ];
    $data['ticket'] = [
        'path' => 'assets/support',
    ];
    $data['language'] = [
        'path' => 'assets/images/lang',
        'size' => '64x64'
    ];
    $data['logoIcon'] = [
        'path' => 'assets/images/logoIcon',
    ];
    $data['favicon'] = [
        'size' => '128x128',
    ];
    $data['extensions'] = [
        'path' => 'assets/images/extensions',
        'size' => '36x36',
    ];
    $data['seo'] = [
        'path' => 'assets/images/seo',
        'size' => '600x315'
    ];
    $data['products'] = [
        'link' => 'images/products/',
        'path' => 'assets/images/products',
        'size' => '600x450'
    ];
    $data['profile'] = [
        'user'=> [
            'path'=>'assets/images/user/profile',
            'size'=>'350x300'
        ],
        'admin'=> [
            'path'=>'assets/admin/images/profile',
            'size'=>'400x400'
        ]
    ];
    return $data;
}

function diffForHumans($date)
{
    $lang = session()->get('lang');
    Carbon::setlocale($lang);
    return Carbon::parse($date)->diffForHumans();
}

function showDateTime($date, $format = 'Y-m-d h:i A')
{
    $lang = session()->get('lang');
    Carbon::setlocale($lang);
    return Carbon::parse($date)->translatedFormat($format);
}

function diffDatePercent($start , $end, $cent = 1)
{
    $start = strtotime($start);
    $end = strtotime($end);


    $diff = $end - $start;

    $current = time();
    $cdiff = $current - $start;

    if ($cdiff > $diff) {
        $percentage = 1.0;
    }
    else if ($current < $start) {
        $percentage = 0.0;
    }
    else {
        $percentage = $cdiff / $diff;
    }

    return $cent ? sprintf('%.2f%%', $percentage * 100) : ($percentage * 100);
}

//moveable
function sendGeneralEmail($email, $subject, $message, $receiver_name = '')
{

    $general = GeneralSetting::first();


    if (config('settings')->en != 1 || !config('settings')->email_from) {
        return;
    }

    $message = shortCodeReplacer("{{message}}", $message, config('settings')->email_template);
    $message = shortCodeReplacer("{{fullname}}", $receiver_name, $message);
    $message = shortCodeReplacer("{{username}}", $email, $message);

    $config = config('settings')->mail_config;

    if ($config->name == 'php') {
        sendPhpMail($email, $receiver_name, $subject, $message, config('settings'));
    } else if ($config->name == 'smtp') {
        sendSmtpMail($config, $email, $receiver_name, $subject, $message, config('settings'));
    } else if ($config->name == 'sendgrid') {
        sendSendGridMail($config, $email, $receiver_name,$subject, $message, config('settings'));
    } else if ($config->name == 'mailjet') {
        sendMailjetMail($config, $email, $receiver_name,$subject, $message, config('settings'));
    }
}

function sendContactEmail($email, $subject, $message, $receiver_name = '')
{

    if (config('settings')->en != 1 || !config('settings')->email_from) {
        return;
    }
    $admin = App\Models\Admin::first();
    $message = shortCodeReplacer("{{message}}", $message, config('settings')->email_template);
    $message = shortCodeReplacer("{{fullname}}", '', $message);
    $message = shortCodeReplacer("{{username}}", $admin->name, $message);

    $config = config('settings')->mail_config;

    if ($config->name == 'php') {
        sendPhpMail($email, $receiver_name, $subject, $message, config('settings'),true);
    } else if ($config->name == 'smtp') {
        sendSmtpMail($config, $email, $receiver_name, $subject, $message, config('settings'),true);
    } else if ($config->name == 'sendgrid') {
        sendSendGridMail($config, $email, $receiver_name,$subject, $message,config('settings'),true);
    } else if ($config->name == 'mailjet') {
        sendMailjetMail($config, $email, $receiver_name,$subject, $message, config('settings'),true);
    }
}


function getContent($platform, $data_keys, $singleQuery = false, $limit = null,$orderById = false, $rand = false )
{
    if ($singleQuery) {
		$content = Frontend::where('data_keys', $data_keys)->where('platform', $platform)->latest()->first();
	}elseif( $rand ){
		if( $limit != null && is_numeric($limit) ){
			$content = Frontend::where('data_keys', $data_keys)->where('platform', $platform)->orderByRaw('RAND()')->take($limit)->get();
		}else{
			$content = Frontend::where('data_keys', $data_keys)->where('platform', $platform)->orderByRaw('RAND()')->take(1)->first();
		}
    } else {
        $article = Frontend::query();
        $article->when($limit != null, function ($q) use ($limit) {
            return $q->limit($limit);
        });
        if($orderById){
			$content = $article->where('data_keys', $data_keys)->where('platform', $platform)->orderBy('id')->get();
		}else{
			$content = $article->where('data_keys', $data_keys)->where('platform', $platform)->latest()->get();
		}
    }
    return $content;
}


function gatewayRedirectUrl($type = false){
    if ($type) {
        return 'user.transaction.history';
    }else{
        return 'user.deposit';
    }
}

function verifyG2fa($user,$code,$secret = null)
{
    $ga = new GoogleAuthenticator();
    if (!$secret) {
        $secret = $user->tsc;
    }
    $oneCode = $ga->getCode($secret);
    $userCode = $code;
    if ($oneCode == $userCode) {
        $user->tv = 1;
        $user->save();
        return true;
    } else {
        return false;
    }
}


function urlPath($routeName,$routeParam=null){
    if($routeParam == null){
        $url = route($routeName);
    } else {
        $url = route($routeName,$routeParam);
    }
    $basePath = route('home');
    $path = str_replace($basePath,'',$url);
    return $path;
}


function referralComission($user, $currency, $base_amount, $earnWallet)
{

    try {
        
        $refer = User::find($user->ref_by);

        $creditBonus = null;

        // User not found
        if(!$refer) throw new \Exception("Refer user not found");

        //level 1

        $team1 = Team::find(1);
		if( $team1 ){
			$descr = "First gen referral bonus from ".substr_replace($user->username, str_repeat("*", 3), 3, 3);
			$amount = ($team1->percent/100) * $base_amount;
			$refer->referral = $refer->referral + $amount;
			$refer->save();
			$creditBonus = give_bonus($refer->id, 0, $currency, $amount, $descr, $earnWallet, 1);
		}

        $refer2 = User::find($refer->ref_by);
        if($refer2){
            //level 2
            $team2 = Team::find(2);
			if( $team2 ){
				$descr = "Second gen referral bonus from ". substr_replace($user->username, str_repeat("*", 3), 3, 3);
				$amount = ($team2->percent/100) * $base_amount;
				$refer2->referral = $refer2->referral + $amount;
				$refer2->save();
				$creditBonus = give_bonus($refer2->id, 0, $currency, $amount, $descr, $earnWallet, 2);
			}

            $refer3 = User::find($refer2->ref_by);
            if($refer3){
                //level 3
                $team3 = Team::find(3);
				if( $team3 ){
					$descr = "Third gen referral bonus from ".substr_replace($user->username, str_repeat("*", 3), 3, 3);
					$amount = ($team3->percent/100) * $base_amount;
					$refer3->referral = $refer3->referral + $amount;
					$refer3->save();
					$creditBonus = give_bonus($refer3->id, 0, $currency, $amount, $descr, $earnWallet, 3);
				}
            }
        }

        // Exception
        if($creditBonus instanceof \Exception) throw new \Exception($creditBonus->getMessage());
        

        // Return Transaction
        return $creditBonus;

    } catch (\Exception $th) {
        return $th;
    }
}


function teamRebate($user, $currency, $base_amount, $earnWallet)
{

    try {
        
        $refer = User::find($user->ref_by);

        $creditBonus = null;

        // User not found
        if(!$refer) throw new \Exception("User has no team");
		
		$canEarn = ($refer->invested >= $base_amount)?1:0;
		
        //level 1
        $team1 = Team::find(4);
		if( $team1 && $canEarn){
			$descr = "First level team rebate bonus from ".substr_replace($user->username, str_repeat("*", 3), 3, 3);
			$amount = ($team1->percent/100) * $base_amount;
			$refer->referral = $refer->referral + $amount;
			$refer->save();
			$creditBonus = give_bonus($refer->id, 0, $currency, $amount, $descr, $earnWallet, 1);
		}
		
		if( $team1 && $canEarn == 0 ){
			$notice = new Notification();
			$notice->user_id = $refer->id;
			$notice->title = 'You just missed rebate commission from <b>' . $user->username . '</b> for being in lower package';
			$notice->save();
		}

        $refer2 = User::find($refer->ref_by);
        if($refer2){
            //level 2
			$canEarn = ($refer2->invested >= $base_amount)?1:0;
			
            $team2 = Team::find(5);
			if( $team2 && $canEarn ){
				$descr = "Second level team rebate bonus from ". substr_replace($user->username, str_repeat("*", 3), 3, 3);
				$amount = ($team2->percent/100) * $base_amount;
				$refer2->referral = $refer2->referral + $amount;
				$refer2->save();
				$creditBonus = give_bonus($refer2->id, 0, $currency, $amount, $descr, $earnWallet, 2);
			}
			
			if( $team2 && $canEarn == 0 ){
				$notice = new Notification();
				$notice->user_id = $refer2->id;
				$notice->title = 'You just missed second level rebate commission from <b>' . $user->username . '</b> for being in lower package';
				$notice->save();
			}


            $refer3 = User::find($refer2->ref_by);
            if($refer3){
                //level 3
				$canEarn = ($refer3->invested >= $base_amount)?1:0;
                $team3 = Team::find(6);
				if( $team3 && $canEarn ){
					$descr = "Third level team rebate bonus from ".substr_replace($user->username, str_repeat("*", 3), 3, 3);
					$amount = ($team3->percent/100) * $base_amount;
					$refer3->referral = $refer3->referral + $amount;
					$refer3->save();
					$creditBonus = give_bonus($refer3->id, 0, $currency, $amount, $descr, $earnWallet, 3);
				}
				
				if( $team2 && $canEarn == 0 ){
					$notice = new Notification();
					$notice->user_id = $refer3->id;
					$notice->title = 'You just missed third level rebate commission from <b>' . $user->username . '</b> for being in lower package';
					$notice->save();
				}
				
            }
        }

        // Exception
        if($creditBonus instanceof \Exception) throw new \Exception($creditBonus->getMessage());

        // Return Transaction
        return $creditBonus;

    } catch (\Exception $th) {
		// $th->getMessage();
        return $th;
    }
}


function give_bonus($user_id, $type, $currency, $amount, $descr, $to_main = 1, $ref_level = 1){
	$typeList = ['commission', 'income', 'bonus','others'];
	$wNGType = ['referral_wallet','balance', 'income', 'bonus_balance'];
	$wUSType = ['referral_wallet','usdt_balance', 'usdt_income', 'bonus_balance'];
	
    try {

        $user = User::find($user_id);

        // User not found
        if(!$user) throw new \Exception("User not found");

        // NGN Currency
        if($currency == 'NGN') {
			$wallet = $wNGType[$to_main];

			$user->$wallet += $amount;
			$post_balance = $user->$wallet;
        }

        // USDT Currency
        if($currency == 'USDT') {
			$wallet = $wUSType[$to_main];

			$user->$wallet += $amount;
			$post_balance = $user->$wallet;
        }

        $user->save();

        $transaction = new Transaction();
        $transaction->user_id = $user_id;
        $transaction->currency = $currency;
        $transaction->amount = $amount;
        $transaction->post_balance = $post_balance;
        
        $transaction->charge = 0;
        $transaction->type = $typeList[$type];
        $transaction->trx_type = '+';
        $transaction->ref_level = $ref_level;
        $transaction->details = $descr;
        $transaction->trx = getTrx();
        $transaction->status = 1;
        $transaction->save();

        // Return Transaction
        return $transaction;

    } catch (\Exception $th) {
        //throw $th;
        return $th;
    }
}


function send_to_telegram($message){

    if(!config('settings')->enable_telegram){
        return;
    }

    $apiToken = config('settings')->telegram_api_token;// "5595553724:AAEuxr1MMjZgJJh-ymZ62pTCbaXIHwm9bXY";//telegram_chat_id

    $chat_ids = explode(",", config('settings')->telegram_chat_id);
    $response = [];

    foreach ($chat_ids as $chat_id) {
        $data = [
            'chat_id' => $chat_id,
            'text' => $message
        ];

        $response[] = url_get_contents("https://api.telegram.org/bot$apiToken/sendMessage?" . http_build_query($data));
    }
    return $response;
}


function url_get_contents ($Url) {
    if (!function_exists('curl_init')){
        die('CURL is not installed!');
    }
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $Url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $output = curl_exec($ch);
    curl_close($ch);
    return $output;
}


function get_bank_name($code){
    $bank = \App\Models\Bank::where('bank_code', $code)->first();
    if($bank){
        return $bank->name;
    }else{
        return '';
    }
}


function getAllBanks(){


    $curl = curl_init();

    curl_setopt_array($curl, array(
        CURLOPT_URL => "https://api.flutterwave.com/v3/banks/NG",
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => "",
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => "GET",
        CURLOPT_HTTPHEADER => array(
            "Authorization: Bearer FLWSECK-627e895325a0cf4a40f4b057e988ff04-X"
        ),
    ));

    $response = curl_exec($curl);

    curl_close($curl);
//echo $response;

    $response_array = json_decode($response,1);

    return $response_array;

}


if(!function_exists('get_account_info')){

    function get_account_info($account_no, $bank_code, $verify = false){
        //curl_setopt($ch, CURLOPT_POSTFIELDS, $params);
        $params = http_build_query([
            "account_number" => $account_no,
            'account_bank' => $bank_code,
            "country" => "NG"
        ]);
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => "https://api.flutterwave.com/v3/accounts/resolve",
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POSTFIELDS => $params,
            CURLOPT_HTTPHEADER => array(
                "Authorization: Bearer FLWSECK-5bac9180a18493a83b7089510fff1bd3-X"
            ),
        ));
        /*$curl = curl_init();
        curl_setopt_array($curl, array(
        CURLOPT_URL => "https://api.paystack.co/bank/resolve?account_number=$account_no&bank_code=$bank_code",
        CURLOPT_SSL_VERIFYPEER => false,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'GET',
        CURLOPT_HTTPHEADER => array(
            'Authorization: Bearer sk_live_93ef79485ea1d115612b24707a68947369997d19'
        ),
        ));*/

        $response = curl_exec($curl);
        $err = curl_error($curl);

        if ($err) {
            // there was an error contacting the Paystack API
            return;
        }

        $response_array = json_decode($response,true);

        if($verify == true){
            return $response_array['status'];
        }

        return $response_array;
    }
}


function Split_Hide_Name($name) {
    return preg_replace("/(?!^).(?!$)/", "*", $name);
}


function plan_color($id){
    if($id == 1){
        return "orange";
    }elseif ($id == 2){
        return "teal";
    }else{
        return "#161445";
    }
}



function showUserLevel($id, $level)
{

    $myref = showBelow($id);
    $nxt = $myref;
    for ($i = 1; $i < $level; $i++) {
        $nxt = array();
        foreach ($myref as $uu) {
            $n = showBelow($uu);
            $nxt = array_merge($nxt, $n);
        }
        $myref = $nxt;
    }
    foreach ($nxt as $key => $uu) {
        $key += 1;

        $data = \App\Models\User::where('id', $uu)->with('investments')->first();

        $links = '<tr><td>'.$data->username.'</td><td>'.$data->investments->count().'</td><td>'.$data->investments->sum('amount').'</td></tr>';

        echo $links;


        echo $links;
    }
}


function showBelow($id)
{
    $arr = array();
    $under_ref = \App\Models\User::where('ref_by', $id)->get();
    foreach ($under_ref as $u) {
        array_push($arr, $u->id);
    }
    return $arr;
}

function currency($currency)
{
    $currency = \App\Models\Currency::where('cur_text', $currency)->first();
    
    return $currency;
}

function getNextDayWithTime($time = 0, $min = 2)
{
    // Get the current date and time
    $currentDateTime = Carbon::now();

    // Set the time to 23:59:59 to get the end of the day
    $endOfDay = $currentDateTime->endOfDay();

    // Add 2 minutes to get the next day with the time of 00:01
    $nextDay = $endOfDay->addHours($time);
    $nextDay = $endOfDay->addMinutes($min);

    return $nextDay;
}

function salutation(){
	$Hour = date('G');
	if ( $Hour >= 4 && $Hour <= 8 ) {
		$g = "Good morning, wash your hands 🌤";
	} else if ( $Hour >= 9 && $Hour <= 11 ) {
		$g = "How is work going with you.";
	} else if ( $Hour >= 12 && $Hour <= 15 ) {
		$g = "Afternoon exteem user, greetings.";
	} else if ( $Hour >= 16 && $Hour <= 17 ) {
		$g = "Hello, keep safe, wash hands 👋🏼.";
	} else if ( $Hour >= 18 && $Hour <= 19 ) {
		$g = "Nice to see you. How was your day?";
	} else if ( $Hour >= 20 || $Hour < 4 ) {
		$g = "You should be in bed 🙄!";
	}
	return $g;
}

function greetings(){
	$Hour = date('G');
	if ( $Hour >= 4 && $Hour <= 8 ) {
		$g = "🌤 Morning ";
	} else if ( $Hour >= 9 && $Hour <= 11 ) {
		$g = "How is work going. ";
	} else if ( $Hour >= 12 && $Hour <= 15 ) {
		$g = "Greetings. ";
	} else if ( $Hour >= 16 && $Hour <= 17 ) {
		$g = "Hello, keep safe, ";
	} else if ( $Hour >= 18 && $Hour <= 19 ) {
		$g = "Nice to see you. ";
	} else if ( $Hour >= 20 || $Hour < 4 ) {
		$g = "🙄! How was your day? ";
	}
	return $g;
}

/*
 * Outputs a color (#000000) based Text input
 *
 * @param $text String of text
 * @param $min_brightness Integer between 0 and 100
 * @param $spec Integer between 2-10, determines how unique each color will be
 */

function getTextColor($text, $min_brightness=100, $spec=10)
{
	// Check inputs
	if(!is_int($min_brightness)) throw new Exception("$min_brightness is not an integer");
	if(!is_int($spec)) throw new Exception("$spec is not an integer");
	if($spec < 2 or $spec > 10) throw new Exception("$spec is out of range");
	if($min_brightness < 0 or $min_brightness > 255) throw new Exception("$min_brightness is out of range");
	
	
	$hash = md5($text);  //Gen hash of text
	$colors = array();
	for($i=0;$i<3;$i++)
		$colors[$i] = max(array(round(((hexdec(substr($hash,$spec*$i,$spec)))/hexdec(str_pad('',$spec,'F')))*255),$min_brightness)); //convert hash into 3 decimal values between 0 and 255
		
	if($min_brightness > 0)  //only check brightness requirements if min_brightness is about 100
		while( array_sum($colors)/3 < $min_brightness )  //loop until brightness is above or equal to min_brightness
			for($i=0;$i<3;$i++)
				$colors[$i] += 10;	//increase each color by 10
				
	$output = '';
	
	for($i=0;$i<3;$i++)
		$output .= str_pad(dechex($colors[$i]),2,0,STR_PAD_LEFT);  //convert each color to hex and append to output
	
	return '#'.$output;
}