<?php
namespace App\Http\Services;

use App\Models\Gateway;
use App\Models\GeneralSetting;
use Illuminate\Support\Facades\URL;

/**
 * Laravel/Symfony Developer
 * Name: Muongozo
 * Telegram: @muongozotrader
 * Hire me via Telegram: muongozotrader
 */
class AuthenticationServices
{
    private $setting;
    public function __construct()
    {
        $this->setting = GeneralSetting::first();
    }

    /**
     * @param string number
     */
    function sendWhatsappOtp(
        string $number
    ){
        try {

            // Request Body
            $requestBody = '{
                "callback_url": "'.URL::route('ipn.default').'",
                "redirect_url": "'.URL::route('payment.redirect').'"
            }';

            // Send Request
            $payment = $this->curlRequest('POST', 'charge', $requestBody);

            // Exception
            if($payment instanceof \Exception) throw new \Exception($payment->getMessage());

            // Response
            return array('status' => true, 'data' => $payment['data'], 'message' => 'Successful');
        } catch (\Exception $th) {
            //throw $th;
            return array('status' => false, 'message' => $th->getMessage());
        }
    }

    function curlRequest(
        string $method,
        string $endpoint,
        string $body = null
    ){

        try {

            // Find Setting
            $setting = Gateway::where(['code' => '117', 'status' => 1])->first();

            // Exception
            if(!$setting) throw new \Exception("Payout not enabled at the moment");

            // Parse setting
            $setting = json_decode($setting->gateway_parameters);

            // Curl Request
            $curl = curl_init();
            curl_setopt_array($curl, array(
            CURLOPT_URL => $endpoint,
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => $method,
            CURLOPT_POSTFIELDS => $body,
            CURLOPT_HTTPHEADER => array(
                'Authorization: '.$setting->secret_key->value,
                'Content-Type: application/json'
            ),
            ));
    
            $response = curl_exec($curl);
            $err = curl_error($curl);
            $httpcode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
    
            // there was an error contacting
            if ($err) throw new \Exception('Curl returned error: ' . $err);

            // Convert Json to Json Array
            $response_array = json_decode($response,true);
            
            // Check status
            if(!in_array($httpcode, ['200'])) throw new \Exception($response_array['message']);
    
            return $response_array;

        } catch (\Exception $th) {
            //throw $th;
            return $th;
        }
    }

}
