<?php
namespace App\Http\Services;

use App\Models\Coupon;
use App\Models\Plan;
use App\Models\User;
use Carbon\Carbon;

/**
 * Laravel/Symfony Developer
 * Name: Muongozo
 * Telegram: @muongozotrader
 * Hire me via Telegram: muongozotrader
 */
class CouponService
{
    /**
     * Use Coupon
     */
    public function verifyCoupon(
        User $user,
        string $type,
        string $code,
        string $amount,
        string $package_id = null
    )
    {
        try {
            
            // Find active Coupon
            $coupon = Coupon::where(['type' => $type, 'code' => $code, 'started' => 1, 'status' => 1])->where('expired_date', '>', Carbon::now())->first();
            
            // Verify Coupon
            if(!$coupon) throw new \Exception("Coupon not available");

            // Validation
            $validate = self::validateCoupon($coupon, $user, $package_id); 

            // Exception
            if($validate instanceof \Exception) throw new \Exception($validate->getMessage());
            

            $discount = $amount * $coupon->discount / 100;

            $data = [
                'amount' => $amount,
                'discount' => $discount,
                'discount_rate' => $coupon->discount,
                'charge' => getAmount($amount - $discount)
            ];

            // Return Data
            return $data;
            
        } catch (\Exception $th) {
            //throw $th;
            return $th;
        }
    }

    /**
     * Self Validate Coupon
     */
    public static function validateCoupon(
        Coupon $coupon,
        User $user,
        string $package_id = null
    )
    {
        try {
            
            // Validate user if not public
            if($coupon->public != 1) {
                // Verify User
                if($coupon->user != $user) throw new \Exception("Coupon not available");
            }

            // Validate if for package
            if($coupon->for_package) {
                // Find Package
                $package = Plan::find($package_id);

                // Verify package
                if(empty($package)) throw new \Exception("Coupon not available for your Order");

                // Match Package
                if($package != $coupon->package) throw new \Exception("Coupon not available for your Order");
            }

            // Return Data
            return $coupon;
            
        } catch (\Exception $th) {
            //throw $th;
            return $th;
        }
    }
}
