<?php
namespace App\Http\Services\Deposit\Bank;

use App\Http\Services\Deposit\Bank\ManualBankDepositServices;
use App\Http\Services\Deposit\Bank\ShpayBankDepositServices;
use App\Http\Services\Deposit\Bank\PpayBankDepositServices;

class ProcessBankDepositServices
{
    private $manual;
    private $shpay;
    private $gtr;
    private $ppay;
    private $otpay;
    private $wkpay;

    public function __construct(
        ManualBankDepositServices $manual,
        ShpayBankDepositServices $shpay,
        GTRBankDepositServices $gtr,
        PpayBankDepositServices $ppay,
        OTPayBankDepositServices $otpay,
        WKPayBankDepositServices $wkpay
    )
    {
        $this->manual = $manual;
        $this->shpay = $shpay;
        $this->gtr = $gtr;
        $this->ppay = $ppay;
        $this->otpay = $otpay;
        $this->wkpay = $wkpay;
    }

    /**
     * Deposit Payment
     *
     * @param string reference
     * @param string currency
     * @param string amount
     * @param string method
     */
    public function deposit(
        string $reference,
        string $currency,
        string $amount,
        string $method
    )
    {
        try {

            if(config('settings')->auto_deposit) {

                // Verify transfer Type
                if(!in_array($method, config('gateway.payment'))) throw new \Exception("Deposit not available at the moment");

                // Shpay
                if(in_array($method, ['shpay'])) {
                    $payment = $this->shpay->deposit($reference, $currency, $amount, $method);
                }

                // GTR
                if(in_array($method, ['gtr'])) {
                    $payment = $this->gtr->deposit($reference, $currency, $amount, $method);
                }

                // PPAY
                if(in_array($method, ['ppay'])) {
                    $payment = $this->ppay->deposit($reference, $currency, $amount, $method);
                }

                // OTPAY
                if(in_array($method, ['otpay'])) {
                    $payment = $this->otpay->deposit($reference, $currency, $amount, $method);
                }

                // WKPAY
                if(in_array($method, ['wkpay'])) {
                    $payment = $this->wkpay->deposit($reference, $currency, $amount, $method);
                }

            }else {
                // Manual
                $payment = $this->manual->deposit($reference, $currency, $amount, $method);
            }

            // Exception
            if($payment instanceof \Exception) throw new \Exception($payment->getMessage());

            // Response
            return $payment;

        } catch (\Exception $th) {
            //throw $th;
            return $th;
        }
    }

    /**
     * Verify Payment
     *
     * @param string reference
     * @param string method
     */
    public function verify(
        string $reference,
        string $method,
        string $orderID
    )
    {
        try {

			// Verify transfer Type
			if(!in_array($method, config('gateway.payment'))) throw new \Exception("Verification not available at the moment");

			// Shpay
			if(in_array($method, ['shpay'])) {
				$payment = $this->shpay->verify($reference, $method);
			}

			// GTR
			if(in_array($method, ['gtr'])) {
				$payment = $this->gtr->verify($reference, $method);
			}

			// PPAY
			if(in_array($method, ['ppay'])) {
				$payment = $this->ppay->verify($reference, $method, $orderID);
			}

			// OTPAY
			if(in_array($method, ['otpay'])) {
				$payment = $this->otpay->verify($reference, $method, $orderID);
			}

            // Exception
            if($payment instanceof \Exception) throw new \Exception($payment->getMessage());

            // Response
            return $payment;

        } catch (\Exception $th) {
            return $th;
        }
    }


    /**
     * Get Account Balance
     *
     * @param Void
     */
    public function balance(string $method)
    {
        try {

			// Verify transfer Type
			if(!in_array($method, config('gateway.payment'))) throw new \Exception("Verification not available at the moment");

			// Shpay
			if(in_array($method, ['shpay'])) {
				$payment = $this->shpay->balance();
			}

			// GTR
			if(in_array($method, ['gtr'])) {
				$payment = $this->gtr->balance();
			}

			// PPAY
			if(in_array($method, ['ppay'])) {
				$payment = $this->ppay->balance();
			}

			// OTPAY
			if(in_array($method, ['otpay'])) {
				$payment = $this->otpay->balance();
			}

            // Exception
            if($payment instanceof \Exception) throw new \Exception($payment->getMessage());

            // Response
            return $payment;

        } catch (\Exception $th) {
            return $th;
        }
    }


}
