<?php
namespace App\Http\Services;

use App\Models\Coupon;
use App\Models\GeneralSetting;
use App\Models\Gift;
use App\Models\Plan;
use App\Models\Reward;
use App\Models\Transaction;
use App\Models\User;
use Carbon\Carbon;

/**
 * Laravel/Symfony Developer
 * Name: Muongozo
 * Telegram: @muongozotrader
 * Hire me via Telegram: muongozotrader
 */
class GiftService
{
    private $setting;
    private $wallet;

    public function __construct(
        WalletServices $wallet
    )
    {
        $this->setting = GeneralSetting::first();
        $this->wallet = $wallet;
    }

    /**
     * Redeem
     */
    public function redeem(
        User $user,
        string $code
    )
    {
        try {
            
            // Find active Gift
            $gift = Gift::where(['user_id' => $user->id, 'code' => $code, 'status' => 1])->where('expired_date', '>', Carbon::now())->first();

            // Verify Gift
            if(!$gift) throw new \Exception("Gift not available");

            // Inactive Gift
            $gift->status = 0;
            $gift->save();

            // Add Transaction records
            $transaction = new Transaction();
            $transaction->user_id = $user->id;
            $transaction->type =  'redeem';
            $transaction->amount = $gift->amount;
            $transaction->post_balance = $user->balance;
            $transaction->charge = '0';
            $transaction->currency = $gift->currency;
            $transaction->trx_type = '+';
            $transaction->details = 'Gift Redeem '.$code;
            $transaction->trx =  getTrx();
            $transaction->status =  1;
            $transaction->save();

            // Credit Wallet
			//$this->wallet->creditBalance($user, $gift->currency, $gift->amount);
            $this->wallet->creditIncome($user, $gift->currency, $gift->amount);

            // Return Transaction
            return $transaction;
            
        } catch (\Exception $th) {
            //throw $th;
            return $th;
        }
    }
}
