<?php
namespace App\Http\Services\Payout\Bank;

use App\Http\Services\Payout\Bank\Util\ResponseBankUtilPayoutServices;
use App\Models\Bank;
use App\Models\Gateway;
use Illuminate\Support\Facades\URL;

/**
 * Laravel/Symfony Developer
 * Name: Muongozo
 * Telegram: @muongozotrader
 * Hire me via Telegram: muongozotrader
 */
class FlutterBankPayoutServices
{
    
    /**
     * Transfer Payment
     * 
     * @param string reference
     * @param string currency
     * @param string amount
     * @param string method
     * @param string bank code
     * @param string bank name
     * @param string account number
     * @param string account name
     * @param string narration
     */
    public function transfer(
        string $reference,
        string $currency,
        string $amount,
        string $method,
        string $bank_code,
        string $bank_name = null,
        string $account_number,
        string $account_name,
        string $narration = 'Goods'
    )
    {
        try {

            // Get Support Code
            $bank_list = Bank::where(['bank_code' => $bank_code, 'status' => 1])->first();

            // Exception
            if(!$bank_list) throw new \Exception('Bank Name not available. Please update your bank info again');

			$requestBody = array(
				"account_bank"		=> $bank_list->bank_code,
				"account_number"	=> $account_number,
				"amount"			=> $amount,
				"bank_name"			=> $bank_list->name,
				"narration"			=> config('settings')->sitename,
				"currency"			=> "NGN",
				"reference"			=> $reference,
				"callback_url"		=> URL::route('ipn.pay.flutterwave'),
				"debit_currency"	=> "NGN"
			);

            // Send Curl Request
            $sendRequest = $this->curlRequest('POST', 'transfers', $requestBody);

            // Exception
            if($sendRequest instanceof \Exception) throw new \Exception(@$sendRequest->getMessage());
			
            // Check if successful
            if ($sendRequest['status'] != 'success') throw new \Exception('Failed processing payment');

            // Format Response
            $response = ResponseBankUtilPayoutServices::response(200, 2, true, $reference, $sendRequest['data']['id'], $currency, $amount, $method, $bank_code, $bank_name, $account_number, $account_name, $narration);

            // Response
            return $response;

        } catch (\Exception $th) {
            //throw $th;
            return $th;
        }
    }

    /**
     * Cur Request
     * send request
     * 
     * @param string method
     * @param string endpoint
     * @param string body
     */
    public function curlRequest(
        string $method,
        string $endpoint,
        array $body = []
    ) {

        try {

            // Find Setting
            $setting = Gateway::where(['code' => '109'])->first();

            // Exception
            if(!$setting) throw new \Exception("Service not enabled at the moment");

            // Parse setting
            $setting = json_decode($setting->gateway_parameters);


            $secret_key = $setting->secret_key->value;

            // Convert request data to JSON
            $jsonData = json_encode($body);

            // Curl Request
            $curl = curl_init();
            curl_setopt_array($curl, array(
                CURLOPT_URL => 'https://api.flutterwave.com/v3/' . $endpoint,
                CURLOPT_SSL_VERIFYPEER => false,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 30,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => $method,
                CURLOPT_POSTFIELDS => $jsonData,
				CURLOPT_HTTPHEADER => array(
					"Authorization: Bearer $secret_key",
					"Content-Type: application/json"
				),
            ));

            $response = curl_exec($curl);
            $err = curl_error($curl);
            $httpcode = curl_getinfo($curl, CURLINFO_HTTP_CODE);

            // there was an error contacting
            if ($err) throw new \Exception('Curl returned error: ' . $err);

            // Convert Json to Json Array
            $response_array = json_decode($response, true);

            // Check status
            if (!in_array($httpcode, ['200'])) throw new \Exception($response_array['message']);

            // Check if successful
            if ($response_array['status'] != 'success') throw new \Exception($response_array['message']);

            return $response_array;
        } catch (\Exception $th) {
            //throw $th;
            return $th;
        }
    }

}
