<?php
namespace App\Http\Services\Payout\Bank;

use App\Http\Services\Payout\Bank\ShpayBankPayoutServices;
use App\Http\Services\Payout\Bank\PpayBankPayoutServices;

/**
 * Laravel/Symfony Developer
 * Name: Pynith Limited
 * Telegram: @pynith
 * Hire me via Telegram: pynith
 */
class ProcessBankPayoutServices
{
    private $manual;
    private $shpay;
    private $gtr;
    private $ppay;
    private $otpay;
    private $flutter;
    private $wkpay;

    public function __construct(
        ManualBankPayoutServices $manual,
        ShpayBankPayoutServices $shpay,
        GTRBankPayoutServices $gtr,
        PpayBankPayoutServices $ppay,
        OTPayBankPayoutServices $otpay,
        FlutterBankPayoutServices $flutter,
        WKPayBankPayoutServices $wkpay
    )
    {
        $this->manual = $manual;
        $this->shpay = $shpay;
        $this->gtr = $gtr;
        $this->ppay = $ppay;
        $this->otpay = $otpay;
        $this->flutter = $flutter;
        $this->wkpay = $wkpay;
    }

    /**
     * Transfer Payment
     *
     * @param string reference
     * @param string currency
     * @param string amount
     * @param string method
     * @param string bank code
     * @param string bank name
     * @param string account number
     * @param string account name
     * @param string narration
     */
    public function transfer(
        string $reference,
        string $currency,
        string $amount,
        string $method,
        string $bank_code,
        string $bank_name = null,
        string $account_number,
        string $account_name,
        string $narration = null
    )
    {
        try {

            // Verify transfer Type
            if(!in_array(config('settings')->auto_transfer_default, config('gateway.payment') )) throw new \Exception("Payout not available at the moment");

            // Shpay
            if(in_array(config('settings')->auto_transfer_default, ['shpay'])) {
                $payment = $this->shpay->transfer($reference, $currency, $amount, $method, $bank_code, $bank_name, $account_number, $account_name, $narration);
            }

            // GTR
            if(in_array(config('settings')->auto_transfer_default, ['gtr'])) {
                $payment = $this->gtr->transfer($reference, $currency, $amount, $method, $bank_code, $bank_name, $account_number, $account_name, $narration);
            }

            // PPAY
            if(in_array(config('settings')->auto_transfer_default, ['ppay'])) {
                $payment = $this->ppay->transfer($reference, $currency, $amount, $method, $bank_code, $bank_name, $account_number, $account_name, $narration);
            }

            // OTPAY
            if(in_array(config('settings')->auto_transfer_default, ['otpay'])) {
                $payment = $this->otpay->transfer($reference, $currency, $amount, $method, $bank_code, $bank_name, $account_number, $account_name, $narration);
            }

            // Flutterwave
            if(in_array(config('settings')->auto_transfer_default, ['flutter'])) {
                $payment = $this->flutter->transfer($reference, $currency, $amount, $method, $bank_code, $bank_name, $account_number, $account_name, $narration);
            }

            // WKPay
            if(in_array(config('settings')->auto_transfer_default, ['wkpay'])) {
                $payment = $this->wkpay->transfer($reference, $currency, $amount, $method, $bank_code, $bank_name, $account_number, $account_name, $narration);
            }

            // Exception
			if($payment instanceof \Exception) throw new \Exception($payment->getMessage());

            // Response
            return $payment;

        } catch (\Exception $th) {
            //throw $th;
            return $th;
        }
    }
}
