<?php
namespace App\Http\Services;

use Carbon\Carbon;
use App\Models\User;
use App\Models\Plan;
use App\Models\Reward;
use App\Models\RewardPlan;
use App\Models\Transaction;
use App\Models\GeneralSetting;

/**
 * Laravel/Symfony Developer
 * Name: Muongozo
 * Telegram: @muongozotrader
 * Hire me via Telegram: muongozotrader
 */
class RewardService
{
    private $setting;
    private $wallet;

    public function __construct(
        WalletServices $wallet
    )
    {
        $this->setting = GeneralSetting::first();
        $this->wallet = $wallet;
    }

    /**
     * Reward User
     */
    public function reward(
        User $user,
        RewardPlan $plan
    )
    {
        try {
            
            // Calculate amount
            $amount = $plan->amount * $plan->rate;

            // Expired Date
            $expiredDate = Carbon::now()->addHours($plan->interval);

            // Add Reward records
            $reward = new Reward();
            $reward->user_id = $user->id;
            $reward->plan_id = $plan->id;
            $reward->type = $plan->type;
            $reward->currency = $plan->currency;
            $reward->amount = $amount;
            $reward->rate = $plan->rate;
            $reward->summary = 'Starts earning from '.$plan->name;
            $reward->expired_date = $plan->expires;
            $reward->next_run = $expiredDate;
            $reward->identifier = getTrx();
            $reward->status = 1;
            $reward->save();

            // Return Reward
            return $reward;
            
        } catch (\Exception $th) {
            return $th;
        }
    }

    /**
     * Claim Reward
     */
    public function claimReward(
        User $user,
        string $identifier
    )
    {
        try {
            
            // Find active Reward
            $reward = Reward::where(['user_id' => $user->id, 'identifier' => $identifier, 'status' => 1])->first();
            //$reward = Reward::where(['user_id' => $user->id, 'identifier' => $identifier, 'status' => 1])->where('expired_date', '>', Carbon::now())->first();

            // Verify Reward
            if(!$reward) throw new \Exception("Reward request not available");

            // Check if not epired
            
            // Credit wallet
            $this->wallet->creditAvailableBalance($user, 2, $reward->currency, $reward->amount);

            // Inactive Reward
            $reward->status = 0;
            $reward->save();

            // Add Transaction records
            $transaction = new Transaction();
            $transaction->user_id = $user->id;
            $transaction->type =  'reward';
            $transaction->amount = $reward->amount;
            $transaction->post_balance = $user->balance;
            $transaction->charge = '0';
            $transaction->currency = $reward->currency;
            $transaction->trx_type = '+';
            $transaction->details = $reward->summary;
            $transaction->trx =  $reward->identifier;
            $transaction->status =  1;
            $transaction->save();


            // Return Reward
            return $reward;
            
        } catch (\Exception $th) {
            //throw $th;
            return $th;
        }
    }
}
