@extends('admin.layouts.app')

@section('panel')
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card b-radius--10">
                <div class="card-body p-0">
                    <div class="table-responsive--sm table-responsive">


                        <form action="{{ route('admin.deposit.approve-all') }}" method="post" onsubmit="return confirm('Are you sure you want to continue?')">
                            <table class="table table--light style--two">
                                <thead>
                                <tr>

                                    <th>@lang('Initiated')</th>
                                    <th>@lang('Order ID')</th>
                                    <th>@lang('User')</th>
                                    <th>@lang('Amount')</th>
                                    <th>@lang('Sender')</th>
                                    <th>@lang('Status')</th>
                                    <th>@lang('Action')</th>
                                </tr>
                                </thead>
                                <tbody>
                                @forelse($deposits as $deposit)
                                    @php
                                        $details = $deposit->detail ? json_encode($deposit->detail) : null;
                                    @endphp
                                    <tr>


                                        <td data-label="@lang('Date')">
                                            {{ showDateTime($deposit->created_at) }}

                                            <br>
                                            <label for="dep{{ $deposit->id }}">
                                                <input type="checkbox" name="ids[]" value="{{ $deposit->id }}"  id="dep{{ $deposit->id }}">
                                                Mark
                                            </label>
                                        </td>

                                        <td data-label="@lang('Date')">
                                            {{ $deposit->trx }}
                                        </td>

                                        <td data-label="@lang('User')">
                                            <span class="font-weight-bold">{{ $deposit->user->fullname }}</span>
                                            <br>
                                            <span class="small">
                                    <a href="{{ route('admin.users.detail', $deposit->user_id) }}"><span>@</span>{{ $deposit->user->username }}</a>
                                    </span>

                                            

                                        </td>
                                        <td data-label="@lang('Amount')">
                                            <strong data-toggle="tooltip" data-original-title="@lang('Amount with charge')">
                                                {{ showAmount($deposit->method_amount+$deposit->charge) }} {{ __($deposit->method_currency) }}
                                            </strong>
                                        </td>
                                        <td data-label="@lang('Conversion')">
                                            <strong>Naration</strong>
                                            <small> {{ $deposit->trx }} </small>

                                            @if($details != null && $deposit->try != 1)
                                                @foreach(json_decode($details) as $k => $val)
                                                    @if($deposit->method_code >= 1000)
                                                        @if($val->type == 'file')
                                                            <div class="row mt-4">
                                                                <div class="col-md-8">
                                                                    <h6>{{inputTitle($k)}}</h6>
                                                                    <img src="{{ asset('assets/images/verify/deposit/') }}/{{ $val->field_name }}" width="200" class="img-fluid img-reponsive">
                                                                </div>
                                                            </div>
                                                        @else
                                                            <div class="row mt-4">
                                                                <div class="col-md-12">
                                                                    <h6>{{inputTitle($k)}}</h6>
                                                                    <p>{{__($val->field_name)}}</p>
                                                                </div>
                                                            </div>
                                                        @endif
                                                    @endif
                                                @endforeach
                                            @endif
                                        </td>
                                        <td data-label="@lang('Status')">
                                            @if($deposit->status == 2)
                                                <span class="badge badge--warning">@lang('Pending')</span>
                                            @elseif($deposit->status == 1)
                                                <span class="badge badge--success">@lang('Approved')</span>
                                                <br>{{ diffForHumans($deposit->updated_at) }}
                                            @elseif($deposit->status == 3)
                                                <span class="badge badge--danger">@lang('Rejected')</span>
                                                <br>{{ diffForHumans($deposit->updated_at) }}
                                            @endif
                                        </td>
                                        <td data-label="@lang('Action')">




                                            <a href="{{ route('admin.deposit.details', $deposit->id) }}"
                                               class="icon-btn ml-1 " data-toggle="tooltip" title=""
                                               data-original-title="@lang('Detail')">
                                                <i class="la la-desktop"></i>
                                            </a><br/>
                                            <p>

                                            @if($deposit->status == 2)

                                                <form action="{{route('admin.deposit.approve')}}" method="POST"
                                                      class="form-inline" style="display: inline-block">
                                                    @csrf
                                                    <input type="hidden" name="id" value="{{ $deposit->id }}">

                                                    <button formaction="{{route('admin.deposit.approve')}}" type="submit" class="btn btn--success mt-2">@lang('Approve')</button>

                                                </form>

                                                <form action="{{ route('admin.deposit.reject')}}" method="POST"
                                                      onsubmit="return confirm('Are you sure?')" class="form-inline mt-2"
                                                      style="display: inline-block">
                                                    @csrf
                                                    <input type="hidden" name="id" value="{{ $deposit->id }}">


                                                    <button type="submit" formaction="{{ route('admin.deposit.reject')}}" class="btn btn--danger">@lang('Reject')</button>

                                                    <button type="submit" formaction="{{ route('admin.deposit.reject')}}" name="block" value="1"
                                                            class="btn btn--danger">@lang('Reject and Block')</button>
                                                </form>

                                            @endif
                                            </p>

                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%">{{ __($emptyMessage) }}</td>
                                    </tr>
                                @endforelse
                                </tbody>
                            </table><!-- table end -->


                            <button type="submit" class="btn btn-primary" formaction="{{ route('admin.deposit.approve-all') }}">Approve Marked</button>
                            <button type="submit" class="btn btn-warning" formaction="{{ route('admin.deposit.reject-all') }}">Reject Marked</button>
                            <button type="submit" class="btn btn-danger" formaction="{{ route('admin.deposit.block-all') }}">Reject and Block Marked</button>
                        </form>
                    </div>
                </div>
                <div class="card-footer py-4">
                    {{ paginateLinks($deposits) }}
                </div>
            </div><!-- card end -->
        </div>
    </div>


@endsection


@push('breadcrumb-plugins')
    @if(!request()->routeIs('admin.users.deposits') && !request()->routeIs('admin.users.deposits.method'))
        <form action="{{route('admin.deposit.search', $scope ?? str_replace('admin.deposit.', '', request()->route()->getName()))}}"
              method="GET" class="form-inline float-sm-right bg--white mb-2 ml-0 ml-xl-2 ml-lg-0">
            <div class="input-group has_append  ">
                <input type="text" name="search" class="form-control" placeholder="@lang('Trx number/Username')"
                       value="{{ $search ?? '' }}">
                <div class="input-group-append">
                    <button class="btn btn--primary" type="submit"><i class="fa fa-search"></i></button>
                </div>
            </div>
        </form>

        <form action="{{route('admin.deposit.dateSearch',$scope ?? str_replace('admin.deposit.', '', request()->route()->getName()))}}"
              method="GET" class="form-inline float-sm-right bg--white">
            <div class="input-group has_append ">
                <input name="date" type="text" data-range="true" data-multiple-dates-separator=" - " data-language="en"
                       class="datepicker-here form-control" data-position='bottom right'
                       placeholder="@lang('Min date - Max date')" autocomplete="off" value="{{ @$dateSearch }}">
                <input type="hidden" name="method" value="{{ @$methodAlias }}">
                <div class="input-group-append">
                    <button class="btn btn--primary" type="submit"><i class="fa fa-search"></i></button>
                </div>
            </div>
        </form>

    @endif
@endpush


@push('script-lib')
    <script src="{{ asset('assets/admin/js/vendor/datepicker.min.js') }}"></script>
    <script src="{{ asset('assets/admin/js/vendor/datepicker.en.js') }}"></script>
@endpush
@push('script')
    <script>
        (function ($) {
            "use strict";
            if (!$('.datepicker-here').val()) {
                $('.datepicker-here').datepicker();
            }
        })(jQuery)
    </script>
@endpush
