@extends('admin.layouts.app')
@section('panel')
    <div class="row">
        <div class="col-lg-12">
            <div class="card b-radius--10 ">
                <div class="card-body p-0">
                    <div class="table-responsive--md  table-responsive">
                        <table class="table table--light style--two">
                            <thead>
                            <tr>
                                <th>@lang('Username')</th>
                                <th>@lang('Code')</th>
                                <th>@lang('Amount')</th>
                                <th>@lang('End At')</th>
                                <th>@lang('Status')</th>
                                <th>@lang('Action')</th>
                            </tr>
                            </thead>
                            <tbody>
                            @forelse($gifts as $data)
                                <tr>
                                    <td data-label="@lang('Username')">
                                    <span class="font-weight-bold">
                                        {{ $data->user->username }}
                                    </span>
                                    </td>

                                    <td data-label="@lang('Code')">
                                    <span class="font-weight-bold" data-toggle="tooltip" data-original-title="@lang('Code')">
                                        {{ $data->code }}
                                    </span>
                                    </td>

                                    <td data-label="@lang('Amount')">
                                    {{ $data->currency }} {{ showAmount($data->amount) }}
                                    </td>

                                    <td data-label="@lang('End At')">
                                        {{ \Carbon\Carbon::parse($data->expired_date)->format('d-m-Y H:i A') }}
                                    </td>

                                    <td data-label="@lang('Status')">
                                        @if($data->status == 0)
                                            <span class="badge badge--danger">
                                            @lang('Disable')
                                        </span>
                                        @else
                                            <span class="badge badge--success">
                                            @lang('Enable')
                                        </span>
                                        @endif
                                    </td>

                                    <td data-label="@lang('Action')">
                                        <a href="#0"

                                           data-id='{{ $data->id }}'
                                           data-username='{{ $data->user->username }}'
                                           data-currency='{{ $data->currency }}'
                                           data-amount='{{ getAmount($data->amount) }}'
                                           data-expired_date='{{ \Carbon\Carbon::parse($data->expired_date)->format('Y-m-d') }}'
                                           data-status='{{ $data->status }}'

                                           class="icon-btn editBtn"
                                           data-toggle="tooltip"
                                           title="@lang('Edit')"
                                           data-original-title="@lang('Edit')"
                                        >
                                            <i class="las la-edit text--shadow"></i>
                                        </a>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td class="text-muted text-center" colspan="100%">{{ __($emptyMessage) }}</td>
                                </tr>
                            @endforelse

                            </tbody>
                        </table><!-- table end -->
                    </div>
                </div>
                <div class="card-footer py-4">
                    {{ paginateLinks($gifts) }}
                </div>
            </div>
        </div>

    </div>

    {{-- ADD METHOD MODAL --}}
    <div id="addModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">@lang('Add New Gift')</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form action="{{ route('admin.gift.create') }}" method="POST">
                    @csrf

                    <div class="modal-body">

                        <div class="row">
                            <div class="col-lg-12">
                                <div class="form-group">
                                    <label for="username">@lang('Username')</label>
                                    <input type="text" name="username" class="form-control" id="username" required>
                                </div>
                            </div>
                            <div class="col-lg-12">
                                <div class="form-group">
                                    <label for="currency">@lang('Currency')</label>
                                    <div class="input-group">
                                        <select name="currency" id="currency" required class="form-control">
                                            <option>@lang('Select An Option')</option>
                                            <option value="NGN" selected>@lang('NGN')</option>
                                            <option value="USDT">@lang('USDT')</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-12">
                                <div class="form-group">
                                    <label for="amount">@lang('Amount')</label>
                                    <div class="input-group">
                                        <input type="number" value="1" onkeyup="this.value = this.value.replace (/^\.|[^\d\.]/g, '')" name="amount" id="amount" class="form-control" required>
                                        <div class="input-group-append">
                                        <span class="input-group-text">
                                            <span id="change_amount_symbol"></span>
                                        </span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-12">
                                <div class="form-group">
                                    <label for="expired_date">@lang('End At')</label>
                                    <div class="input-group">
                                        <input type="date" id="expired_date" value="" class="form-control" name="expired_date" required>
                                        <div class="input-group-append">
                                        <span class="input-group-text">
                                            @lang('Date')
                                        </span>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-lg-12">
                                <div class="form-group">
                                    <label for="status">@lang('Status')</label>
                                    <select name="status" id="status" class="form-control" required>
                                        <option value="1">@lang('Enable')</option>
                                        <option value="0">@lang('Disable')</option>
                                    </select>
                                </div>
                            </div>
                        </div>

                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn--dark" data-dismiss="modal">@lang('Close')</button>
                        <button type="submit" class="btn btn--primary">@lang('Save')</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    {{-- ADD METHOD MODAL --}}
    <div id="editModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">@lang('Edit Gift')</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form action="{{ route('admin.gift.edit') }}" method="POST">
                    @csrf

                    <input type="hidden" name="id" required>

                    <div class="modal-body">

                    <div class="row">
                        <div class="col-lg-12">
                            <div class="form-group">
                                <label for="edit_username">@lang('Username')</label>
                                <input type="text" name="username" class="form-control" id="edit_username" required>
                            </div>
                        </div>
                            <div class="col-lg-12">
                                <div class="form-group">
                                    <label for="edit_currency">@lang('Currency')</label>
                                    <div class="input-group">
                                        <select name="currency" id="edit_currency" required class="form-control">
                                            <option>@lang('Select An Option')</option>
                                            <option value="NGN" selected>@lang('NGN')</option>
                                            <option value="USDT" selected>@lang('USDT')</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        <div class="col-lg-12">
                            <div class="form-group">
                                <label for="edit_amount">@lang('Amount')</label>
                                <div class="input-group">
                                    <input type="number" value="1" onkeyup="this.value = this.value.replace (/^\.|[^\d\.]/g, '')" name="amount" id="edit_amount" class="form-control" required>
                                    <div class="input-group-append">
                                    <span class="input-group-text">
                                        <span id="change_amount_symbol"></span>
                                    </span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-12">
                            <div class="form-group">
                                <label for="edit_expired_date">@lang('End At')</label>
                                <div class="input-group">
                                    <input type="date" id="edit_expired_date" value="" class="form-control" name="expired_date" required>
                                    <div class="input-group-append">
                                    <span class="input-group-text">
                                        @lang('Date')
                                    </span>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-lg-12">
                            <div class="form-group">
                                <label for="edit_status">@lang('Status')</label>
                                <select name="status" id="edit_status" class="form-control" required>
                                    <option value="1">@lang('Enable')</option>
                                    <option value="0">@lang('Disable')</option>
                                </select>
                            </div>
                        </div>
                    </div>

                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn--dark" data-dismiss="modal">@lang('Close')</button>
                        <button type="submit" class="btn btn--primary">@lang('Update')</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

@endsection

@push('breadcrumb-plugins')
    <a href="javascript:void(0)" class="btn btn-sm btn--primary box--shadow1 text-white text--small addBtn"><i class="fa fa-fw fa-plus"></i>@lang('Add New')</a>
@endpush

@push('script')
    <script>
        (function ($) {

            "use strict";

            $('.addBtn').on('click', (e)=> {
                var modal = $('#addModal');
                modal.modal('show');
            });

            $('.editBtn').on('click', (e)=> {
                var $this = $(e.currentTarget);
                var modal = $('#editModal');

                modal.find('input[name=id]').val($this.data('id'));
                modal.find('input[name=username]').val($this.data('username'));
                modal.find('select[name=currency]').val($this.data('currency'));
                modal.find('input[name=amount]').val($this.data('amount'));
                modal.find('input[name=expired_date]').val($this.data('expired_date'));
                modal.find('select[name=status]').val($this.data('status'));
                modal.modal('show');
            });

        })(jQuery);

    </script>
@endpush
