@extends('admin.layouts.app')
@section('panel')
    <div class="row">
        <div class="col-lg-12">
            <div class="card b-radius--10 ">
                <div class="card-body p-0">
                    <div class="table-responsive--md  table-responsive">
                        <table class="table table--light style--two">
                            <thead>
                            <tr>
                                <th>@lang('Name')</th>
                                <th>@lang('Amount')</th>
                                <th>@lang('Total Return')</th>
                                <th>@lang('Interest Type')</th>
                                <th>@lang('Product')</th>
                                <th>@lang('Status')</th>
                                <th>@lang('Action')</th>
                            </tr>
                            </thead>
                            <tbody>
                            @forelse($plan as $data)
                                <tr>
                                    <td data-label="@lang('Name')">
                                    <span class="font-weight-bold">
                                        {{ __($data->name) }}
                                    </span>
                                    </td>

                                    <td data-label="@lang('Amount')">
                                    <span class="font-weight-bold" data-toggle="tooltip" data-original-title="@lang('Limitation of Amount')">
                                        {{ config('settings')->cur_sym }} {{ showAmount($data->min_amount) }} -
                                        {{ config('settings')->cur_sym }} {{ showAmount($data->max_amount) }}
                                    </span>
                                    </td>

                                    <td data-label="@lang('Total Return')">
                                        {{ $data->total_return }} @lang('Times')
                                    </td>

                                    <td data-label="@lang('Interest Type')">
                                        @if($data->interest_type == 0)
                                            @lang('Fixed')
                                        @else
                                            @lang('Percent')
                                        @endif
                                    </td>

                                    <td data-label="@lang('Status')">
									<small>Available:{{$data->all_limit_buy}}<br/>Sold:{{$data->purchased}}</small>
									</td>

                                    <td data-label="@lang('Status')">
                                        @if($data->status == 0)
                                            <span class="badge badge--danger">
                                            @lang('Disable')
                                        </span>
                                        @else
                                            <span class="badge badge--success">
                                            @lang('Enable')
                                        </span>
                                        @endif
                                    </td>

                                    <td data-label="@lang('Action')">
                                        <a class="icon-btn editBtn text-white" data-toggle="tooltip" title="@lang('Edit')" data-original-title="@lang('Edit')" data-resource="{{ $data }}" >
                                            <i class="las la-edit text--shadow"></i>
                                        </a>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td class="text-muted text-center" colspan="100%">{{ __($emptyMessage) }}</td>
                                </tr>
                            @endforelse

                            </tbody>
                        </table><!-- table end -->
                    </div>
                </div>
                <div class="card-footer py-4">
                    {{ paginateLinks($plan) }}
                </div>
            </div>
        </div>

    </div>

    {{-- ADD METHOD MODAL --}}
    <div id="addModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">@lang('Add New Plan')</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form action="{{ route('admin.plan.create') }}" method="POST" enctype="multipart/form-data">
                    @csrf

                    <div class="modal-body">

                        <div class="row">
							<div class="col-md-5">
								<div class="form-group">
									<label>Image</label>
									<div class="image-upload">
										<div class="thumb">
											<div class="avatar-preview">
												<div class="profilePicPreview imageModalUpdate" style="height:200px;">
													<button type="button" class="remove-image"><i class="fa fa-times"></i></button>
												</div>
											</div>
											<div class="avatar-edit">
												<input type="file" class="profilePicUpload" name="image_input" style="padding: 0px 0px" id="uploadImage" accept=".png, .jpg, .jpeg" />
												<label for="uploadImage" class="bg--success">Icon</label>
												<small class="mt-2 text-facebook">@lang('Supported files:') <b>jpeg, jpg, png</b>.
													| @lang('Will be resized to:') <b>{{imagePath()['products']['size']}}</b> px.
												</small>
											</div>
										</div>
									</div>
								</div>
							</div>
                            <div class="col-lg-7">
								<div class="row">
									<div class="col-lg-12">
										<div class="form-group">
											<label for="name">@lang('Name')</label>
											<input type="text" name="name" class="form-control" id="name" required>
										</div>
									</div>
									<div class="col-lg-12">
										<div class="form-group">
											<label for="status">@lang('Status')</label>
											<select name="status" id="status" class="form-control" required>
												<option value="1">@lang('Enable')</option>
												<option value="0">@lang('Disable')</option>
											</select>
										</div>
									</div>

									<div class="col-lg-12">
										<div class="form-group">
											<label for="min_amount">@lang('Minimum Amount')</label>
											<div class="input-group">
												<input type="text" name="min_amount" onkeyup="this.value = this.value.replace (/^\.|[^\d\.]/g, '')" id="min_amount" class="form-control" required>
												<div class="input-group-append">
													<span class="input-group-text">{{ __(config('settings')->cur_text) }}</span>
												</div>
											</div>
										</div>
									</div>

									<div class="col-lg-12">
										<div class="form-group">
											<label for="max_amount">@lang('Maximum Amount')</label>
											<div class="input-group">
												<input type="text" name="max_amount" onkeyup="this.value = this.value.replace (/^\.|[^\d\.]/g, '')" id="max_amount" class="form-control" required>
												<div class="input-group-append">
													<span class="input-group-text">{{ __(config('settings')->cur_text) }}</span>
												</div>
											</div>
										</div>
									</div>
								</div>
							</div>

                            <div class="col-lg-12">
                                <div class="form-group">
                                    <label for="total_return">@lang('How Many Return')</label>
                                    <div class="input-group">
                                        <input type="number" id="total_return" value="4" class="form-control" name="total_return" required>
                                        <div class="input-group-append">
                                        <span class="input-group-text">
                                            @lang('Times')
                                        </span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-12">
                                <div class="form-group">
                                    <label for="interest_type">@lang('Interest Type')</label>
                                    <div class="input-group">
                                        <select name="interest_type" id="interest_type" required class="form-control">
                                            <option>@lang('Select An Option')</option>
                                            <option value="1" selected>@lang('Percent')</option>
                                            <option value="0">@lang('Fixed')</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-12">
                                <div class="form-group">
                                    <label for="interest">@lang('Interest Amount')</label>
                                    <div class="input-group">
                                        <input type="text" value="10" onkeyup="this.value = this.value.replace (/^\.|[^\d\.]/g, '')" name="interest" id="interest" class="form-control" required>
                                        <div class="input-group-append">
                                        <span class="input-group-text">
                                            <span id="change_interest_symbol">%</span>
                                        </span>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-lg-12">
                                <div class="form-group">
                                    <label for="capital_back_status">@lang('Return Capital')</label>
                                    <div class="input-group">
                                        <select name="capital_back_status" id="capital_back_status" required class="form-control">
                                            <option>@lang('Select An Option')</option>
                                            <option value="1" selected>@lang('Yes')</option>
                                            <option value="0">@lang('No')</option>
                                        </select>
                                    </div>
                                </div>
                            </div>

                            <div class="col-lg-12">
                                <div class="form-group">
                                    <label for="capital">@lang('Product Capital Market')</label>
                                    <div class="input-group">
                                        <input type="number" id="capital" class="form-control" name="capital" required>
                                        <div class="input-group-append">
                                        <span class="input-group-text">
                                            USD
                                        </span>
                                        </div>
                                    </div>
                                </div>
                            </div>
							
                            <div class="col-lg-12">
                                <div class="form-group">
                                    <label for="summary">@lang('Package Summary')</label>
                                    <textarea name="summary" class="form-control" id="summary" placeholder="Enter short meanifull message for this package " required></textarea>
                                </div>
                            </div>
							
                            <div class="col-lg-12">
                                <div class="form-group">
                                    <label for="notes">@lang('Full details')</label>
                                    <textarea name="notes" class="form-control" id="notes" placeholder="Enter full details about this package " required></textarea>
                                </div>
                            </div>
							
                        </div>

                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn--dark" data-dismiss="modal">@lang('Close')</button>
                        <button type="submit" class="btn btn--primary">@lang('Save')</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    {{-- ADD METHOD MODAL --}}
    <div id="editModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">@lang('Edit Plan')</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form action="{{ route('admin.plan.edit') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    <input type="hidden" name="id" required>

                    <div class="modal-body">

                        <div class="row">
						
							<div class="col-md-5">
								<div class="form-group">
									<label>Image</label>
									<div class="image-upload">
										<div class="thumb">
											<div class="avatar-preview">
												<div class="profilePicPreview imageModalUpdate" style="height:200px;">
													<button type="button" class="remove-image"><i class="fa fa-times"></i></button>
												</div>
											</div>
											<div class="avatar-edit">
												<input type="file" class="profilePicUpload" name="image_input" style="padding: 0px 0px" id="uploadsImage" accept=".png, .jpg, .jpeg" />
												<label for="uploadsImage" class="bg--success">Icon</label>
												<small class="mt-2 text-facebook">@lang('Supported files:') <b>jpeg, jpg, png</b>.
													| @lang('Will be resized to:') <b>{{ imagePath()['products']['size'] }}</b> px.
												</small>
											</div>
										</div>
									</div>
								</div>
							</div>
						
                            <div class="col-lg-7">
								<div class="row">
									<div class="col-lg-12">
										<div class="form-group">
											<label for="edit_name">@lang('Name')</label>
											<input type="text" name="name" class="form-control" id="edit_name" required>
										</div>
									</div>
									
									<div class="col-lg-12">
										<div class="form-group">
											<label for="edit_capital_back_status">@lang('Return Capital')</label>
											<div class="input-group">
												<select name="capital_back_status" id="edit_capital_back_status" required class="form-control">
													<option value="1">@lang('Yes')</option>
													<option value="0">@lang('No')</option>
												</select>
											</div>
										</div>
									</div>
									
									<div class="col-lg-12">
										<div class="form-group">
											<label for="edit_min_amount">@lang('Minimum Amount')</label>
											<div class="input-group">
												<input type="text" name="min_amount" onkeyup="this.value = this.value.replace (/^\.|[^\d\.]/g, '')" id="edit_min_amount" class="form-control" required>
												<div class="input-group-append">
													<span class="input-group-text">{{ __(config('settings')->cur_text) }}</span>
												</div>
											</div>
										</div>
									</div>
									
									<div class="col-lg-12">
										<div class="form-group">
											<label for="edit_max_amount">@lang('Maximum Amount')</label>
											<div class="input-group">
												<input type="text" name="max_amount" onkeyup="this.value = this.value.replace (/^\.|[^\d\.]/g, '')" id="edit_max_amount" class="form-control" required>
												<div class="input-group-append">
													<span class="input-group-text">{{ __(config('settings')->cur_text) }}</span>
												</div>
											</div>
										</div>
									</div>
								</div>
							</div>
							
							<div class="col-lg-12">
                                <div class="form-group">
                                    <label for="edit_total_return">@lang('How Many Return')</label>
                                    <div class="input-group">
                                        <input type="number" id="edit_total_return" class="form-control" name="total_return" required>
                                        <div class="input-group-append">
                                        <span class="input-group-text">
                                            @lang('Times')
                                        </span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-12">
                                <div class="form-group">
                                    <label for="edit_interest_type">@lang('Interest Type')</label>
                                    <div class="input-group">
                                        <select name="interest_type" id="edit_interest_type" required class="form-control">
                                            <option>@lang('Select An Option')</option>
                                            <option value="1">@lang('Percent')</option>
                                            <option value="0">@lang('Fixed')</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-12">
                                <div class="form-group">
                                    <label for="edit_interest">@lang('Interest Amount')</label>
                                    <div class="input-group">
                                        <input type="text" onkeyup="this.value = this.value.replace (/^\.|[^\d\.]/g, '')" name="interest" id="edit_interest" class="form-control" required>
                                        <div class="input-group-append">
                                        <span class="input-group-text">
                                            <span id="update_interest_symbol">%</span>
                                        </span>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label for="edit_buy_limit">@lang('Buy Limit')</label>
                                    <select name="buy_limit" id="edit_buy_limit" class="form-control" required>
                                        <option value="1">@lang('Enable')</option>
                                        <option value="0">@lang('Disable')</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label for="edit_buy_limit_type">@lang('Buy Limit Type')</label>
                                    <select name="buy_limit_type" id="edit_buy_limit_type" class="form-control" required>
                                        <option value="1">@lang('Per Day')</option>
                                        <option value="0">@lang('Anytime')</option>
                                    </select>
                                </div>
                            </div>

                            <div class="col-lg-12">
                                <div class="form-group">
                                    <label for="edit_limit_buy">@lang('Buy Limit Count')</label>
                                    <div class="input-group">
                                        <input type="number" id="edit_limit_buy" class="form-control" name="limit_buy" required>
                                        <div class="input-group-append">
                                        <span class="input-group-text">
                                            @lang('Times')
                                        </span>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-lg-12">
                                <div class="form-group">
                                    <label for="edit_all_limit_buy">@lang('Total Available Product')</label>
                                    <div class="input-group">
                                        <input type="number" id="edit_all_limit_buy" class="form-control" name="all_limit_buy" required />
                                        <div class="input-group-append">
                                        <span class="input-group-text">
                                            @lang('product')
                                        </span>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-lg-12">
                                <div class="form-group">
                                    <label for="edit_purchased">@lang('Total Purchased Product')</label>
                                    <div class="input-group">
                                        <input type="number" id="edit_purchased" class="form-control" name="purchased" required />
                                        <div class="input-group-append">
                                        <span class="input-group-text">
                                            @lang('bought')
                                        </span>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-lg-12">
                                <div class="form-group">
                                    <label for="edit_escape_buy_limit">@lang('Escape admin Buy Limit')</label>
                                    <select name="escape_buy_limit" id="edit_escape_buy_limit" class="form-control" required>
                                        <option value="1">@lang('Enable')</option>
                                        <option value="0">@lang('Disable')</option>
                                    </select>
                                </div>
                            </div>

                            <div class="col-lg-12">
                                <div class="form-group">
                                    <label for="edit_status">@lang('Status')</label>
                                    <select name="status" id="edit_status" class="form-control" required>
                                        <option value="1">@lang('Enable')</option>
                                        <option value="0">@lang('Disable')</option>
                                    </select>
                                </div>
                            </div>

                            <div class="col-lg-12">
                                <div class="form-group">
                                    <label for="edit_p_status">@lang('Status Type')</label>
                                    <select name="p_status" id="edit_p_status" class="form-control" required />
                                        <option value="to_buy">@lang('Available')</option>
                                        <option value="coming">@lang('Coming Soon')</option>
                                        <option value="trial">@lang('Testing Product')</option>
                                        <option value="solid_out">@lang('Solid Out')</option>
                                    </select>
                                </div>
                            </div>

                            <div class="col-lg-12 lock_endat" style="display:none">
                                <div class="form-group">
                                    <label for="edit_lock_endat">@lang('Open Date')</label>
                                    <div class="input-group">
                                        <input type="date" id="edit_lock_endat" class="form-control" name="lock_endat" />
                                        <div class="input-group-append">
											<span class="input-group-text">DATE</span>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-lg-12">
                                <div class="form-group">
                                    <label for="edit_capital">@lang('Product Capital Market')</label>
                                    <div class="input-group">
                                        <input type="number" id="edit_capital" class="form-control" name="capital" required>
                                        <div class="input-group-append">
                                        <span class="input-group-text">
                                            USD
                                        </span>
                                        </div>
                                    </div>
                                </div>
                            </div>
							
                            <div class="col-lg-12">
                                <div class="form-group">
                                    <label for="edit_summary">@lang('Package Summary')</label>
                                    <textarea name="summary" class="form-control" id="edit_summary" placeholder="Enter short meanifull message for this package " required></textarea>
                                </div>
                            </div>
							
                            <div class="col-lg-12">
                                <div class="form-group">
                                    <label for="edit_notes">@lang('Full details')</label>
                                    <textarea name="notes" class="form-control" id="edit_notes" placeholder="Enter full details about this package " required></textarea>
                                </div>
                            </div>
                        </div>

                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn--dark" data-dismiss="modal">@lang('Close')</button>
                        <button type="submit" class="btn btn--primary">@lang('Update')</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

@endsection

@push('breadcrumb-plugins')
    <a href="javascript:void(0)" class="btn btn-sm btn--primary box--shadow1 text-white text--small addBtn"><i class="fa fa-fw fa-plus"></i>@lang('Add New')</a>
@endpush

@push('script')
    <script>
        (function ($) {

            "use strict";

            $('.addBtn').on('click', (e)=> {
                var modal = $('#addModal');
                modal.modal('show');
            });

            $('#interest_type').on('change', (e)=>{
                var $this = e.currentTarget;

                var result = null;

                if($this.value == 0){
                    result = '{{ __(config('settings')->cur_text) }}';
                }else{
                    result = '%';
                }

                $('#change_interest_symbol').text(result);

            });

            $('#edit_interest_type').on('change', (e)=>{
                var $this = e.currentTarget;

                var result = null;

                if($this.value == 0){
                    result = '{{ __(config('settings')->cur_text) }}';
                }else{
                    result = '%';
                }

                $('#update_interest_symbol').text(result);

            });

            $('#edit_p_status').on('change', (e)=>{
                var $this = e.currentTarget;

                if($this.value == 'coming'){
					$('.lock_endat').show();
                }else{
					$('.lock_endat').hide();
				}
            });

            $('.editBtn').on('click', (e)=> {
                var $this = $(e.currentTarget);
                var modal = $('#editModal');
				var resource = $this.data('resource');

                var result = null;

                if(resource.p_status == 'coming'){
					$('.lock_endat').show();
				}
				
                if(resource.interest_type == 0){
                    result = '{{ __(config('settings')->cur_text) }}';
                }else{
                    result = '%';
                }

                $('#update_interest_symbol').text(result);
				var dTime = new Date(Date.parse(resource.lock_endat)).toLocaleDateString('en-CA');

                modal.find('input[name=id]').val(resource.id);
                modal.find('input[name=name]').val(resource.name);
                modal.find('input[name=total_return]').val(resource.total_return);
                modal.find('input[name=max_amount]').val(parseFloat(resource.max_amount).toFixed(2));
                modal.find('input[name=min_amount]').val(parseFloat(resource.min_amount).toFixed(2));
                modal.find('input[name=interest]').val(parseFloat(resource.interest_amount).toFixed(2));
                modal.find('select[name=status]').val(resource.status);
                modal.find('select[name=p_status]').val(resource.p_status);
                modal.find('select[name=interest_type]').val(resource.interest_type);
                modal.find('select[name=buy_limit]').val(resource.buy_limit);
                modal.find('select[name=buy_limit_type]').val(resource.buy_limit_type);
                modal.find('input[name=limit_buy]').val(resource.limit_buy);
                modal.find('input[name=lock_endat]').val(dTime);
                modal.find('input[name=purchased]').val(resource.purchased);
                modal.find('input[name=all_limit_buy]').val(resource.all_limit_buy);
                modal.find('input[name=capital]').val(resource.capital);
                modal.find('select[name=escape_buy_limit]').val(resource.escape_buy_limit);
                modal.find('select[name=capital_back_status]').val(resource.capital_back_status);
                modal.find('textarea[name=summary]').val(resource.summary);
                modal.find('textarea[name=notes]').val(resource.notes);

				modal.find('.profilePicPreview').css('background-image', "url(/{{ imagePath()['products']['path'] }}" + "/" + resource.img +')');

                modal.modal('show');
            });

        })(jQuery);

    </script>
@endpush
