@extends('admin.layouts.app')
<?php $typeList = array(1=>'Invest',2=>'Invite',3=>'Bonus'); ?>

@section('panel')
    <div class="row">
        <div class="col-lg-12">
            <div class="card b-radius--10 ">
                <div class="card-body p-0">
                    <div class="table-responsive--md  table-responsive">
                        <table class="table table--light style--two">
                            <thead>
                            <tr>
                                <th>@lang('Network')</th>
                                <th>@lang('Card No')</th>
                                <th>@lang('Amount')</th>
                                <th>@lang('Status')</th>
                                <th>@lang('Action')</th>
                            </tr>
                            </thead>
                            <tbody>
                            @forelse($raffles as $data)
                                <tr>
                                    <td data-label="@lang('Network')">
                                    <span class="font-weight-bold">
                                        {{ __($data->network) }}
                                    </span>
                                    </td>

                                    <td data-label="@lang('Card No')">
                                        {{ $data->cards }}
                                    </td>

                                    <td data-label="@lang('Amount')">
                                    <span class="font-weight-bold" data-toggle="tooltip" data-original-title="@lang('Card Amount')">
                                        {{ config('settings')->cur_sym }} {{ showAmount($data->amount) }}
                                    </span>
                                    </td>

                                    <td data-label="@lang('Status')">
                                        @if($data->status == 2)
                                            <span class="badge badge--danger">
                                            @lang('USED')
                                        </span>
                                        @else
                                            <span class="badge badge--success">
                                            @lang('Active')
                                        </span>
                                        @endif
                                    </td>

                                    <td data-label="@lang('Action')">
                                        <a class="icon-btn editBtn text-white" data-toggle="tooltip" title="@lang('Edit')" data-original-title="@lang('Edit')" data-resource="{{ $data }}" >
                                            <i class="las la-edit text--shadow"></i>
                                        </a>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td class="text-muted text-center" colspan="100%">{{ __($emptyMessage) }}</td>
                                </tr>
                            @endforelse

                            </tbody>
                        </table><!-- table end -->
                    </div>
                </div>
                <div class="card-footer py-4">
                    {{ paginateLinks($raffles) }}
                </div>
            </div>
        </div>
    </div>


    {{-- ADD METHOD MODAL --}}
    <div id="editModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">@lang('Edit Card')</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form action="{{ route('admin.raffle.edit') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    <input type="hidden" name="id" required>

                    <div class="modal-body">

                        <div class="row">
                            <div class="col-lg-12">
								<div class="row">
									<div class="col-lg-12">
										<div class="form-group">
											<label for="edit_network">@lang('Status')</label>
											<select name="network" id="edit_network" class="form-control" required>
												<option value="MTN">@lang('MTN')</option>
												<option value="GLO">@lang('GLO')</option>
												<option value="VIASAT">@lang('VIASAT')</option>
												<option value="AIRTEL">@lang('AIRTEL')</option>
												<option value="9MOBILE">@lang('9MOBILE')</option>
											</select>
										</div>
									</div>
									<div class="col-lg-12">
										<div class="form-group">
											<label for="edit_status">@lang('Status')</label>
											<select name="status" id="edit_status" class="form-control" required>
												<option value="1">@lang('Enable')</option>
												<option value="0">@lang('Disable')</option>
											</select>
										</div>
									</div>

									<div class="col-lg-12">
										<div class="form-group">
											<label for="edit_cards">@lang('Cards Number')</label>
											<div class="input-group">
												<input type="text" name="cards" id="edit_cards" class="form-control" required>
												<div class="input-group-append">
													<span class="input-group-text">CODE</span>
												</div>
											</div>
										</div>
									</div>

									<div class="col-lg-12">
										<div class="form-group">
											<label for="edit_amount">@lang('Card Amount')</label>
											<div class="input-group">
												<input type="text" name="amount" onkeyup="this.value = this.value.replace (/^\.|[^\d\.]/g, '')" id="edit_amount" class="form-control" required>
												<div class="input-group-append">
													<span class="input-group-text currency_exchange_rate">{{ __(config('settings')->cur_text) }}</span>
												</div>
											</div>
										</div>
									</div>
								</div>
							</div>

                            <div class="col-lg-12">
                                <div class="form-group">
                                    <label for="edit_quiz">@lang('Task Question')</label>
                                    <textarea name="quiz[question]" class="form-control" id="edit_quiz" placeholder="Enter short ans simple question to be asked before reward" required></textarea>
                                </div>
                            </div>

                            <div class="col-lg-12">
								<div class="form-group">
									<label for="edit_answer">@lang('Question Answer')</label>
									<div class="input-group">
										<input type="text" name="quiz[answer]" placeholder="Answer to Question" id="edit_answer" class="form-control" required />
										<div class="input-group-append">
											<span class="input-group-text"></span>
										</div>
									</div>
								</div>
                            </div>

                        </div>
                    </div>

                    <div class="modal-footer">
                        <button type="button" class="btn btn--dark" data-dismiss="modal">@lang('Close')</button>
                        <button type="submit" class="btn btn--primary">@lang('Update')</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

@endsection

@push('breadcrumb-plugins')
    <a href="javascript:void(0)" class="btn btn-sm btn--primary box--shadow1 text-white text--small addBtn"><i class="fa fa-fw fa-plus"></i>@lang('Add New')</a>
@endpush

@push('script')
    <script>
        (function ($) {

            "use strict";

            $('.addBtn').on('click', (e)=> {
                var modal = $('#addModal');
                modal.modal('show');
            });

            $('.editBtn').on('click', (e)=> {
                var $this = $(e.currentTarget);
                var modal = $('#editModal');
				var resource = $this.data('resource');

                modal.find('input[name=id]').val(resource.id);
                modal.find('select[name=network]').val(resource.network);
                modal.find('input[name=amount]').val(parseFloat(resource.amount).toFixed(2));
                modal.find('select[name=status]').val(resource.status);

                modal.find('input[name=cards]').val(resource.cards);
				if( resource.quiz ){
					modal.find('textarea[id=edit_quiz]').val(resource.quiz.question);
					modal.find('input[id=edit_answer]').val(resource.quiz.answer);
				}else{
					modal.find('textarea[id=edit_quiz]').val('');
					modal.find('input[id=edit_answer]').val('');
				}

                modal.modal('show');
            });

        })(jQuery);

    </script>
@endpush
