@extends('admin.layouts.app')
<?php $typeList = array(1=>'Invest',2=>'Invite',3=>'Bonus'); ?>

@section('panel')
    <div class="row">
        <div class="col-lg-12">
            <div class="card b-radius--10 ">
                <div class="card-body p-0">
                    <div class="table-responsive--md  table-responsive">
                        <table class="table table--light style--two">
                            <thead>
                            <tr>
                                <th>@lang('Name')</th>
                                <th>@lang('Reward')</th>
                                <th>@lang('Interval')</th>
                                <th>@lang('Expires')</th>
                                <th>@lang('Task')</th>
                                <th>@lang('Status')</th>
                                <th>@lang('Action')</th>
                            </tr>
                            </thead>
                            <tbody>
                            @forelse($rewards as $data)
                                <tr>
                                    <td data-label="@lang('Name')">
                                    <span class="font-weight-bold">
                                        {{ __($data->name) }}
                                    </span>
                                    </td>

                                    <td data-label="@lang('Reward')">
                                    <span class="font-weight-bold" data-toggle="tooltip" data-original-title="@lang('Reward Amount')">
                                        {{ config('settings')->cur_sym }} {{ showAmount($data->amount) }}
                                    </span>
                                    </td>

                                    <td data-label="@lang('Interval')">
                                        {{ $data->interval }} @lang('Hrs')
                                    </td>

                                    <td data-label="@lang('Expires')">
										<small>{{$data->expires}}</small>
									</td>

                                    <td data-label="@lang('Task')">
										{{ $typeList[$data->type] }} {{ $data->number }}
                                    </td>


                                    <td data-label="@lang('Status')">
                                        @if($data->status == 0)
                                            <span class="badge badge--danger">
                                            @lang('Disable')
                                        </span>
                                        @else
                                            <span class="badge badge--success">
                                            @lang('Enable')
                                        </span>
                                        @endif
                                    </td>

                                    <td data-label="@lang('Action')">
                                        <a class="icon-btn editBtn text-white" data-toggle="tooltip" title="@lang('Edit')" data-original-title="@lang('Edit')" data-resource="{{ $data }}" >
                                            <i class="las la-edit text--shadow"></i>
                                        </a>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td class="text-muted text-center" colspan="100%">{{ __($emptyMessage) }}</td>
                                </tr>
                            @endforelse

                            </tbody>
                        </table><!-- table end -->
                    </div>
                </div>
                <div class="card-footer py-4">
                    {{ paginateLinks($rewards) }}
                </div>
            </div>
        </div>

    </div>

    {{-- ADD METHOD MODAL --}}
    <div id="addModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">@lang('Add New Reward')</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form action="{{ route('admin.rewards.create') }}" method="POST" enctype="multipart/form-data">
                    @csrf

                    <div class="modal-body">

                        <div class="row">
                            <div class="col-lg-12">
								<div class="row">
									<div class="col-lg-12">
										<div class="form-group">
											<label for="name">@lang('Name')</label>
											<input type="text" name="name" class="form-control" id="name" required>
										</div>
									</div>
									<div class="col-lg-12">
										<div class="form-group">
											<label for="status">@lang('Status')</label>
											<select name="status" id="status" class="form-control" required>
												<option value="1">@lang('Enable')</option>
												<option value="0">@lang('Disable')</option>
											</select>
										</div>
									</div>
							
									<div class="col-lg-12">
										<div class="form-group">
											<label for="currency">@lang('Currency')</label>
											<div class="input-group">
												<select name="currency" id="currency" required class="form-control">
													<option value="NGN">@lang('NGN')</option>
													<option value="USDT">@lang('USDT')</option>
												</select>
											</div>
										</div>
									</div>

									<div class="col-lg-12">
										<div class="form-group">
											<label for="amount">@lang('Reward Amount')</label>
											<div class="input-group">
												<input type="text" name="amount" onkeyup="this.value = this.value.replace (/^\.|[^\d\.]/g, '')" id="amount" class="form-control" required>
												<div class="input-group-append">
													<span class="input-group-text currency_exchange_rate">{{ __(config('settings')->cur_text) }}</span>
												</div>
											</div>
										</div>
									</div>

									<div class="col-lg-12">
										<div class="form-group">
											<label for="interval">@lang('Reward Interval')</label>
											<div class="input-group">
												<input type="number" name="interval" onkeyup="this.value = this.value.replace (/^\.|[^\d\.]/g, '')" id="interval" class="form-control" required>
												<div class="input-group-append">
													<span class="input-group-text">Hourly</span>
												</div>
											</div>
										</div>
									</div>

								</div>
							</div>

                            <div class="col-lg-12">
							
                                <div class="form-group">
                                    <label for="type">@lang('Task Type')</label>
                                    <div class="input-group">
                                        <select name="type" id="type" required class="form-control">
                                            <option>@lang('Select An Option')</option>
                                            <option value="1" selected>@lang('Invest')</option>
                                            <option value="2">@lang('Invite')</option>
                                            <option value="3">@lang('Bonus')</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="number">@lang('Requirement')</label>
                                    <div class="input-group">
                                        <input type="number" id="number" class="form-control" name="number" required />
                                        <div class="input-group-append">
                                        <span class="input-group-text">
                                            @lang('count')
                                        </span>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-lg-12">
                                <div class="form-group">
                                    <label for="rate">@lang('Exchange Rate')</label>
                                    <div class="input-group">
                                        <div class="input-group-append">
											<span class="input-group-text">
												<span>1 {{ config('settings')->cur_text }} =</span>
											</span>
                                        </div>
                                        <input type="number" step="any" onkeyup="this.value = this.value.replace (/^\.|[^\d\.]/g, '')" name="rate" id="rate" class="form-control" required />
                                        <div class="input-group-append">
											<span class="input-group-text">
												<span class="currency_exchange_rate">{{ config('settings')->cur_text }}</span>
											</span>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-lg-12">
                                <div class="form-group">
                                    <label for="expires">@lang('Reward Ends Date')</label>
                                    <div class="input-group">
                                        <input type="date" id="expires" class="form-control" name="expires" />
                                        <div class="input-group-append">
											<span class="input-group-text">DATE</span>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-lg-12">
                                <div class="form-group">
                                    <label for="summary">@lang('Reward Summary')</label>
                                    <textarea name="summary" class="form-control" id="summary" placeholder="Enter short meanifull message for this reward" required></textarea>
                                </div>
                            </div>
							
                        </div>

                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn--dark" data-dismiss="modal">@lang('Close')</button>
                        <button type="submit" class="btn btn--primary">@lang('Save')</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    {{-- ADD METHOD MODAL --}}
    <div id="editModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">@lang('Edit Reward Plan')</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form action="{{ route('admin.rewards.edit') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    <input type="hidden" name="id" required>

                    <div class="modal-body">

                        <div class="row">
                            <div class="col-lg-12">
								<div class="row">
									<div class="col-lg-12">
										<div class="form-group">
											<label for="edit_name">@lang('Name')</label>
											<input type="text" name="name" class="form-control" id="edit_name" required>
										</div>
									</div>
									<div class="col-lg-12">
										<div class="form-group">
											<label for="edit_status">@lang('Status')</label>
											<select name="status" id="edit_status" class="form-control" required>
												<option value="1">@lang('Enable')</option>
												<option value="0">@lang('Disable')</option>
											</select>
										</div>
									</div>

									<div class="col-lg-12">
										<div class="form-group">
											<label for="edit_currency">@lang('Currency')</label>
											<div class="input-group">
												<select name="currency" id="edit_currency" required class="form-control">
													<option value="NGN">@lang('NGN')</option>
													<option value="USDT">@lang('USDT')</option>
												</select>
											</div>
										</div>
									</div>

									<div class="col-lg-12">
										<div class="form-group">
											<label for="edit_amount">@lang('Reward Amount')</label>
											<div class="input-group">
												<input type="text" name="amount" onkeyup="this.value = this.value.replace (/^\.|[^\d\.]/g, '')" id="edit_amount" class="form-control" required>
												<div class="input-group-append">
													<span class="input-group-text currency_exchange_rate">{{ __(config('settings')->cur_text) }}</span>
												</div>
											</div>
										</div>
									</div>

									<div class="col-lg-12">
										<div class="form-group">
											<label for="edit_interval">@lang('Reward Interval')</label>
											<div class="input-group">
												<input type="number" name="interval" onkeyup="this.value = this.value.replace (/^\.|[^\d\.]/g, '')" id="edit_interval" class="form-control" required>
												<div class="input-group-append">
													<span class="input-group-text">Hourly</span>
												</div>
											</div>
										</div>
									</div>

								</div>
							</div>

                            <div class="col-lg-12">
							
                                <div class="form-group">
                                    <label for="edit_type">@lang('Task Type')</label>
                                    <div class="input-group">
                                        <select name="type" id="edit_type" required class="form-control">
                                            <option>@lang('Select An Option')</option>
                                            <option value="1" selected>@lang('Invest')</option>
                                            <option value="2">@lang('Invite')</option>
                                            <option value="3">@lang('Bonus')</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="edit_number">@lang('Requirement')</label>
                                    <div class="input-group">
                                        <input type="number" id="edit_number" class="form-control" name="number" required />
                                        <div class="input-group-append">
                                        <span class="input-group-text">
                                            @lang('count')
                                        </span>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-lg-12">
                                <div class="form-group">
                                    <label for="edit_rate">@lang('Exchange Rate')</label>
                                    <div class="input-group">
                                        <div class="input-group-append">
											<span class="input-group-text">
												<span>1 {{ config('settings')->cur_text }} =</span>
											</span>
                                        </div>
                                        <input type="number" step="any" onkeyup="this.value = this.value.replace (/^\.|[^\d\.]/g, '')" name="rate" id="edit_rate" class="form-control" required />
                                        <div class="input-group-append">
											<span class="input-group-text">
												<span class="currency_exchange_rate">{{ config('settings')->cur_text }}</span>
											</span>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-lg-12">
                                <div class="form-group">
                                    <label for="edit_expires">@lang('Reward Ends Date')</label>
                                    <div class="input-group">
                                        <input type="date" id="edit_expires" class="form-control" name="expires" />
                                        <div class="input-group-append">
											<span class="input-group-text">DATE</span>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-lg-12">
                                <div class="form-group">
                                    <label for="edit_summary">@lang('Reward Summary')</label>
                                    <textarea name="summary" class="form-control" id="edit_summary" placeholder="Enter short meanifull message for this reward" required></textarea>
                                </div>
                            </div>
							
                        </div>

                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn--dark" data-dismiss="modal">@lang('Close')</button>
                        <button type="submit" class="btn btn--primary">@lang('Update')</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

@endsection

@push('breadcrumb-plugins')
    <a href="javascript:void(0)" class="btn btn-sm btn--primary box--shadow1 text-white text--small addBtn"><i class="fa fa-fw fa-plus"></i>@lang('Add New')</a>
@endpush

@push('script')
    <script>
        (function ($) {

            "use strict";

            $('.addBtn').on('click', (e)=> {
                var modal = $('#addModal');
                modal.modal('show');
            });

            $('#currency').on('change', (e)=>{
                var $this = e.currentTarget;
                $('.currency_exchange_rate').text($this.value);
            });

            $('#edit_currency').on('change', (e)=>{
                var $this = e.currentTarget;
                $('.currency_exchange_rate').text($this.value);
            });

            $('.editBtn').on('click', (e)=> {
                var $this = $(e.currentTarget);
                var modal = $('#editModal');
				var resource = $this.data('resource');

                $('.currency_exchange_rate').text(resource.currency);

				var dTime = new Date(Date.parse(resource.expires)).toLocaleDateString('en-CA');

                modal.find('input[name=id]').val(resource.id);
                modal.find('input[name=name]').val(resource.name);
                modal.find('input[name=amount]').val(parseFloat(resource.amount).toFixed(2));
                modal.find('select[name=status]').val(resource.status);
                modal.find('input[name=expires]').val(dTime);
                modal.find('textarea[name=summary]').val(resource.summary);
                modal.find('input[name=number]').val(resource.number);
                modal.find('input[name=interval]').val(resource.interval);
                modal.find('select[name=type]').val(resource.type);
                modal.find('input[name=rate]').val(resource.rate);
                modal.find('select[name=currency]').val(resource.currency);

                modal.modal('show');
            });

        })(jQuery);

    </script>
@endpush
