@extends('admin.layouts.app')
@section('panel')
    <div class="row">
        <div class="col-lg-12">
            <div class="card b-radius--10 ">
                <div class="card-body p-0">
                    <div class="table-responsive--md  table-responsive">
                        <table class="table table--light style--two">
                            <thead>
                            <tr>
                                <th>@lang('Image')</th>
                                <th>@lang('Title')</th>
                                <th>@lang('Amount')</th>
                                <th>@lang('Currency')</th>
                                <th>@lang('Status')</th>
                                <th>@lang('Action')</th>
                            </tr>
                            </thead>
                            <tbody>
                            @forelse($plan as $data)
                                <tr>
                                    <td data-label="@lang('Image')">
                                        <img src="{{ asset('assets/'.$data->image) }}" width="100">
                                    </td>
                                    <td data-label="@lang('Title')">
										<span class="font-weight-bold">
											{{ __($data->name) }}
										</span>
                                    </td>
                                    <td data-label="@lang('Amount')">
                                        {{ ($data->amount +0)}}
                                    </td>
                                    <td data-label="@lang('Currency')">
                                        {{ $data->currency }}
                                    </td>
                                    <td data-label="@lang('Status')">
                                        @if($data->status == 0)
                                            <span class="badge badge--danger">
                                            @lang('Disable')
                                        </span>
                                        @else
                                            <span class="badge badge--success">
                                            @lang('Enable')
                                        </span>
                                        @endif
                                    </td>

                                    <td data-label="@lang('Action')">
                                        <a class="icon-btn editBtn text-white" data-toggle="tooltip" title="@lang('Edit')" data-original-title="@lang('Edit')" data-resource="{{ $data }}" >
                                            <i class="las la-edit text--shadow"></i>
                                        </a>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td class="text-muted text-center" colspan="100%">{{ __($emptyMessage) }}</td>
                                </tr>
                            @endforelse

                            </tbody>
                        </table><!-- table end -->
                    </div>
                </div>
                <div class="card-footer py-4">
                    {{ paginateLinks($plan) }}
                </div>
            </div>
        </div>

    </div>

    {{-- ADD METHOD MODAL --}}
    <div id="addModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">@lang('Add New Task')</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form action="{{ route('admin.tasks.create') }}" method="POST" enctype="multipart/form-data">
                    @csrf

                    <div class="modal-body">

                        <div class="row">
							<div class="col-md-5">
								<div class="form-group">
									<label>Picture</label>
									<div class="image-upload">
										<div class="thumb">
											<div class="avatar-preview">
												<div class="profilePicPreview imageModalUpdate" style="height:200px;">
													<button type="button" class="remove-image"><i class="fa fa-times"></i></button>
												</div>
											</div>
											<div class="avatar-edit">
												<input type="file" class="profilePicUpload" name="image" style="padding: 0px 0px" id="uploadImage" accept=".png, .jpg, .jpeg" />
												<label for="uploadImage" class="bg--success">Icon</label>
												<small class="mt-2 text-facebook">@lang('Supported files:') <b>jpeg, jpg, png</b>.
													| @lang('Will be resized to:') <b>{{imagePath()['products']['size']}}</b> px.
												</small>
											</div>
										</div>
									</div>
								</div>
							</div>
                            <div class="col-lg-7">
								<div class="row">
									<div class="col-lg-12">
										<div class="form-group">
											<label for="name">@lang('Name')</label>
											<input type="text" name="name" class="form-control" id="name" required>
										</div>
									</div>
									<div class="col-lg-12">
										<div class="form-group">
											<label for="url">@lang('Link')</label>
											<input type="url" name="url" class="form-control" id="url" required placeholder="http://">
										</div>
									</div>

									<div class="col-lg-12">
										<div class="form-group">
											<label for="status">@lang('Status')</label>
											<select name="status" id="status" class="form-control" required>
												<option value="1">@lang('Enable')</option>
												<option value="0">@lang('Disable')</option>
											</select>
										</div>
									</div>

									<div class="col-lg-12">
										<div class="form-group">
											<label for="amount">@lang('Amount')</label>
											<div class="input-group">
												<input type="text" name="amount" onkeyup="this.value = this.value.replace (/^\.|[^\d\.]/g, '')" id="amount" class="form-control" required>
												<div class="input-group-append">
													<span class="input-group-text">{{ __(config('settings')->cur_text) }}</span>
												</div>
											</div>
										</div>
									</div>
								</div>
							</div>

							<div class="col-lg-12">
								<div class="form-group">
									<label for="currency">@lang('Currency')</label>
									<div class="input-group">
										<select name="currency" id="currency" required class="form-control">
											<option value="NGN">@lang('NGN')</option>
											<option value="USDT">@lang('USDT')</option>
										</select>
									</div>
								</div>
							</div>

                            <div class="col-lg-12">
                                <div class="form-group">
                                    <label for="descr">@lang('Description')</label>
                                    <textarea type="text" name="content" class="form-control" id="descr" required></textarea>
                                </div>
                            </div>

                        </div>

                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn--dark" data-dismiss="modal">@lang('Close')</button>
                        <button type="submit" class="btn btn--primary">@lang('Save')</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    {{-- ADD METHOD MODAL --}}
    <div id="editModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">@lang('Edit Task')</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form action="{{ route('admin.tasks.edit') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    <input type="hidden" name="id" required>

                    <div class="modal-body">

                        <div class="row">
							<div class="col-md-5">
								<div class="form-group">
									<label>Picture</label>
									<div class="image-upload">
										<div class="thumb">
											<div class="avatar-preview">
												<div class="profilePicPreview imageModalUpdate" style="height:200px;">
													<button type="button" class="remove-image"><i class="fa fa-times"></i></button>
												</div>
											</div>
											<div class="avatar-edit">
												<input type="file" class="profilePicUpload" name="image" style="padding: 0px 0px" id="uploadsImage" accept=".png, .jpg, .jpeg" />
												<label for="uploadsImage" class="bg--success">Icon</label>
												<small class="mt-2 text-facebook">@lang('Supported files:') <b>jpeg, jpg, png</b>.
													| @lang('Will be resized to:') <b>{{imagePath()['products']['size']}}</b> px.
												</small>
											</div>
										</div>
									</div>
								</div>
							</div>
                            <div class="col-lg-7">
								<div class="row">
									<div class="col-lg-12">
										<div class="form-group">
											<label for="edit_name">@lang('Name')</label>
											<input type="text" name="name" class="form-control" id="edit_name" required>
										</div>
									</div>
									<div class="col-lg-12">
										<div class="form-group">
											<label for="edit_url">@lang('Link')</label>
											<input type="url" name="url" class="form-control" id="edit_url" required placeholder="http://">
										</div>
									</div>

									<div class="col-lg-12">
										<div class="form-group">
											<label for="edit_status">@lang('Status')</label>
											<select name="status" id="edit_status" class="form-control" required>
												<option value="1">@lang('Enable')</option>
												<option value="0">@lang('Disable')</option>
											</select>
										</div>
									</div>

									<div class="col-lg-12">
										<div class="form-group">
											<label for="edit_amount">@lang('Amount')</label>
											<div class="input-group">
												<input type="text" name="amount" onkeyup="this.value = this.value.replace (/^\.|[^\d\.]/g, '')" id="edit_amount" class="form-control" required>
												<div class="input-group-append">
													<span class="input-group-text">{{ __(config('settings')->cur_text) }}</span>
												</div>
											</div>
										</div>
									</div>
								</div>
							</div>

							<div class="col-lg-12">
								<div class="form-group">
									<label for="edit_currency">@lang('Currency')</label>
									<div class="input-group">
										<select name="currency" id="edit_currency" required class="form-control">
											<option value="NGN">@lang('NGN')</option>
											<option value="USDT">@lang('USDT')</option>
										</select>
									</div>
								</div>
							</div>

                            <div class="col-lg-12">
                                <div class="form-group">
                                    <label for="edit_descr">@lang('Description')</label>
                                    <textarea type="text" name="content" class="form-control" id="edit_descr" required></textarea>
                                </div>
                            </div>

                        </div>

                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn--dark" data-dismiss="modal">@lang('Close')</button>
                        <button type="submit" class="btn btn--primary">@lang('Update')</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

@endsection

@push('breadcrumb-plugins')
    <a href="javascript:void(0)" class="btn btn-sm btn--primary box--shadow1 text-white text--small addBtn"><i class="fa fa-fw fa-plus"></i>@lang('Add New')</a>
@endpush

@push('script')
    <script>
        (function ($) {

            "use strict";

            $('.addBtn').on('click', (e)=> {
                var modal = $('#addModal');
                modal.modal('show');
            });

            $('.editBtn').on('click', (e)=> {
                var $this = $(e.currentTarget);
                var modal = $('#editModal');
				var resource = $this.data('resource');

                modal.find('input[name=id]').val(resource.id);
                modal.find('input[name=name]').val(resource.name);
                modal.find('textarea[name=content]').val(resource.content);
                modal.find('select[name=status]').val(resource.status);
                modal.find('input[name=url]').val(resource.url);
                modal.find('input[name=amount]').val(parseFloat(resource.amount).toFixed(2));
                modal.find('select[name=currency]').val(resource.currency);

				modal.find('.profilePicPreview').css('background-image', "url(/assets/" + resource.image +')');

                modal.modal('show');
            });

        })(jQuery);

    </script>
@endpush
