@extends('admin.layouts.app')
@section('panel')
<div class="row mb-none-30">
    <div class="col-lg-12 col-md-12 mb-30">
        <div class="card">
            <div class="card-body">
                <form action="" method="POST">
                    @csrf
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group ">
                                <label class="form-control-label font-weight-bold"> @lang('Site Title') </label>
                                <input class="form-control form-control-lg" type="text" name="sitename" value="{{config('settings')->sitename}}">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group ">
                                <label class="form-control-label font-weight-bold">@lang('Currency')</label>
                                <input class="form-control form-control-lg" type="text" name="cur_text" value="{{config('settings')->cur_text}}">
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group ">
                                <label class="form-control-label font-weight-bold">@lang('Currency Symbol') </label>
                                <input class="form-control form-control-lg" type="text" name="cur_sym" value="{{config('settings')->cur_sym}}">
                            </div>
                        </div>
                    </div>

					<div class="row">
						<div class="col-md-4">
							<div class="form-group ">
								<label class="form-control-label font-weight-bold"> @lang('Account Name') </label>
								<input class="form-control form-control-lg" type="text" name="account_name" value="{{config('settings')->account_name}}">
							</div>
						</div>
						<div class="col-md-4">
							<div class="form-group ">
								<label class="form-control-label font-weight-bold">@lang('Account Number')</label>
								<input class="form-control form-control-lg" type="text" name="account_number" value="{{config('settings')->account_number}}">
							</div>
						</div>

						<div class="col-md-4">
							<div class="form-group ">
								<label class="form-control-label font-weight-bold">@lang('Bank Name') </label>
								<input class="form-control form-control-lg" type="text" name="bank_name" value="{{config('settings')->bank_name}}">
							</div>
						</div>
					</div>

					<input class="form-control form-control-lg" type="hidden" name="usdt_address" value="{{config('settings')->usdt_address}}">
					<input class="form-control form-control-lg" type="hidden" name="usdt_bep20" value="{{config('settings')->usdt_bep20}}">
					<input class="form-control form-control-lg" type="hidden" name="usdt_binance_id" value="{{config('settings')->usdt_binance_id}}">

                    <div class="row">
                        <div class="form-group col-md-3">
                            <label class="form-control-label font-weight-bold"> @lang('Timezone')</label>
                            <select class="select2-basic" name="timezone">
                                @foreach($timezones as $timezone)
                                <option value="'{{ @$timezone}}'" @if(config('app.timezone')==$timezone) selected @endif>{{ __($timezone) }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group col-md-3">
                            <label class="form-control-label font-weight-bold"> @lang('Site Base Color')</label>
                            <div class="input-group">
                                <span class="input-group-addon ">
                                    <input type='text' class="form-control form-control-lg colorPicker" value="{{config('settings')->base_color}}" />
                                </span>
                                <input type="text" class="form-control form-control-lg colorCode" name="base_color" value="{{ config('settings')->base_color }}" />
                            </div>
                        </div>
                        <div class="form-group col-md-3">
                            <label class="form-control-label font-weight-bold"> @lang('Site Secondary Color')</label>
                            <div class="input-group">
                                <span class="input-group-addon">
                                    <input type='text' class="form-control form-control-lg colorPicker" value="{{config('settings')->secondary_color}}" />
                                </span>
                                <input type="text" class="form-control form-control-lg colorCode" name="secondary_color" value="{{ config('settings')->secondary_color }}" />
                            </div>
                        </div>
                        <div class="form-group col-md-3">
                            <label class="form-control-label font-weight-bold">@lang('Agree policy')</label>
                            <input type="checkbox" data-width="100%" data-size="large" data-onstyle="-success" data-offstyle="-danger" data-toggle="toggle" data-on="@lang('Enable')" data-off="@lang('Disabled')" name="agree" @if(config('settings')->agree) checked @endif>
                        </div>
                    </div>
                    <div class="row">
                        <div class="form-group col-md-2">
                            <label class="form-control-label font-weight-bold">@lang('User Registration')</label>
                            <input type="checkbox" data-width="100%" data-size="large" data-onstyle="-success" data-offstyle="-danger" data-toggle="toggle" data-on="@lang('Enable')" data-off="@lang('Disabled')" name="registration" @if(config('settings')->registration) checked @endif>
                        </div>

                        <div class="form-group col-md-2">
                            <label class="form-control-label font-weight-bold">@lang('Registration Bonus')</label>
							<input type="number" name="welcome_bonus" value="{{ config('settings')->welcome_bonus }}" class="form-control form-control-lg">
                        </div>

                        <div class="form-group col-md-2">
                            <label class="form-control-label font-weight-bold">@lang('Force SSL')</label>
                            <input type="checkbox" data-width="100%" data-size="large" data-onstyle="-success" data-offstyle="-danger" data-toggle="toggle" data-on="@lang('Enable')" data-off="@lang('Disabled')" name="force_ssl" @if(config('settings')->force_ssl) checked @endif>
                        </div>
                        <div class="form-group col-lg-2 col-sm-6 col-md-4">
                            <label class="form-control-label font-weight-bold"> @lang('Email Verification')</label>
                            <input type="checkbox" data-width="100%" data-size="large" data-onstyle="-success" data-offstyle="-danger" data-toggle="toggle" data-on="@lang('Enable')" data-off="@lang('Disable')" name="ev" @if(config('settings')->ev) checked @endif>
                        </div>
                        <div class="form-group col-lg-2 col-sm-6 col-md-4">
                            <label class="form-control-label font-weight-bold">@lang('Email Notification')</label>
                            <input type="checkbox" data-width="100%" data-size="large" data-onstyle="-success" data-offstyle="-danger" data-toggle="toggle" data-on="@lang('Enable')" data-off="@lang('Disable')" name="en" @if(config('settings')->en) checked @endif>
                        </div>
                        <div class="form-group col-lg-2 col-sm-6 col-md-4">
                            <label class="form-control-label font-weight-bold"> @lang('SMS Verification')</label>
                            <input type="checkbox" data-width="100%" data-size="large" data-onstyle="-success" data-offstyle="-danger" data-toggle="toggle" data-on="@lang('Enable')" data-off="@lang('Disable')" name="sv" @if(config('settings')->sv) checked @endif>
                        </div>
                        <div class="form-group col-lg-2 col-sm-6 col-md-4">
                            <label class="form-control-label font-weight-bold">@lang('SMS Notification')</label>
                            <input type="checkbox" data-width="100%" data-size="large" data-onstyle="-success" data-offstyle="-danger" data-toggle="toggle" data-on="@lang('Enable')" data-off="@lang('Disable')" name="sn" @if(config('settings')->sn) checked @endif>
                        </div>
                        <div class="form-group col-lg-2 col-sm-6 col-md-4">
                            <label class="form-control-label font-weight-bold">@lang('Auto Deposit')</label>
                            <input type="checkbox" data-width="100%" data-size="large" data-onstyle="-success" data-offstyle="-danger" data-toggle="toggle" data-on="@lang('Enable')" data-off="@lang('Disable')" name="auto_deposit" @if(config('settings')->auto_deposit) checked @endif>
                        </div>
                        <div class="form-group col-lg-2 col-sm-6 col-md-4">
                            <label class="form-control-label font-weight-bold">@lang('Auto Payout')</label>
                            <input type="checkbox" data-width="100%" data-size="large" data-onstyle="-success" data-offstyle="-danger" data-toggle="toggle" data-on="@lang('Enable')" data-off="@lang('Disable')" name="auto_transfer" @if(config('settings')->auto_transfer) checked @endif>
                        </div>
                        <div class="form-group col-lg-2 col-sm-6 col-md-4">
                            <label class="form-control-label font-weight-bold">@lang('Telegram Share Link')</label>
                            <input type="checkbox" data-width="100%" data-size="large" data-onstyle="-success" data-offstyle="-danger" data-toggle="toggle" data-on="@lang('Enable')" data-off="@lang('Disable')" name="enable_telegram_share" @if(config('settings')->enable_telegram_share) checked @endif>
                        </div>
                        <div class="form-group col-lg-2 col-sm-6 col-md-4">
                            <label class="form-control-label font-weight-bold">@lang('Whatsapp Share Link')</label>
                            <input type="checkbox" data-width="100%" data-size="large" data-onstyle="-success" data-offstyle="-danger" data-toggle="toggle" data-on="@lang('Enable')" data-off="@lang('Disable')" name="enable_whatsapp_share" @if(config('settings')->enable_whatsapp_share) checked @endif>
                        </div>
                        <div class="form-group col-lg-2 col-sm-6 col-md-4">
                            <label class="form-control-label font-weight-bold">@lang('Reward')</label>
                            <input type="checkbox" data-width="100%" data-size="large" data-onstyle="-success" data-offstyle="-danger" data-toggle="toggle" data-on="@lang('Enable')" data-off="@lang('Disable')" name="reward" @if(config('settings')->reward) checked @endif>
                        </div>
                        {{--<div class="form-group col-lg-2 col-sm-6 col-md-4">
                            <label class="form-control-label font-weight-bold">@lang('Reward Claim Button')</label>
                            <input type="checkbox" data-width="100%" data-size="large" data-onstyle="-success" data-offstyle="-danger" data-toggle="toggle" data-on="@lang('Enable')" data-off="@lang('Disable')" name="reward_claim_active" @if(config('settings')->reward_claim_active) checked @endif>
                        </div>--}}
                        <div class="form-group col-lg-2 col-sm-6 col-md-4">
                            <label class="form-control-label font-weight-bold">@lang('Enable Withdrawal')</label>
                            <input type="checkbox" data-width="100%" data-size="large" data-onstyle="-success" data-offstyle="-danger" data-toggle="toggle" data-on="@lang('Enable')" data-off="@lang('Disable')" name="withdrawal_active" @if(config('settings')->withdrawal_active) checked @endif>
                        </div>

                        <div class="form-group col-lg-3 col-sm-6 col-md-4">
                            <label class="form-control-label font-weight-bold">@lang('Use 8-10 Withdraw Time')</label>
                            <input type="checkbox" data-width="100%" data-size="large" data-onstyle="-success" data-offstyle="-danger" data-toggle="toggle" data-on="@lang('Enable')" data-off="@lang('Disable')" name="withdraw_time" @if(config('settings')->withdraw_time) checked @endif>
                        </div>

                        <div class="form-group col-lg-3 col-sm-6 col-md-4">
                            <label class="form-control-label font-weight-bold">@lang('Once Withdrawal A-day')</label>
                            <input type="checkbox" data-width="100%" data-size="large" data-onstyle="-success" data-offstyle="-danger" data-toggle="toggle" data-on="@lang('Enable')" data-off="@lang('Disable')" name="once_withdrawal_aday" @if(config('settings')->once_withdrawal_aday) checked @endif>
                        </div>

						<div class="form-group col-lg-4 col-sm-6 col-md-4">
							<label for="">Commission Type</label>
							<select name="commission_type" class="form-control form-control-lg">
								<option value="referral" @if(config('settings')->commission_type == "referral") selected @endif>Referral</option>
								<option value="rebate" @if(config('settings')->commission_type == "rebate") selected @endif>Rebate</option>
								<option value="both" @if(config('settings')->commission_type == "both") selected @endif>Both</option>
							</select>
						</div>

                    </div>

					<div class="row">
						<div class="form-group col-lg-4 col-sm-6 col-md-4">
							<label for="">Withdraw Method</label>
							<select name="auto_transfer_default" class="form-control form-control-lg">
								<option value="shpay" @if(config('settings')->auto_transfer_default == "shpay") selected @endif>Shpay</option>
								<option value="gtr" @if(config('settings')->auto_transfer_default == "gtr") selected @endif>GTR Pay</option>
								<option value="ppay" @if(config('settings')->auto_transfer_default == "ppay") selected @endif>PPAY PRO</option>
								<option value="otpay" @if(config('settings')->auto_transfer_default == "otpay") selected @endif>OT Pay</option>
								<option value="flutter" @if(config('settings')->auto_transfer_default == "flutter") selected @endif>Flutter Wave</option>
								<option value="wkpay" @if(config('settings')->auto_transfer_default == "wkpay") selected @endif>WK Pay</option>
							</select>
						</div>

						<div class="form-group col-lg-4 col-sm-6 col-md-4">
							<label for="">Withdrawal Debit From</label>
							<select name="debit_with" class="form-control form-control-lg">
								<option value="both" @if(config('settings')->debit_with == "both") selected @endif>Both (Deposited or Income Balance)</option>
								<option value="balance" @if(config('settings')->debit_with == "balance") selected @endif>Deposited Balance</option>
								<option value="income" @if(config('settings')->debit_with == "income") selected @endif>Income Balance</option>
							</select>
						</div>

						<div class="form-group col-lg-4 col-sm-6 col-md-4">
							<label for="">@lang('Gift Free Package')</label>
							<select name="free_package" value="{{ config('settings')->free_package }}" class="form-control form-control-lg" required>
								<option>Select an option</option>
								<option value="1" @if(config('settings')->free_package == 1) selected @endif>@lang('Enable')</option>
								<option value="0" @if(config('settings')->free_package == 0) selected @endif>@lang('Disable')</option>
							</select>
						</div>

					</div>

                    <div class="row">
						<div class="form-group col-lg-4 col-sm-6 col-md-4">
							<label class="form-control-label font-weight-bold">@lang('Use Link Bonus')</label>
							<input type="checkbox" data-width="100%" data-size="large" data-onstyle="-success"
								   data-offstyle="-danger" data-toggle="toggle" data-on="Enable" data-off="Disabled"
								   name="use_link_bonus" @if(config('settings')->use_link_bonus) checked @endif>
						</div>

						<div class="form-group col-lg-4 col-sm-6 col-md-4">
							<label class="form-control-label font-weight-bold">@lang('Use Link Bonus Amount') </label>
							<div class="input-group">
								<input class="form-control  form-control-lg" type="text" name="use_link_amount"
								   value="{{config('settings')->use_link_amount}}">
								   <div class="input-group-append">
									   <span class="input-group-text">{{ config('settings')->cur_text }}</span>
								   </div>
							</div>
						</div>

						<div class="form-group col-lg-4 col-sm-6 col-md-4">
							<label class="form-control-label font-weight-bold">@lang('Use Link Redeem percent') </label>
							<div class="input-group">
								<input class="form-control form-control-lg" min="1" max="100" type="number" name="use_link_redeem_percent"
								   value="{{getAmount(config('settings')->use_link_redeem_percent)}}">
								   <div class="input-group-append">
									   <span class="input-group-text">%</span>
								   </div>
							</div>
						</div>

						<div class="form-group col-lg-4 col-sm-6 col-md-4">
							<label for="">Daily Login Reward</label>
							<input type="number" name="reward_login" value="{{ config('settings')->reward_login }}" class="form-control form-control-lg">
						</div>

                        <div class="form-group col-lg-3 col-sm-6 col-md-4">
                            <label class="form-control-label font-weight-bold">@lang('General Buy Limit')</label>
                            <input type="checkbox" data-width="100%" data-size="large" data-onstyle="-success" data-offstyle="-danger" data-toggle="toggle" data-on="@lang('Enable')" data-off="@lang('Disable')" name="buy_limit" @if(config('settings')->buy_limit) checked @endif>
                        </div>

						<div class="form-group col-lg-4 col-sm-6 col-md-4">
							<label for="">@lang('Buy Limit Type')</label>
							<select name="buy_limit_type" value="{{ config('settings')->buy_limit_type }}" class="form-control form-control-lg" required>
								<option value="1">@lang('Per Day')</option>
								<option value="0">@lang('Anytime')</option>
							</select>
						</div>

						<div class="form-group col-lg-4 col-sm-6 col-md-4">
							<label for="">@lang('Buy Limit Count')</label>
							<div class="input-group">
								<input type="number"  name="limit_buy" value="{{ config('settings')->limit_buy }}" class="form-control" required>
								<div class="input-group-append">
								<span class="input-group-text">
									@lang('Times')
								</span>
								</div>
							</div>
						</div>

						<div class="form-group col-lg-4 col-sm-6 col-md-4">
							<label for="">NGN to USD Rate</label>
							<input type="text" name="ngn_to_usdt" value="{{ config('settings')->ngn_to_usdt }}" class="form-control form-control-lg">
						</div>

						<div class="form-group col-lg-4 col-sm-6 col-md-4">
							<label for="">USDT to NGN Rate</label>
							<input type="text" name="usdt_to_ngn" value="{{ config('settings')->usdt_to_ngn }}" class="form-control form-control-lg">
						</div>

						<div class="form-group col-lg-4 col-sm-6 col-md-4">
							<label for="">NGN to USD Fee</label>
							<input type="text" name="ngn_to_usdt_fee" value="{{ config('settings')->ngn_to_usdt_fee }}" class="form-control form-control-lg">
						</div>

						<div class="form-group col-lg-4 col-sm-6 col-md-4">
							<label for="">USDT to NGN Fee</label>
							<input type="text" name="usdt_to_ngn_fee" value="{{ config('settings')->usdt_to_ngn_fee }}" class="form-control form-control-lg">
						</div>

						<div class="form-group col-lg-4 col-sm-6 col-md-4">
							<label for="">@lang('Active Template')</label>
							<select name="active_template" value="{{ config('settings')->active_template }}" class="form-control form-control-lg" required>
								@foreach( config('template.views') as $view )
								<option value="{{$view}}" @if(config('settings')->active_template == $view) selected @endif>{{strtoupper($view)}}</option>
								@endforeach
							</select>
						</div>

						<div class="form-group col-lg-4 col-sm-6 col-md-4">
							<label for="">Mobile App Link</label>
							<input type="url" name="app_link" value="{{ config('settings')->app_link }}" class="form-control form-control-lg">
						</div>
					</div>


                    <div class="form-group">
                        <label for="">Telegram Link</label>
                        <input type="url" name="telegram_url" value="{{ config('settings')->telegram_url }}" class="form-control form-control-lg">
                    </div>

                    <div class="form-group">
                        <label for="">Whatsapp Link</label>
                        <input type="url" name="whatsapp_url" value="{{ config('settings')->whatsapp_url }}" class="form-control form-control-lg">
                    </div>

                    <div class="form-group">
                        <label for="">X [twitter] Handle</label>
                        <input type="url" name="x_handle" value="{{ config('settings')->x_handle }}" class="form-control form-control-lg">
                    </div>

                    <div class="form-group">
                        <label for="">Telegram Support line</label>
                        <input type="text" name="telegram_number" value="{{ config('settings')->telegram_number }}" class="form-control form-control-lg">
                    </div>

                    <div class="form-group">
                        <label for="">Whatsapp Support line</label>
                        <input type="text" name="whatsapp_number" value="{{ config('settings')->whatsapp_number }}" class="form-control form-control-lg">
                    </div>


					<div class="row">
						<div class="form-group col-md-12">
							<label class="form-control-label font-weight-bold">@lang('Telegram Notification')</label>
							<input type="checkbox" data-width="100%" data-size="large" data-onstyle="-success" data-offstyle="-danger" data-toggle="toggle" data-on="@lang('Enable')" data-off="@lang('Disabled')" name="enable_telegram" @if(config('settings')->enable_telegram) checked @endif>
						</div>
					</div>

					<div class="row">
						<div class="col-md-6">
							<div class="form-group ">
								<label class="form-control-label font-weight-bold"> @lang('Telegram Chat ID') </label>
								<input class="form-control form-control-lg" type="text" name="telegram_chat_id" value="{{config('settings')->telegram_chat_id}}">
							</div>
						</div>
						<div class="col-md-6">
							<div class="form-group ">
								<label class="form-control-label font-weight-bold">@lang('Telegram API Token')</label>
								<input class="form-control form-control-lg" type="text" name="telegram_api_token" value="{{config('settings')->telegram_api_token}}">
							</div>
						</div>
					</div>

                    <div class="form-group">
                        <button type="submit" class="btn btn--primary btn-block btn-lg">@lang('Update')</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

@push('script-lib')
<script src="{{ asset('assets/admin/js/spectrum.js') }}"></script>
@endpush

@push('style-lib')
<link rel="stylesheet" href="{{ asset('assets/admin/css/spectrum.css') }}">
@endpush


@push('style')
<style>
    .sp-replacer {
        padding: 0;
        border: 1px solid rgba(0, 0, 0, .125);
        border-radius: 5px 0 0 5px;
        border-right: none;
    }

    .sp-preview {
        width: 100px;
        height: 46px;
        border: 0;
    }

    .sp-preview-inner {
        width: 110px;
    }

    .sp-dd {
        display: none;
    }

    .select2-container .select2-selection--single {
        height: 44px;
    }

    .select2-container--default .select2-selection--single .select2-selection__rendered {
        line-height: 43px;
    }

    .select2-container--default .select2-selection--single .select2-selection__arrow {
        height: 43px;
    }
</style>
@endpush

@push('script')
<script>
    (function($) {
        "use strict";
        $('.colorPicker').spectrum({
            color: $(this).data('color'),
            change: function(color) {
                $(this).parent().siblings('.colorCode').val(color.toHexString().replace(/^#?/, ''));
            }
        });

        $('.colorCode').on('input', function() {
            var clr = $(this).val();
            $(this).parents('.input-group').find('.colorPicker').spectrum({
                color: clr,
            });
        });

        $('.select2-basic').select2({
            dropdownParent: $('.card-body')
        });

        $('select[name=timezone]').val();
    })(jQuery);
</script>
@endpush
