@extends('admin.layouts.app')

@section('panel')
    <div class="row">

        <div class="col-lg-12">

            <div class="card b-radius--10 ">
                <div class="card-body p-0">
                    <div class="table-responsive--sm table-responsive">
                        <table class="table table--light style--two">
                            <thead>
                            <tr>
                                <th>@lang('Method')</th>
                                <th>@lang('Currency')</th>
                                <th>@lang('Charge')</th>
                                <th>@lang('Withdraw Limit')</th>
                                <th>@lang('Processing Time') </th>
                                <th>@lang('Status')</th>
                                <th>@lang('Action')</th>
                            </tr>
                            </thead>
                            <tbody>
                            @forelse($methods as $method)
                                <tr>
                                    <td data-label="@lang('Method')">
                                        <div class="user">
                                            <div class="thumb"><img src="{{ getImage(imagePath()['withdraw']['method']['path'].'/'. $method->image,imagePath()['withdraw']['method']['size'])}}" alt="@lang('image')" /></div>

                                            <span class="name">{{__($method->name)}}</span>
                                        </div>
                                    </td>

                                    <td data-label="@lang('Currency')"
                                        class="font-weight-bold">{{ __($method->currency) }}</td>
                                    <td data-label="@lang('Charge')"
                                        class="font-weight-bold">{{ showAmount($method->fixed_charge)}} {{__($method->currency) }} {{ (0 < $method->percent_charge) ? ' + '. showAmount($method->percent_charge) .' %' : '' }} </td>
                                    <td data-label="@lang('Withdraw Limit')"
                                        class="font-weight-bold">{{ $method->min_limit + 0 }}
                                        - {{ $method->max_limit + 0 }} {{__($method->currency) }}</td>
                                    <td data-label="@lang('Processing Time')">{{ $method->delay }}</td>
                                    <td data-label="@lang('Status')">
                                        @if($method->status == 1)
                                            <span class="text--small badge font-weight-normal badge--success">@lang('Active')</span>
                                        @else
                                            <span class="text--small badge font-weight-normal badge--warning">@lang('Disabled')</span>
                                        @endif
                                    </td>
                                    <td data-label="@lang('Action')">
                                        <a href="{{ route('admin.withdraw.method.edit', $method->id)}}"
                                           class="icon-btn ml-1" data-toggle="tooltip" data-original-title="@lang('Edit')"><i class="las la-pen"></i></a>
                                        @if($method->status == 1)
                                            <a href="javascript:void(0)" class="icon-btn btn--danger deactivateBtn  ml-1" data-toggle="tooltip" data-original-title="@lang('Disable')" data-id="{{ $method->id }}" data-name="{{ __($method->name) }}">
                                                <i class="la la-eye-slash"></i>
                                            </a>
                                        @else
                                            <a href="javascript:void(0)" class="icon-btn btn--success activateBtn  ml-1"
                                               data-toggle="tooltip" data-original-title="@lang('Enable')"
                                               data-id="{{ $method->id }}" data-name="{{ __($method->name) }}">
                                                <i class="la la-eye"></i>
                                            </a>
                                        @endif
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td class="text-muted text-center" colspan="100%">{{ __($emptyMessage) }}</td>
                                </tr>
                            @endforelse

                            </tbody>
                        </table><!-- table end -->
                    </div>
                </div>
            </div><!-- card end -->
        </div>
		
        <div class="col-lg-12 pt-5">
            <div class="card b-radius--10 p-1">
                <div class="card-body p-0">

					<form action="{{ route('admin.settings.autopay') }}" method="POST">
						@csrf
						<div class="card-body">
							<div class="form-row">
								<div class="form-group col-md-6">
									<label class="mb-4">@lang('Auto Withdraw Pay')</label>
									<select name="auto_pay" class="form-control" >
										<option value="0" @if(config('settings')->payout_config->auto_pay == '0') selected @endif>@lang('Disabled [OFF]')</option>
										<option value="oxapay" @if(config('settings')->payout_config->auto_pay == 'oxapay') selected @endif>@lang('Oxapay [CRYPTO]')</option>
										<option value="flutterwave" @if(config('settings')->payout_config->auto_pay == 'flutterwave') selected @endif>@lang('Flutterwave [NGN]')</option>
										<option value="paystack" @if(config('settings')->payout_config->auto_pay == 'paystack') selected @endif>@lang('Paystack [NGN]')</option>
										<option value="gtrpay" @if(config('settings')->payout_config->auto_pay == 'gtrpay') selected @endif>@lang('Gtrpay [NGN]')</option>
										<option value="nowpay" @if(config('settings')->payout_config->auto_pay == 'nowpay') selected @endif>@lang('Nowpayment [CRYPTO]')</option>
									</select>
								</div>
								<div class="form-group col-md-6 text-right">
									<h6 class="mb-4">&nbsp;</h6>
									<button type="button" data-target="#testMailModal" data-toggle="modal" class="btn btn--info">@lang('Make Test Payment')</button>
								</div>
							</div>
							<div class="form-row mt-4 d-none configForm" id="oxapay">
								<div class="col-md-12">
									<h6 class="mb-2">@lang('Oxapay API Configuration')</h6>
								</div>
								<div class="form-group col-md-12">
									<label>@lang('Payout API KEY') <span class="text-danger">*</span></label>
									<input type="text" class="form-control" placeholder="@lang('Oxapay Api key')" name="app_key" value="{{ config('settings')->payout_config->app_key ?? '' }}"/>
								</div>
							</div>
							<div class="form-row mt-4 d-none configForm" id="flutterwave">
								<div class="col-md-12">
									<h6 class="mb-2">@lang('Flutter-wave API Configuration')</h6>
								</div>
								<div class="form-group col-md-6">
									<label class="font-weight-bold">@lang('Api Public Key') <span class="text-danger">*</span></label>
									<input type="text" class="form-control" placeholder="@lang('Flutter-wave Api Public Key')" name="flu_public_key" value="{{ config('settings')->payout_config->flu_public_key ?? '' }}"/>
								</div>
								<div class="form-group col-md-6">
									<label class="font-weight-bold">@lang('Api Secret Key') <span class="text-danger">*</span></label>
									<input type="text" class="form-control" placeholder="@lang('Flutter-wave Api Secret Key')" name="flu_secret_key" value="{{ config('settings')->payout_config->flu_secret_key ?? '' }}"/>
								</div>
								<div class="form-group col-md-12">
									<label class="font-weight-bold">@lang('Encryption Key') <span class="text-danger">*</span></label>
									<input type="text" class="form-control" placeholder="@lang('Provide Encryption Key')" name="flu_encryption_key" value="{{ config('settings')->payout_config->flu_encryption_key ?? '' }}"/>
								</div>
							</div>
							<div class="form-row mt-4 d-none configForm" id="paystack">
								<div class="col-md-12">
									<h6 class="mb-2">@lang('Paystack API Configuration')</h6>
								</div>
								<div class="form-group col-md-6">
									<label class="font-weight-bold">@lang('Public Key') <span class="text-danger">*</span></label>
									<input type="text" class="form-control" placeholder="@lang('Api Public Key')" name="py_public_key" value="{{ config('settings')->payout_config->py_public_key ?? '' }}"/>
								</div>
								<div class="form-group col-md-6">
									<label class="font-weight-bold">@lang('Secret Key') <span class="text-danger">*</span></label>
									<input type="text" class="form-control" placeholder="@lang('Api Secret Key')" name="py_secret_key" value="{{ config('settings')->payout_config->py_secret_key ?? '' }}"/>
								</div>
							</div>
							<div class="form-row mt-4 d-none configForm" id="gtrpay">
								<div class="col-md-12">
									<h6 class="mb-2">@lang('GTRPay API Configuration')</h6>
								</div>
								<div class="form-group col-md-6">
									<label class="font-weight-bold">@lang('Merchant ID') <span class="text-danger">*</span></label>
									<input type="text" class="form-control" placeholder="@lang('Merchant ID')" name="merchant_id" value="{{ config('settings')->payout_config->merchant_id ?? '' }}"/>
								</div>
								<div class="form-group col-md-6">
									<label class="font-weight-bold">@lang('APP ID')</label>
									<input type="text" class="form-control" placeholder="@lang('Application ID')" name="app_id" value="{{ config('settings')->payout_config->app_id ?? '' }}"/>
								</div>
								<div class="form-group col-md-12">
									<label class="font-weight-bold" style="width: 100%;">@lang('Secret Key') </label>
									<input type="text" class="form-control" placeholder="@lang('App Secret Key')" name="merchant_key" value="{{ config('settings')->payout_config->merchant_key ?? '' }}"/>
								</div>
							</div>
							<div class="form-row mt-4 d-none configForm" id="nowpay">
								<div class="col-md-12">
									<h6 class="mb-2">@lang('Nowpayment API Configuration')</h6>
								</div>
								<div class="form-group col-md-6">
									<label class="font-weight-bold">@lang('API KEY') <span class="text-danger">*</span></label>
									<input type="text" class="form-control" placeholder="@lang('API KEY')" name="now_api_key" value="{{ config('settings')->payout_config->now_api_key ?? '' }}"/>
								</div>
								<div class="form-group col-md-6">
									<label class="font-weight-bold">@lang('Secret Key')</label>
									<input type="text" class="form-control" placeholder="@lang('Secret Key')" name="now_secret_key" value="{{ config('settings')->payout_config->now_secret_key ?? '' }}"/>
								</div>
								<div class="form-group col-md-12">
									<label class="font-weight-bold" style="width: 100%;">@lang('Domain Link') <span class="text-danger" style="float:right">e.g(support.{{request()->getHttpHost()}})</span></label>
									<input type="text" class="form-control" placeholder="@lang('Domain name')" name="now_host" value="{{ config('settings')->payout_config->now_host ?? '' }}"/>
								</div>
							</div>
						</div>

						<div class="card-footer">
							<button type="submit" class="btn btn-block btn--primary mr-2">@lang('Update')</button>
						</div>
					</form>
				
                </div>
            </div><!-- card end -->
        </div>

        <div class="col-lg-12">
			<div class="card bl--5-primary mt-3">
				<form class="card-body" method="post" action="" style="padding: 0.35rem;">
					@csrf
					<div style="float:right">
						<select name="payname" required>
							<option value="">Select option</option>
							@foreach($gCurrency as $data)
							<option value="{{$data->alias}}" {{ (config('settings')->auto_transfer_default == $data->alias) ? 'selected':'' }} >{{$data->alias}}</option>
							@endforeach
						</select>
						<button type="submit" class="icon-btn btn--success form-control-lg">GO</button>
					</div>
					<p style="margin-top: 6px;">Set autopay option</p>
				</form>
			</div>
		</div>
    </div>


    {{-- ACTIVATE METHOD MODAL --}}
    <div id="activateModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">@lang('Withdrawal Method Activation Confirmation')</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form action="{{ route('admin.withdraw.method.activate') }}" method="POST">
                    @csrf
                    <input type="hidden" name="id">
                    <div class="modal-body">
                        <p>@lang('Are you sure to activate') <span class="font-weight-bold method-name"></span> @lang('method')?</p>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn--dark" data-dismiss="modal">@lang('Close')</button>
                        <button type="submit" class="btn btn--primary">@lang('Activate')</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    {{-- DEACTIVATE METHOD MODAL --}}
    <div id="deactivateModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">@lang('Withdrawal Method Disable Confirmation')</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form action="{{ route('admin.withdraw.method.deactivate') }}" method="POST">
                    @csrf
                    <input type="hidden" name="id">
                    <div class="modal-body">
                        <p>@lang('Are you sure to disable') <span class="font-weight-bold method-name"></span> @lang('method')?</p>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn--dark" data-dismiss="modal">@lang('Close')</button>
                        <button type="submit" class="btn btn--danger">@lang('Disable')</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

@endsection



@push('breadcrumb-plugins')
    <a class="btn btn-sm btn--primary box--shadow1 text--small" href="{{ route('admin.withdraw.method.create') }}"><i class="fa fa-fw fa-plus"></i>@lang('Add New')</a>
@endpush


@push('script')
    <script>
        (function ($) {
            "use strict";
            $('.activateBtn').on('click', function () {
                var modal = $('#activateModal');
                modal.find('.method-name').text($(this).data('name'));
                modal.find('input[name=id]').val($(this).data('id'));
                modal.modal('show');
            });

            $('.deactivateBtn').on('click', function () {
                var modal = $('#deactivateModal');
                modal.find('.method-name').text($(this).data('name'));
                modal.find('input[name=id]').val($(this).data('id'))
                modal.modal('show');
            });

            var method = '{{ config('settings')->payout_config->auto_pay }}';
            $('select[name=auto_pay]').on('change', function() {
                var method = $(this).val();
                emailMethod(method);
            });

            function emailMethod(method){
                $('.configForm').addClass('d-none');
                if(method != '0') {
                    $(`#${method}`).removeClass('d-none');
                }
            }
            emailMethod(method);
			
        })(jQuery);
    </script>

@endpush
