<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">


  <title>@if(View::hasSection('pageTitle')) @yield('pageTitle') @else {{ config('settings')->sitename(__($pageTitle)) }} @endif</title>
  <link rel="shortcut icon" type="image/x-icon" href="{{ asset('users/assets/app') }}/img/favicon.png" />
  <link rel="stylesheet" href="{{ asset('users/assets/app') }}/css/style.css" >
  <link rel="stylesheet" href="{{ asset('users/assets/app') }}/css/mui.min.css">
  <link rel="stylesheet" href="{{ asset('users/assets/app') }}/css/mui.loading.css" >
  <script src="{{ asset('users/assets/app') }}/js/jquery-3.4.1.min.js"></script>
  <script src="https://code.iconify.design/iconify-icon/1.0.7/iconify-icon.min.js"></script>

  @stack('style-lib')

  @stack('style')

</head>
  <body>

  @if(View::hasSection('header')) @yield('header') @endif
  @if(View::hasSection('container')) @yield('container') @else <div id="appCapsule" class="pb-2" style="padding: 0;"> @endif
  @yield('content')

  @include($activeTemplate.'layouts.app_footer')
  </div>

  @stack('script-lib')

  @stack('script')

  @include('partials.plugins')

  <script src="{{ asset('users/assets/app') }}/js/mui.min.js"></script>
  <script src="{{ asset('users/assets/app') }}/js/mui.loading.js"></script>
  <script src="{{ asset('users/assets/app') }}/js/app.js"></script>

  @include('partials.notify')
  </body>
</html>
