<!-- meta tags and other links -->
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">

  @include('partials.seo')

  <title>@if(View::hasSection('pageTitle')) @yield('pageTitle') @else {{ config('settings')->sitename(__($pageTitle)) }} @endif</title>
  <link rel="shortcut icon" type="image/x-icon" href="{{ asset('users/assets/invest') }}/img/favicon.png" />
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/tiny-slider/2.9.4/tiny-slider.css">
  <link rel="stylesheet" href="{{ asset('users/assets/basic/css/style.css') }}" >
  <script src="https://code.iconify.design/iconify-icon/1.0.7/iconify-icon.min.js"></script>
  <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>

  @stack('style-lib')

  @stack('style')

</head>
  <body>

    <div class="main-container">

        <div class="bg-red"></div>

        <div class="w-full">
        @yield('content')
        @include($activeTemplate. 'layouts.home_footer')
        </div>

  @stack('script-lib')

  @stack('script')

  @include('partials.plugins')

  @include('partials.notify')


    <script>

        (function ($) {
            "use strict";
            $(".langSel").on("change", function() {
                window.location.href = "{{route('home')}}/change/"+$(this).val() ;
            });

        })(jQuery);

    </script>


  </body>
</html>
