@extends($activeTemplate.'layouts.home')

@push('style')
@endpush


@section('content')
@include($activeTemplate. 'layouts.home_navprev')

<script>
    "use strict"

    function createCountDown(elementId, sec) {
        var tms = sec;
        var x = setInterval(function() {
            var distance = tms * 1000;
            var days = Math.floor(distance / (1000 * 60 * 60 * 24));
            var hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
            var minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
            var seconds = Math.floor((distance % (1000 * 60)) / 1000);
            document.getElementById(elementId).innerHTML = hours + "h " + minutes + "m " + seconds + "s ";
            if (distance < 0) {
                clearInterval(x);
                document.getElementById(elementId).innerHTML = "-";
            }
            tms--;
        }, 1000);
    }
</script>

<div class="inner-wrapper-with-header">
    <div class="team-container transaction-detail !p-0 flex flex-col gap-y-2 !bg-transparent">

        <!-- balance -->
        <div class="balance">
            <p>Pending Rewards</p>
            <p>{{ Session::get('currency_sym') }}{{ showAmount($pending_reward) }}</p>
        </div>
        <!-- end balance -->

        <!-- details -->
        <div class="details">

            @forelse($rewards as $reward)
            @php
            $nextTime = \Carbon\Carbon::parse($reward->expired_date);
            @endphp

            <script>
                createCountDown('counter<?php echo $reward->id; ?>', {{ $nextTime->diffInSeconds() }});
            </script>

            <!-- detail 01 -->
            <div class="detail">
                <div>
                    <p>{{ $reward->summary }}</p>
                    <p><a href="@if(config('settings')->reward_claim_active) {{ route('user.reward.claim', ['id' => $reward->identifier ]) }} @else javascript:void(0); @endif" class="btn-sm-pk">Claim</a></p>
                </div>

                <div>
                    <p>{{ $reward->currency }}{{ showAmount($reward->amount) }}</p>
                    <p><iconify-icon icon="mingcute:time-line"></iconify-icon> End Soon: <span id="counter{{$reward->id}}"> </span></p>
                </div>
            </div>
            @empty
            <!-- No rewards  -->
            <div class="detail">
                <div>
                    <p>No any rewards. Invest and get {{ getAmount(config('settings')->reward_rate) }}% cashback</p>
                </div>
            </div>
            @endforelse

        </div>
        <!-- end details -->
    </div>
</div>
@endsection

@push('script')
@endpush