@extends("layouts.dash")

@push("page_title") Login @endpush

@push('style')

@endpush

@section('header')
{{--<div>
    <p class="text-2xl font-semibold">Hello</p>
    <p class="text-sm">Log in to your account</p>
</div>--}}
@endsection

@section('content')
<div class="form-container">
    <div class="form">
        <p>Welcome Back!</p>
    
        <!-- input 01 -->
        <div class="input-group">
            <div>
                <p>Phone</p>
                <div>+234</div>
                <input autofocus="true" id="username" type="number" max="10" class="outline-none bg-transparent flex-grow py-3" placeholder="Phone Number"/>
            </div>
        </div>

        <!-- input 02 -->
        <div class="input-group">
            <div>
                <p>Password</p>
                <input placeholder="Write password" id="password"type="password" max="10" class="outline-none bg-transparent flex-grow py-3" />
                {{--<iconify-icon data-role="show-password" width="24" height="24" icon="mi:eye"></iconify-icon>
                <iconify-icon class="hidden" data-role="hide-password" width="24" height="24" icon="mdi:eye-off-outline"></iconify-icon>--}}
            </div>
        </div>

        @csrf

        <a href="javascript::void(0);" class="forget-psw">Forget Password</a>

        <button type="button" class="login-button" id="btn-submit">Login</button>

        <div class="auth-footer">
            <p>Or</p>
            <a href="{{ route('user.register') }}" class="button">Register</a>
        </div>

    </div>
</div>
@endsection

@push('script')
<script>
    $('#username').on('keyup', function() {
        
        // Get value
        var inputValue = $(this).val();

        // Remove non-digit characters
        var numericValue = inputValue.replace(/\D/g, '');

        // Keep value to 10 digits
        var truncatedValue = numericValue.slice(0, 10);

        // Update the input value
        $(this).val(truncatedValue);
    });

    $('#btn-submit').on('click', function() {
        
        // Form input Value
        var username = $('#username');
        var password = $('#password');
        var token = document.querySelector('input[name="_token"]').value;

        // Enable form submit
        var is_status = true;

        // Verify input
        if (!username.val()) {
            modalMessage('Please enter your Phone Number');
            is_status = false;
        }

        if (!password.val()) {
            modalMessage('Please enter your password');
            is_status = false;
        }
        // End Verify

        if (is_status) {
            $.ajax({
                url: "",
                type: 'POST',
                data: {
                    password: password.val(),
                    username: username.val(),
                    _token: token
                },
                beforeSend: function() {
                    // Handle before sending the request
                    mui.showLoading("Please wait...", "div");
                },
                success: function(data) {
                    
                    // Redirect
                    modalMessage('Login Successful', 200, data.intended);
                },
                error: function(xhr, status, error) {
                    var data = JSON.parse(xhr.responseText);
                    var responseMessage = data.message

                    // Validator message
                    if (data.errors) {
                        var errorMessages = [];
                        for (var key in data.errors) {
                            if (data.errors.hasOwnProperty(key)) {
                                errorMessages.push(data.errors[key][0]);
                            }
                        }

                        responseMessage = errorMessages.join(", ")
                    }

                    // Redirect
                    if(data.link) {
                        modalMessage(data.message, 400, data.link);
                        return true;
                    }

                    mui.hideLoading();
                    modalMessage(responseMessage);
                }
            });
        }
    })
</script>
@endpush