@extends("layouts.auth")

@push("page_title") Login @endpush

@push('style')
<style>
    .appHeader {
        background: none;
    }

    .long img {
        width: 170px;
        display: block;
        margin: auto;
    }

    .longbane img {
        width: 100%;
        position: absolute;
        bottom: 0;
    }

    .weui_hearder {
        position: inherit;
    }

    .poho {
        display: flex;
        background-color: #f9f9f9;
        border: 1px solid #dcdcdc;
        border-radius: 8px;
    }

    .poho span {
        padding: 0 10px;
        height: 45px;
        line-height: 45px;
    }

    .poho input {
        border: none;
    }

    .bne h2 {
        color: #fff;
    }
</style>
@endpush

@section('content')
<div class="appContent mt-3">

    <div class="sectionTitle mb-1 text-center">
        <div class="bne text-center mb-3">
            <img src="{{ asset('users/assets/app') }}/img/logo.png" width="100">
            {{--<h2>Reset Password</h2>--}}</br>
            <span>Enter your details</span>
        </div>
    </div>
    <div class="banyue p-2">

        <form class="form-group" method="post" autocomplete="off">
            <div class="form-group">
                <label class="label" for="username">Mobile</label>
                <div class="poho">
                    <span>+234</span>
                    <input type="number" id="username" class="form-control" placeholder="Please enter number">
                </div>
            </div>

            <div>
                <button type="button" class="btn btn-primary btn-lg btn-block" id="btn-submit">
                    Submit
                </button>
            </div>
            @csrf

        </form>
        
        <div class="mt-2 ">
           Remember Password? Try to <a href="{{ route('user.login') }}">Log in</a>
        </div>

    </div>

</div>
@endsection

@push('script')
<script>
    $('#username').on('keyup', function() {
        
        // Get value
        var inputValue = $(this).val();

        // Remove non-digit characters
        var numericValue = inputValue.replace(/\D/g, '');

        // Keep value to 10 digits
        var truncatedValue = numericValue.slice(0, 10);

        // Update the input value
        $(this).val(truncatedValue);
    });
    
    $('#btn-submit').on('click', function() {
        
        // Form input Value
        var username = $('#username');
        var token = document.querySelector('input[name="_token"]').value;

        // Enable form submit
        var is_status = true;

        // Verify input
        if (!username.val()) {
            modalMessage('Please enter your mobile');
            is_status = false;
            return true;
        }
        // End Verify

        if (is_status) {
            $.ajax({
                url: "{{ route('user.password.email') }}",
                type: 'POST',
                data: {
                    username: username.val(),
                    _token: token
                },
                beforeSend: function() {
                    // Handle before sending the request
                    mui.showLoading("Please wait...", "div");
                },
                success: function(data) {
                    
                    // Redirect
                    modalMessage(data.message, 200, data.link);
                },
                error: function(xhr, status, error) {
                    var data = JSON.parse(xhr.responseText);
                    var responseMessage = data.message

                    // Validator message
                    if (data.errors) {
                        var errorMessages = [];
                        for (var key in data.errors) {
                            if (data.errors.hasOwnProperty(key)) {
                                errorMessages.push(data.errors[key][0]);
                            }
                        }

                        responseMessage = errorMessages.join(", ")
                    }

                    // Redirect
                    if(data.link) {
                        modalMessage(data.message, 400, data.link);
                        return true;
                    }

                    mui.hideLoading();
                    modalMessage(responseMessage);
                }
            });
        }
    })
</script>
@endpush