@extends("layouts.dash")

@section('pageTitle') Register @endsection

@push('style')

@endpush

@section('header')
{{--<div>
    <p class="">Hello</p>
    <p class="">Create a new account</p>
    <p class="">Register to get <span>N1000</span> bonus</p>
</div>--}}
@endsection

@section('content')
<div class="form-container">
    <div class="form">
        <p>Register new account</p>
    
        <!-- input 01 -->
        <div class="input-group">
            <div>
                <p>Invite code</p>
                <!-- <div>+234</div> -->
                <input autofocus="true" id="invite" type="text" max="10" class="outline-none bg-transparent flex-grow py-3" value="{{ Session::get('reference') }}" placeholder="" />
            </div>
        </div>

        <!-- input 01 -->
        <div class="input-group">
            <div>
                <p>Phone</p>
                <div class="phone-code">+234</div>
                <input id="username" type="number" max="10" class="outline-none bg-transparent flex-grow py-3" placeholder="Mobile Number" autocomplete="off" />
            </div>
        </div>

        <!-- input 02 -->
        <div class="input-group">
            <div>
                <p>Password</p>
                <input placeholder="Write password" id="password" type="password" max="10" class="outline-none bg-transparent flex-grow py-3" autocomplete="off" />
                {{--<iconify-icon data-role="show-password" width="24" height="24" icon="mi:eye"></iconify-icon>
                <iconify-icon class="hidden" data-role="hide-password" width="24" height="24" icon="mdi:eye-off-outline"></iconify-icon>--}}
            </div>
        </div>

        <!-- input 02 -->
        <div class="input-group">
            <div>
                <p>Confirm</p>
                <input placeholder="Confirm password" id="confirm_password" type="password" max="10" class="outline-none bg-transparent flex-grow py-3" autocomplete="off" />
                {{--<iconify-icon data-role="show-password" width="24" height="24" icon="mi:eye"></iconify-icon>
                <iconify-icon class="hidden" data-role="hide-password" width="24" height="24" icon="mdi:eye-off-outline"></iconify-icon>--}}
            </div>
        </div>

        @php
            generateCaptchaImage();
        @endphp

        <!-- input 02 -->
        <div class="input-group">
            <div>
                <p>{{ Session::get('captcha_code') }}</p>
                <input placeholder="Token" id="captcha" type="text" max="10" class="outline-none bg-transparent flex-grow py-3" autocomplete="off" />
                {{--<p></p>--}}
            </div>
        </div>
        @csrf

        <button type="button" class="login-button" id="btn-submit">Register</button>

        <div class="auth-footer">
            <p>Or</p>
            <a href="{{ route('user.login') }}" class="button">Login</a>
        </div>

        <!-- <p class="text-center text-sm">Don't have an account? <br /></p> -->

    </div>
</div>
@endsection

@push('script')
<script>
    function refreshCaptcha() {
        // Reload the CAPTCHA image
        document.querySelector('#security_image').src = "{{ route('security.image') }}?" + new Date().getTime();
    }

    $('#username').on('keyup', function() {
        
        // Get value
        var inputValue = $(this).val();

        // Remove non-digit characters
        var numericValue = inputValue.replace(/\D/g, '');

        // Keep value to 10 digits
        var truncatedValue = numericValue.slice(0, 10);

        // Update the input value
        $(this).val(truncatedValue);
    });

    $('#btn-submit').on('click', function() {
        
        // Form input Value
        var username = $('#username');
        var password = $('#password');
        var password_confirmation = $('#confirm_password');
        var invite = $('#invite');
        var captcha = $('#captcha');
        var token = document.querySelector('input[name="_token"]').value;

        // Enable form submit
        var is_status = true;

        // Verify input
        if (!username.val()) {
            modalMessage('Please enter your Mobile Number');
            is_status = false;
            return true;
        }

        if (!password.val()) {
            modalMessage('Please enter your password');
            is_status = false;
            return true;
        }

        if (!password_confirmation.val()) {
            modalMessage('Please confirm your password');
            is_status = false;
            return false;
        }

        if (!captcha.val()) {
            modalMessage('Please enter security code');
            is_status = false;
            return true;
        }
        // End Verify

        if (is_status) {
            $.ajax({
                url: "",
                type: 'POST',
                data: {
                    username: username.val(),
                    mobile: username.val(),
                    password: password.val(),
                    password_confirmation: password_confirmation.val(),
                    referBy: invite.val(),
                    captcha: captcha.val(),
                    _token: token
                },
                beforeSend: function() {
                    // Handle before sending the request
                    mui.showLoading("Please wait...", "div");
                },
                success: function(data) {
                    
                    // Redirect
                    modalMessage('Registered Successfully', 200, "{{ url(route('user.home')) }}");
                },
                error: function(xhr, status, error) {
                    var data = JSON.parse(xhr.responseText);
                    var responseMessage = data.message

                    // Validator message
                    if (data.errors) {
                        var errorMessages = [];
                        for (var key in data.errors) {
                            if (data.errors.hasOwnProperty(key)) {
                                errorMessages.push(data.errors[key][0]);
                            }
                        }

                        responseMessage = errorMessages.join(", ")
                    }

                    // Redirect
                    if(data.link) {
                        modalMessage(data.message, 400, data.link);
                        return true;
                    }

                    mui.hideLoading();
                    modalMessage(responseMessage);
                }
            });
        }
    })
</script>
@endpush