@extends($activeTemplate.'layouts.home')

@push('style')
@endpush

@section('wrapper')<div class="wrapper">@endsection

@section('header')
@include($activeTemplate. 'layouts.home_navprev')
@endsection

@php
$accountNumber = (auth()->user()->bankAccount) ? auth()->user()->bankAccount->account_number : '';
$accountName = (auth()->user()->bankAccount) ? auth()->user()->bankAccount->account_name : '';
$bankName = (auth()->user()->bankAccount) ? auth()->user()->bankAccount->bank_name : '';
$bankCode = (auth()->user()->bankAccount) ? auth()->user()->bankAccount->bank_code : '';
@endphp

@section('content')
<!-- package container -->
<div class="message-box">

    <!-- About sample -->
    <form action="" method="post" role="form" class="message set-password" autocomplete="off">
        @csrf
        <select name="bank_code" id="bank_name">
            <option class="text-black" value="">Select</option>
            @foreach($banks as $bank)
                <option class="text-black" value="{{ $bank['bank_code'] }}" @if($bankCode == $bank['bank_code']) selected @endif >{{ $bank['name'] }}</option>
            @endforeach
        </select>

        <input type="text" name="account_number" id="account" value="{{ $accountNumber }}" class="form-control" placeholder="Account number" />

        <input name="account_name" id="account_name" value="{{ $accountName }}" type="text" placeholder="Account name" />
        
        <input value="{{ $bankName }}" type="hidden" name="bank_name" id="bank_code">

        <button type="submit">@lang('Save Bank')</button>
    </form>
    <!-- end about sample -->
</div>
@endsection

@push('script')
<textarea style="display: none;" id="all_banks">{!! $all_banks !!}</textarea>

<script>
    let all_banks = JSON.parse($("#all_banks").val());
    //console.info(all_banks);
    (function ($) {
        "use strict";


        function getByValue(value) {

            let arr = all_banks;
            for (var i = 0, iLen = arr.length; i < iLen; i++) {
                //console.log(arr[i]);
                if (arr[i].bank_code == value) return arr[i].name;
            }
        }


        $("#bank_name").change(function (e) {
            //alert($(this).val());
            //let code = $("#bank_name").val(); //getByValue().bank_code;
            //let account = $("#account").val();

            //console.log(t, code);


            let code = $("#bank_name").val(); //getByValue().bank_code;
            let account = $("#account").val();

            //console.log(code, account);

            let t = getByValue(code);

            //console.log(t);

            $("#bank_code").val(t);
            if (account != "" && code != "") {

                get_account_info(code, account);

                //console.log(account, code);
            }

        });

        $("#account").change(function () {

            let code = $("#bank_name").val();// getByValue($("#bank_name").val()).bank_code;
            let account = $("#account").val();
            if (account == "" || code == "") {
                $("#reg").prop('disabled', true);
                $("#account_name").val("");
                $(".text-error").text("Your bank name and account number are required, please try again");
                return;
            }

            get_account_info(code, account);

            //console.log(account, code);


        });


        function get_account_info(code, account) {

            $(".preloaders").show();
            $(".text-error").text("Fetching account details");

            $.ajax({
                url: "{{ route('account.fetch') }}",
                type: 'get',
                dataType: 'json',
                data: {
                    'bank-verification': '',
                    'code': code,
                    'account': account
                },
                success: function (response) {
                    if (response.status == "error") {
                        $("#account_name").val("");
                        $(".preloaders").hide();
                        //$(".text-error").text("Could not resolve account name, please check your account number or bank name and try again");
                        $(".text-error").text("");
                        $("#reg").prop('disabled', false);
                        return;
                    }

                    $(".text-error").text("");
                    $("#reg").removeAttr('disabled');
                    $(".preloaders").hide();
                    console.log(response.data);
                    $("#account_name").val(response.data.account_name);

                    //console.log(response);
                },

                error: function (err) {
                    console.log(err.responseText);
                    $(".preloaders").hide();
                }
            });
        }

    })(jQuery);
</script>
@endpush