@extends($activeTemplate.'layouts.home')

@push('style')
@endpush

@section('wrapper')<div class="wrapper">@endsection

@section('header')
@include($activeTemplate. 'layouts.home_navprev')
@endsection

@section('content')
<!-- package container -->
<div class="message-box">

    <!-- About sample -->
    <form action="" method="post" role="form" class="message set-password" autocomplete="off">
        @csrf
        <input type="text" name="code" id="code" value="" placeholder="Gift Code" />

        <button type="button" id="btn-pay">@lang('Redeem')</button>
    </form>
    <!-- end about sample -->
</div>
@endsection

@push('script')
<script>
    $('#btn-pay').on('click', function() {
        
        // Data
        var code = $('#code').val();
        var token = document.querySelector('input[name="_token"]').value;

        $.ajax({
            url: "{{ route('user.gift.redeem') }}",
            type: 'POST',
            data: {
                'code': code,
                _token: token
            },
             beforeSend: function() {
                // Handle before sending the request
                mui.showLoading("Please wait...", "div");
            },
            success: function(data) {
                
                // Redirect
                if(data.link) {
                    modalMessage(data.message, 200, data.link);
                    return true;
                }
                mui.hideLoading();
                modalMessage(data.message);
            },
            error: function(xhr, status, error) {
                var data = JSON.parse(xhr.responseText);
                var responseMessage = data.message

                // Validator message
                if (data.errors) {
                    var errorMessages = [];
                    for (var key in data.errors) {
                        if (data.errors.hasOwnProperty(key)) {
                            errorMessages.push(data.errors[key][0]);
                        }
                    }

                    responseMessage = errorMessages.join(", ")
                }

                // Redirect
                if(data.link) {
                    modalMessage(data.message, 400, data.link);
                    return true;
                }

                mui.hideLoading();
                modalMessage(responseMessage);
            }
        });
    })
</script>
@endpush