@extends($activeTemplate.'layouts.home')

@push('style')
<link rel="stylesheet" href="{{ asset('users/assets/payment') }}/css/payment.css" >
@endpush

@section('container')<div>@endsection
@section('wrapper')<div>@endsection
@section('header')@endsection
@section('content')

@if($data->try == 1)
    @php
        $auto_details = json_decode($data->btc_wallet);
    @endphp
@endif
<form action="{{ route('user.deposit.manual.update') }}" method="POST" enctype="multipart/form-data" class="payment-container">
<div>
    <!-- title with counterv and hour glasse -->
    <div class="title">
    <div>
        <img src="{{ asset('users/assets/invest') }}/img/paymethod/hourglass.svg" alt="hourglass">
        
        <!-- countdown container -->
        <p id="count-down"></p>
    </div>
    </div>
    <!-- end title -->

    <!-- step 1 -->
    <div class="step one">
        <!-- Local Payment -->
        @if($data['method_code'] == '1001')
            @include($activeTemplate. 'user.manual_payment.bank_pay_info')
        @endif
        <!-- Crypto Payment -->
        @if(in_array($data['method_code'], ['1000', '1012', '1013'])) 
            @include($activeTemplate. 'user.manual_payment.usdt_pay_info')
        @endif
    </div>

    <!-- step 2 -->
    <div class="step two">
        <p>Step two: Copy transfer narration</p>
        <div>
            <div>
                <p>Narration</p>
                <div>
                    <p>{{ $data['trx'] }}</p>
                    <button type="button" role="copy">Copy</button>
                </div>
            </div>
        </div>
    </div>

    @if($data['try'] == 0)
    <!-- step 3 -->
    <div class="step three sender-info">
        <p>Step three: Proof of payment</p>

        <div>
            @if(session()->has('notify'))
                @foreach(session('notify') as $msg)<span style="color:darkred;">{{ $msg[1] }}</span>@endforeach
            @endif

            @if($errors->any())
                @foreach ($errors->all() as $error)
                    <span style="color:darkred;">{{ $error }}</span>
                @endforeach
            @endif
            
            @if($method->gateway_parameter)

                @foreach(json_decode($method->gateway_parameter) as $k => $v)

                    @if($v->type == "text")
                        <!-- input -->
                        <input type="text" placeholder="Enter {{__(inputTitle($v->field_level))}}" name="{{$k}}" max="10" value="{{old($k)}}"/>

                    @elseif($v->type == "textarea")
                        <!-- input -->
                        <textarea name="{{$k}}" placeholder="{{__($v->field_level)}}" rows="3">{{old($k)}}</textarea>
                    @elseif($v->type == "file")
                        <!-- input -->
                        <label class="select-file" for="{{$k}}">
                            <p>No File Chosen</p>
                            <input onChange="this.previousElementSibling.innerHTML = this.files[0].name" id="{{$k}}" name="{{$k}}" type="file">
                            <p>Choose File</p>
                        </label>
                    @endif
                @endforeach
            @endif
        </div>
    </div>
    @endif

    <!-- step 3 -->
    <div class="step four guide">
        <p>Payment Guide</p>
        <div>
            @if($data['method_currency'] == 'NGN')
                <p>Open your bank app and make the transfer, Copy the bank account shown below and input the amoun shown above</p>
            @else
                <p>Transfer your payment as showing and make sure you send to the right address to escape loss. After payment done then submit proof of payment.</p>
            @endif
        </div>
    </div>
    <!-- submi button -->
    <div>
        <button type="submit" class="submit-btn">I have paid payment</button>
    </div>
</div>
</form>
@endsection

@push('script')

<script src="{{ asset('users/assets/invest') }}/js/copypaste.js"></script>
<script  src="{{ asset('users/assets/invest') }}/js/pageTimeOut.js"></script>
<script>
    pageTimeOutCountDown({
        initialValue: 596,
        redirectTo:'{{ route('user.transaction') }}',
        containerId:'count-down'
    })
</script>
@endpush
